/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function.polynomial;

import java.util.List;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.ArrayUtils;
import org.ojalgo.function.polynomial.PolynomialFunction;
import org.ojalgo.series.NumberSeries;

abstract class AbstractPolynomial<N extends Number>
implements PolynomialFunction<N> {
    private final Array1D<N> myCoefficients;
    private transient AbstractPolynomial<N> myDerivative = null;
    private transient AbstractPolynomial<N> myPrimitive = null;

    private AbstractPolynomial() {
        this(null);
    }

    protected AbstractPolynomial(Array1D<N> someCoefficients) {
        this.myCoefficients = someCoefficients;
    }

    @Override
    public final PolynomialFunction<N> buildDerivative() {
        if (this.myDerivative == null) {
            int tmpSize = Math.max(1, this.myCoefficients.size() - 1);
            this.myDerivative = this.makeInstance(tmpSize);
            for (int i = 0; i < tmpSize; ++i) {
                this.myDerivative.set(i, this.getDerivativeFactor(i));
            }
        }
        return this.myDerivative;
    }

    @Override
    public final PolynomialFunction<N> buildPrimitive() {
        if (this.myPrimitive == null) {
            int tmpSize = this.myCoefficients.size() + 1;
            this.myPrimitive = this.makeInstance(tmpSize);
            for (int i = 0; i < tmpSize; ++i) {
                this.myPrimitive.set(i, this.getPrimitiveFactor(i));
            }
        }
        return this.myPrimitive;
    }

    @Override
    public long count() {
        return this.size();
    }

    @Override
    public final int degree() {
        return this.myCoefficients.size() - 1;
    }

    @Override
    public final double doubleValue(long aPower) {
        return this.myCoefficients.doubleValue(aPower);
    }

    @Override
    public final void estimate(List<? extends Number> x, List<? extends Number> y) {
        this.estimate(ArrayUtils.wrapAccess1D(x), ArrayUtils.wrapAccess1D(y));
    }

    @Override
    public final void estimate(NumberSeries<?> samples) {
        this.estimate(samples.accessKeys(), samples.accessValues());
    }

    @Override
    public final N get(long aPower) {
        return this.myCoefficients.get(aPower);
    }

    @Override
    public final double invoke(double arg) {
        int tmpPower = this.degree();
        double retVal = this.doubleValue(tmpPower);
        while (--tmpPower >= 0) {
            retVal = this.doubleValue(tmpPower) + arg * retVal;
        }
        return retVal;
    }

    @Override
    public final void set(int aPower, double aNmbr) {
        this.myCoefficients.set((long)aPower, aNmbr);
        this.myDerivative = null;
        this.myPrimitive = null;
    }

    @Override
    public final void set(int aPower, N aNmbr) {
        this.myCoefficients.set(aPower, (Number)aNmbr);
        this.myDerivative = null;
        this.myPrimitive = null;
    }

    public final int size() {
        return this.myCoefficients.size();
    }

    protected abstract N getDerivativeFactor(int var1);

    protected abstract N getPrimitiveFactor(int var1);

    protected abstract AbstractPolynomial<N> makeInstance(int var1);
}

