/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.jmx;

import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.http.HttpServerFunctionalTest;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestJMXJsonServletNaNFiltered
extends HttpServerFunctionalTest {
    private static HttpServer2 server;
    private static URL baseUrl;

    @BeforeClass
    public static void setup() throws Exception {
        Configuration configuration = new Configuration();
        configuration.setBoolean("hadoop.http.jmx.nan-filter.enabled", true);
        server = TestJMXJsonServletNaNFiltered.createTestServer(configuration);
        server.start();
        baseUrl = TestJMXJsonServletNaNFiltered.getServerURL(server);
    }

    @AfterClass
    public static void cleanup() throws Exception {
        server.stop();
    }

    public static void assertReFind(String re, String value) {
        Pattern p = Pattern.compile(re);
        Matcher m = p.matcher(value);
        TestJMXJsonServletNaNFiltered.assertTrue((String)("'" + p + "' does not match " + value), (boolean)m.find());
    }

    @Test
    public void testQuery() throws Exception {
        System.setProperty("THE_TEST_OF_THE_NAN_VALUES", String.valueOf(Float.NaN));
        String result = TestJMXJsonServletNaNFiltered.readOutput(new URL(baseUrl, "/jmx"));
        TestJMXJsonServletNaNFiltered.assertReFind("\"name\"\\s*:\\s*\"java.lang:type=Memory\"", result);
        TestJMXJsonServletNaNFiltered.assertReFind("\"key\"\\s*:\\s*\"THE_TEST_OF_THE_NAN_VALUES\"\\s*,\\s*\"value\"\\s*:\\s*0.0", result);
    }
}

