/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.util;

import java.net.URI;
import lombok.Generated;
import lombok.NonNull;

public final class S3URI {
    @NonNull
    private final String bucket;
    @NonNull
    private final String key;
    private static String URI_FORMAT_STRING = "%s://%s/%s";
    private static String URI_SCHEME_DEFAULT = "s3";

    public URI toURI() {
        return this.toURI(URI_SCHEME_DEFAULT);
    }

    public URI toURI(String scheme) {
        return URI.create(this.toString(scheme));
    }

    public String toString() {
        return this.toString(URI_SCHEME_DEFAULT);
    }

    public String toString(@NonNull String scheme) {
        if (scheme == null) {
            throw new NullPointerException("scheme is marked non-null but is null");
        }
        return String.format(URI_FORMAT_STRING, scheme, this.getBucket(), this.getKey());
    }

    @Generated
    private S3URI(@NonNull String bucket, @NonNull String key) {
        if (bucket == null) {
            throw new NullPointerException("bucket is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.bucket = bucket;
        this.key = key;
    }

    @Generated
    public static S3URI of(@NonNull String bucket, @NonNull String key) {
        if (bucket == null) {
            throw new NullPointerException("bucket is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return new S3URI(bucket, key);
    }

    @NonNull
    @Generated
    public String getBucket() {
        return this.bucket;
    }

    @NonNull
    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof S3URI)) {
            return false;
        }
        S3URI other = (S3URI)o;
        String this$bucket = this.getBucket();
        String other$bucket = other.getBucket();
        if (this$bucket == null ? other$bucket != null : !this$bucket.equals(other$bucket)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        return !(this$key == null ? other$key != null : !this$key.equals(other$key));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $bucket = this.getBucket();
        result = result * 59 + ($bucket == null ? 43 : $bucket.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        return result;
    }
}

