/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.io.logical.impl;

import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Operation;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Telemetry;
import software.amazon.s3.analyticsaccelerator.io.logical.LogicalIOConfiguration;
import software.amazon.s3.analyticsaccelerator.io.physical.PhysicalIO;
import software.amazon.s3.analyticsaccelerator.io.physical.plan.IOPlan;
import software.amazon.s3.analyticsaccelerator.request.Range;
import software.amazon.s3.analyticsaccelerator.request.ReadMode;
import software.amazon.s3.analyticsaccelerator.util.S3URI;
import software.amazon.s3.analyticsaccelerator.util.StreamAttributes;

public class SequentialPrefetcher {
    private final PhysicalIO physicalIO;
    private final Telemetry telemetry;
    private final S3URI s3URI;
    private boolean prefetchStarted = false;
    private final long prefetchSize;
    private static final Logger LOG = LoggerFactory.getLogger(SequentialPrefetcher.class);
    private static final String OPERATION_SEQUENTIAL_PREFETCH = "sequential.prefetcher.prefetch";

    public SequentialPrefetcher(@NonNull S3URI s3URI, @NonNull PhysicalIO physicalIO, @NonNull Telemetry telemetry, @NonNull LogicalIOConfiguration logicalIOConfiguration) {
        if (s3URI == null) {
            throw new NullPointerException("s3URI is marked non-null but is null");
        }
        if (physicalIO == null) {
            throw new NullPointerException("physicalIO is marked non-null but is null");
        }
        if (telemetry == null) {
            throw new NullPointerException("telemetry is marked non-null but is null");
        }
        if (logicalIOConfiguration == null) {
            throw new NullPointerException("logicalIOConfiguration is marked non-null but is null");
        }
        this.s3URI = s3URI;
        this.physicalIO = physicalIO;
        this.telemetry = telemetry;
        this.prefetchSize = logicalIOConfiguration.getPartitionSize();
    }

    public void prefetch(long position) {
        try {
            if (this.prefetchStarted) {
                return;
            }
            this.prefetchStarted = true;
            long contentLength = this.physicalIO.metadata().getContentLength();
            long endPosition = Math.min(position + this.prefetchSize, contentLength);
            this.telemetry.measureVerbose(() -> (Operation)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)Operation.builder().name(OPERATION_SEQUENTIAL_PREFETCH)).attribute(StreamAttributes.uri(this.s3URI))).attribute(StreamAttributes.range(position, endPosition - 1L))).build(), () -> {
                IOPlan prefetchPlan = new IOPlan(new Range(position, endPosition - 1L));
                return this.physicalIO.execute(prefetchPlan, ReadMode.SEQUENTIAL_FILE_PREFETCH);
            });
        }
        catch (Exception e) {
            LOG.debug("Error during prefetch operation for {}", (Object)this.s3URI.getKey(), (Object)e);
        }
    }
}

