/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ClusterNodeTracker;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VisitedResourceRequestTracker {
    private static final Logger LOG = LoggerFactory.getLogger(VisitedResourceRequestTracker.class);
    private final Map<Priority, Map<Resource, TrackerPerPriorityResource>> map = new HashMap<Priority, Map<Resource, TrackerPerPriorityResource>>();
    private final ClusterNodeTracker<FSSchedulerNode> nodeTracker;

    VisitedResourceRequestTracker(ClusterNodeTracker<FSSchedulerNode> nodeTracker) {
        this.nodeTracker = nodeTracker;
    }

    boolean visit(ResourceRequest rr) {
        TrackerPerPriorityResource tracker;
        Priority priority = rr.getPriority();
        Resource capability = rr.getCapability();
        Map<Resource, TrackerPerPriorityResource> subMap = this.map.get(priority);
        if (subMap == null) {
            subMap = new HashMap<Resource, TrackerPerPriorityResource>();
            this.map.put(priority, subMap);
        }
        if ((tracker = subMap.get(capability)) == null) {
            tracker = new TrackerPerPriorityResource();
            subMap.put(capability, tracker);
        }
        return tracker.visit(rr.getResourceName());
    }

    private class TrackerPerPriorityResource {
        private Set<String> racksWithNodesVisited = new HashSet<String>();
        private Set<String> racksVisited = new HashSet<String>();
        private boolean anyVisited;

        private TrackerPerPriorityResource() {
        }

        private boolean visitAny() {
            if (this.racksVisited.isEmpty() && this.racksWithNodesVisited.isEmpty()) {
                this.anyVisited = true;
            }
            return this.anyVisited;
        }

        private boolean visitRack(String rackName) {
            if (this.anyVisited || this.racksWithNodesVisited.contains(rackName)) {
                return false;
            }
            this.racksVisited.add(rackName);
            return true;
        }

        private boolean visitNode(String rackName) {
            if (this.anyVisited || this.racksVisited.contains(rackName)) {
                return false;
            }
            this.racksWithNodesVisited.add(rackName);
            return true;
        }

        private boolean visit(String resourceName) {
            FSSchedulerNode node;
            if (resourceName.equals("*")) {
                return this.visitAny();
            }
            List nodes = VisitedResourceRequestTracker.this.nodeTracker.getNodesByResourceName(resourceName);
            int numNodes = nodes.size();
            if (numNodes == 0) {
                LOG.error("Found ResourceRequest for a non-existent node/rack named " + resourceName);
                return false;
            }
            if (numNodes == 1 && (node = (FSSchedulerNode)nodes.get(0)).getNodeName().equals(resourceName)) {
                return this.visitNode(node.getRackName());
            }
            return this.visitRack(resourceName);
        }
    }
}

