/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.router.webapp.dao;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ClusterMetricsInfo;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RouterClusterMetrics {
    protected static final long BYTES_IN_MB = 0x100000L;
    private static final Logger LOG = LoggerFactory.getLogger(RouterClusterMetrics.class);
    private String webPageTitlePrefix = "Federation";
    private String appsSubmitted = "N/A";
    private String appsCompleted = "N/A";
    private String appsPending = "N/A";
    private String appsRunning = "N/A";
    private String appsFailed = "N/A";
    private String appsKilled = "N/A";
    private String totalMemory = "N/A";
    private String reservedMemory = "N/A";
    private String availableMemory = "N/A";
    private String allocatedMemory = "N/A";
    private String pendingMemory = "N/A";
    private String reservedVirtualCores = "N/A";
    private String availableVirtualCores = "N/A";
    private String allocatedVirtualCores = "N/A";
    private String pendingVirtualCores = "N/A";
    private String totalVirtualCores = "N/A";
    private String usedResources = "N/A";
    private String totalResources = "N/A";
    private String reservedResources = "N/A";
    private String allocatedContainers = "N/A";
    private String utilizedMBPercent = "N/A";
    private String utilizedVirtualCoresPercent = "N/A";
    private String activeNodes = "N/A";
    private String decommissioningNodes = "N/A";
    private String decommissionedNodes = "N/A";
    private String lostNodes = "N/A";
    private String unhealthyNodes = "N/A";
    private String rebootedNodes = "N/A";
    private String shutdownNodes = "N/A";

    public RouterClusterMetrics() {
    }

    public RouterClusterMetrics(ClusterMetricsInfo metrics) {
        if (metrics != null) {
            this.conversionApplicationInformation(metrics);
            this.conversionMemoryInformation(metrics);
            this.conversionResourcesInformation(metrics);
            this.conversionResourcesPercent(metrics);
            this.conversionNodeInformation(metrics);
        }
    }

    public RouterClusterMetrics(ClusterMetricsInfo metrics, String webPageTitlePrefix) {
        this(metrics);
        this.webPageTitlePrefix = webPageTitlePrefix;
    }

    public String getAppsSubmitted() {
        return this.appsSubmitted;
    }

    public String getAppsCompleted() {
        return this.appsCompleted;
    }

    public String getAppsPending() {
        return this.appsPending;
    }

    public String getAppsRunning() {
        return this.appsRunning;
    }

    public String getAppsFailed() {
        return this.appsFailed;
    }

    public String getAppsKilled() {
        return this.appsKilled;
    }

    public String getTotalMemory() {
        return this.totalMemory;
    }

    public String getReservedMemory() {
        return this.reservedMemory;
    }

    public String getAvailableMemory() {
        return this.availableMemory;
    }

    public String getAllocatedMemory() {
        return this.allocatedMemory;
    }

    public String getPendingMemory() {
        return this.pendingMemory;
    }

    public String getReservedVirtualCores() {
        return this.reservedVirtualCores;
    }

    public String getAvailableVirtualCores() {
        return this.availableVirtualCores;
    }

    public String getAllocatedVirtualCores() {
        return this.allocatedVirtualCores;
    }

    public String getPendingVirtualCores() {
        return this.pendingVirtualCores;
    }

    public String getTotalVirtualCores() {
        return this.totalVirtualCores;
    }

    public String getUsedResources() {
        return this.usedResources;
    }

    public String getTotalResources() {
        return this.totalResources;
    }

    public String getReservedResources() {
        return this.reservedResources;
    }

    public String getAllocatedContainers() {
        return this.allocatedContainers;
    }

    public String getUtilizedMBPercent() {
        return this.utilizedMBPercent;
    }

    public String getUtilizedVirtualCoresPercent() {
        return this.utilizedVirtualCoresPercent;
    }

    public String getActiveNodes() {
        return this.activeNodes;
    }

    public String getDecommissioningNodes() {
        return this.decommissioningNodes;
    }

    public String getDecommissionedNodes() {
        return this.decommissionedNodes;
    }

    public String getLostNodes() {
        return this.lostNodes;
    }

    public String getUnhealthyNodes() {
        return this.unhealthyNodes;
    }

    public String getRebootedNodes() {
        return this.rebootedNodes;
    }

    public String getShutdownNodes() {
        return this.shutdownNodes;
    }

    public void conversionApplicationInformation(ClusterMetricsInfo metrics) {
        try {
            this.appsSubmitted = String.valueOf(metrics.getAppsSubmitted());
            this.appsCompleted = String.valueOf(metrics.getAppsCompleted() + metrics.getAppsFailed() + metrics.getAppsKilled());
            this.appsPending = String.valueOf(metrics.getAppsPending());
            this.appsRunning = String.valueOf(metrics.getAppsRunning());
            this.appsFailed = String.valueOf(metrics.getAppsFailed());
            this.appsKilled = String.valueOf(metrics.getAppsKilled());
        }
        catch (Exception e) {
            LOG.error("conversionApplicationInformation error.", (Throwable)e);
        }
    }

    public void conversionMemoryInformation(ClusterMetricsInfo metrics) {
        try {
            this.totalMemory = StringUtils.byteDesc((long)(metrics.getTotalMB() * 0x100000L));
            this.reservedMemory = StringUtils.byteDesc((long)(metrics.getReservedMB() * 0x100000L));
            this.availableMemory = StringUtils.byteDesc((long)(metrics.getAvailableMB() * 0x100000L));
            this.allocatedMemory = StringUtils.byteDesc((long)(metrics.getAllocatedMB() * 0x100000L));
            this.pendingMemory = StringUtils.byteDesc((long)(metrics.getPendingMB() * 0x100000L));
        }
        catch (Exception e) {
            LOG.error("conversionMemoryInformation error.", (Throwable)e);
        }
    }

    public void conversionResourcesInformation(ClusterMetricsInfo metrics) {
        try {
            Resource metricReservedResources;
            Resource metricTotalResources;
            Resource metricUsedResources;
            int metricAllocatedContainers;
            if (metrics.getCrossPartitionMetricsAvailable()) {
                metricAllocatedContainers = metrics.getTotalAllocatedContainersAcrossPartition();
                metricUsedResources = metrics.getTotalUsedResourcesAcrossPartition().getResource();
                metricTotalResources = metrics.getTotalClusterResourcesAcrossPartition().getResource();
                metricReservedResources = metrics.getTotalReservedResourcesAcrossPartition().getResource();
                Resources.subtractFrom((Resource)metricUsedResources, (Resource)metricReservedResources);
            } else {
                metricAllocatedContainers = metrics.getContainersAllocated();
                metricUsedResources = Resource.newInstance((long)metrics.getAllocatedMB(), (int)((int)metrics.getAllocatedVirtualCores()));
                metricTotalResources = Resource.newInstance((long)metrics.getTotalMB(), (int)((int)metrics.getTotalVirtualCores()));
                metricReservedResources = Resource.newInstance((long)metrics.getReservedMB(), (int)((int)metrics.getReservedVirtualCores()));
            }
            this.usedResources = metricUsedResources.getFormattedString();
            this.totalResources = metricTotalResources.getFormattedString();
            this.reservedResources = metricReservedResources.getFormattedString();
            this.allocatedContainers = String.valueOf(metricAllocatedContainers);
        }
        catch (Exception e) {
            LOG.error("conversionResourcesInformation error.", (Throwable)e);
        }
    }

    public void conversionResourcesPercent(ClusterMetricsInfo metrics) {
        try {
            this.utilizedMBPercent = String.valueOf(metrics.getUtilizedMBPercent());
            this.utilizedVirtualCoresPercent = String.valueOf(metrics.getUtilizedVirtualCoresPercent());
        }
        catch (Exception e) {
            LOG.error("conversionResourcesPercent error.", (Throwable)e);
        }
    }

    public void conversionNodeInformation(ClusterMetricsInfo metrics) {
        try {
            this.activeNodes = String.valueOf(metrics.getActiveNodes());
            this.decommissioningNodes = String.valueOf(metrics.getDecommissioningNodes());
            this.decommissionedNodes = String.valueOf(metrics.getDecommissionedNodes());
            this.lostNodes = String.valueOf(metrics.getLostNodes());
            this.unhealthyNodes = String.valueOf(metrics.getUnhealthyNodes());
            this.rebootedNodes = String.valueOf(metrics.getRebootedNodes());
            this.shutdownNodes = String.valueOf(metrics.getShutdownNodes());
        }
        catch (Exception e) {
            LOG.error("conversionNodeInformation error.", (Throwable)e);
        }
    }

    public String getWebPageTitlePrefix() {
        return this.webPageTitlePrefix;
    }
}

