/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSDataOutputStreamBuilder;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.s3a.impl.InternalConstants;
import org.apache.hadoop.fs.s3a.impl.write.WriteObjectFlags;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.Progressable;

public class CreateFileBuilder
extends FSDataOutputStreamBuilder<FSDataOutputStream, CreateFileBuilder> {
    public static final EnumSet<CreateFlag> CREATE_OVERWRITE_FLAGS = EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE);
    public static final EnumSet<CreateFlag> CREATE_NO_OVERWRITE_FLAGS = EnumSet.of(CreateFlag.CREATE);
    public static final CreateFileOptions OPTIONS_CREATE_FILE_OVERWRITE = new CreateFileOptions(CREATE_OVERWRITE_FLAGS, EnumSet.of(WriteObjectFlags.Recursive), null, null);
    public static final CreateFileOptions OPTIONS_CREATE_FILE_NO_OVERWRITE = new CreateFileOptions(CREATE_NO_OVERWRITE_FLAGS, EnumSet.of(WriteObjectFlags.Recursive), null, null);
    public static final CreateFileOptions OPTIONS_CREATE_FILE_PERFORMANCE = new CreateFileOptions(CREATE_OVERWRITE_FLAGS, EnumSet.of(WriteObjectFlags.Performance, WriteObjectFlags.Recursive), null, null);
    private final CreateFileBuilderCallbacks callbacks;

    public CreateFileBuilder(@Nonnull FileSystem fileSystem, @Nonnull Path path, @Nonnull CreateFileBuilderCallbacks callbacks) {
        super(fileSystem, path);
        this.callbacks = callbacks;
    }

    public CreateFileBuilder getThisBuilder() {
        return this;
    }

    public FSDataOutputStream build() throws IOException {
        String etag;
        EnumSet<CreateFlag> flags;
        Path path = this.getPath();
        Configuration options = this.getOptions();
        HashMap<String, String> headers = new HashMap<String, String>();
        Set mandatoryKeys = this.getMandatoryKeys();
        EnumSet<WriteObjectFlags> createFileSwitches = EnumSet.noneOf(WriteObjectFlags.class);
        String headerPrefix = "fs.s3a.create.header.";
        int prefixLen = headerPrefix.length();
        Set keysToValidate = mandatoryKeys.stream().filter(key -> !key.startsWith(headerPrefix)).collect(Collectors.toSet());
        CreateFileBuilder.rejectUnknownMandatoryKeys(keysToValidate, InternalConstants.CREATE_FILE_KEYS, (String)("for " + path));
        for (Map.Entry option : options) {
            String key2 = (String)option.getKey();
            if (!key2.startsWith(headerPrefix) || key2.length() <= prefixLen) continue;
            headers.put(key2.substring(prefixLen), (String)option.getValue());
        }
        if (options.get("fs.option.create.content.type", null) != null) {
            headers.put("Content-Type", options.get("fs.option.create.content.type", null));
        }
        if ((flags = this.getFlags()).contains(CreateFlag.APPEND)) {
            throw new UnsupportedOperationException("Append is not supported");
        }
        if (!flags.contains(CreateFlag.CREATE) && !flags.contains(CreateFlag.OVERWRITE)) {
            throw new PathIOException(path.toString(), "Must specify either create or overwrite");
        }
        if (this.isRecursive()) {
            createFileSwitches.add(WriteObjectFlags.Recursive);
        }
        if (WriteObjectFlags.Performance.isEnabled(options)) {
            createFileSwitches.add(WriteObjectFlags.Performance);
        }
        if (WriteObjectFlags.CreateMultipart.isEnabled(options)) {
            createFileSwitches.add(WriteObjectFlags.CreateMultipart);
        }
        if (WriteObjectFlags.ConditionalOverwrite.isEnabled(options)) {
            createFileSwitches.add(WriteObjectFlags.ConditionalOverwrite);
        }
        if ((etag = options.get("fs.option.create.conditional.overwrite.etag", null)) != null) {
            createFileSwitches.add(WriteObjectFlags.ConditionalOverwriteEtag);
        }
        return this.callbacks.createFileFromBuilder(path, this.getProgress(), new CreateFileOptions(flags, createFileSwitches, etag, headers));
    }

    public CreateFileBuilder withFlags(EnumSet<CreateFlag> flags) {
        if (flags.contains(CreateFlag.CREATE)) {
            this.create();
        }
        if (flags.contains(CreateFlag.APPEND)) {
            this.append();
        }
        this.overwrite(flags.contains(CreateFlag.OVERWRITE));
        return this;
    }

    public EnumSet<CreateFlag> getFlags() {
        return super.getFlags();
    }

    public static final class CreateFileOptions {
        private final EnumSet<CreateFlag> flags;
        private final EnumSet<WriteObjectFlags> writeObjectFlags;
        private final String etag;
        private final Map<String, String> headers;

        public CreateFileOptions(EnumSet<CreateFlag> flags, EnumSet<WriteObjectFlags> writeObjectFlags, String etag, Map<String, String> headers) {
            this.flags = Objects.requireNonNull(flags);
            this.writeObjectFlags = Objects.requireNonNull(writeObjectFlags);
            if (this.writeObjectFlags().contains((Object)WriteObjectFlags.ConditionalOverwriteEtag)) {
                Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)etag) ? 1 : 0) != 0, (Object)"etag overwrite is enabled but the etag string is null/empty");
            }
            this.etag = etag;
            this.headers = headers;
        }

        public String toString() {
            return "CreateFileOptions{flags=" + this.flags + ", writeObjectFlags=" + this.writeObjectFlags + ", headers=" + this.headers + '}';
        }

        public EnumSet<CreateFlag> getFlags() {
            return this.flags;
        }

        public boolean isRecursive() {
            return this.isSet(WriteObjectFlags.Recursive);
        }

        public boolean isPerformance() {
            return this.isSet(WriteObjectFlags.Performance);
        }

        public boolean isConditionalOverwrite() {
            return this.isSet(WriteObjectFlags.ConditionalOverwrite);
        }

        public boolean isConditionalOverwriteEtag() {
            return this.isSet(WriteObjectFlags.ConditionalOverwriteEtag);
        }

        public boolean isSet(WriteObjectFlags val) {
            return this.writeObjectFlags().contains((Object)val);
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public String etag() {
            return this.etag;
        }

        public EnumSet<WriteObjectFlags> writeObjectFlags() {
            return this.writeObjectFlags;
        }
    }

    public static interface CreateFileBuilderCallbacks {
        public FSDataOutputStream createFileFromBuilder(Path var1, Progressable var2, CreateFileOptions var3) throws IOException;
    }
}

