/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.sls.AMDefinition;
import org.apache.hadoop.yarn.sls.AMDefinitionFactory;
import org.apache.hadoop.yarn.sls.SLSRunner;
import org.apache.hadoop.yarn.sls.TaskContainerDefinition;
import org.apache.hadoop.yarn.sls.scheduler.ContainerSimulator;
import org.apache.hadoop.yarn.sls.synthetic.SynthJob;

public class AMDefinitionSynth
extends AMDefinition {
    public AMDefinitionSynth(AMDefinition.AmDefinitionBuilder builder) {
        super(builder);
    }

    public static List<ContainerSimulator> getTaskContainers(SynthJob job, SLSRunner slsRunner) throws YarnException {
        ArrayList<ContainerSimulator> containerList = new ArrayList<ContainerSimulator>();
        ArrayList<NodeId> keyAsArray = new ArrayList<NodeId>(slsRunner.getNmMap().keySet());
        Random rand = new Random(slsRunner.getStjp().getSeed());
        for (SynthJob.SynthTask task : job.getTasks()) {
            RMNode node = AMDefinitionSynth.getRandomNode(slsRunner, keyAsArray, rand);
            TaskContainerDefinition containerDef = TaskContainerDefinition.Builder.create().withCount(1).withHostname("/" + node.getRackName() + "/" + node.getHostName()).withDuration(task.getTime()).withResource(Resource.newInstance((int)((int)task.getMemory()), (int)((int)task.getVcores()))).withPriority(task.getPriority()).withType(task.getType()).withExecutionType(task.getExecutionType()).withAllocationId(-1L).withRequestDelay(0L).build();
            containerList.add(ContainerSimulator.createFromTaskContainerDefinition(containerDef));
        }
        return containerList;
    }

    private static RMNode getRandomNode(SLSRunner slsRunner, ArrayList<NodeId> keyAsArray, Random rand) {
        int randomIndex = rand.nextInt(keyAsArray.size());
        return slsRunner.getNmMap().get(keyAsArray.get(randomIndex)).getNode();
    }

    public static final class Builder
    extends AMDefinition.AmDefinitionBuilder {
        private long baselineTimeMs;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public Builder withAmType(String amType) {
            this.amType = amType;
            return this;
        }

        public Builder withUser(String user) {
            if (user != null) {
                this.user = user;
            }
            return this;
        }

        public Builder withQueue(String queue) {
            this.queue = queue;
            return this;
        }

        public Builder withJobId(String oldJobId) {
            this.jobId = oldJobId;
            return this;
        }

        public Builder withJobStartTime(long time) {
            this.jobStartTime = time;
            return this;
        }

        public Builder withJobFinishTime(long time) {
            this.jobFinishTime = time;
            return this;
        }

        public Builder withBaseLineTimeMs(long baselineTimeMs) {
            this.baselineTimeMs = baselineTimeMs;
            return this;
        }

        public Builder withLabelExpression(String expr) {
            this.labelExpression = expr;
            return this;
        }

        public Builder withTaskContainers(List<ContainerSimulator> taskContainers) {
            this.taskContainers = taskContainers;
            return this;
        }

        public Builder withAmResource(Resource amResource) {
            this.amResource = amResource;
            return this;
        }

        public AMDefinitionSynth build() {
            AMDefinitionSynth amDef = new AMDefinitionSynth(this);
            if (this.baselineTimeMs == 0L) {
                this.baselineTimeMs = this.jobStartTime;
            }
            AMDefinitionFactory.adjustTimeValuesToBaselineTime(amDef, this, this.baselineTimeMs);
            return amDef;
        }
    }
}

