/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webapp;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.shaded.com.google.inject.Singleton;
import org.apache.hadoop.shaded.com.sun.jersey.api.client.Client;
import org.apache.hadoop.shaded.com.sun.jersey.api.client.ClientHandler;
import org.apache.hadoop.shaded.com.sun.jersey.api.client.ClientResponse;
import org.apache.hadoop.shaded.com.sun.jersey.api.client.WebResource;
import org.apache.hadoop.shaded.com.sun.jersey.api.client.config.ClientConfig;
import org.apache.hadoop.shaded.com.sun.jersey.api.client.config.DefaultClientConfig;
import org.apache.hadoop.shaded.com.sun.jersey.client.urlconnection.HttpURLConnectionFactory;
import org.apache.hadoop.shaded.com.sun.jersey.client.urlconnection.URLConnectionClientHandler;
import org.apache.hadoop.shaded.com.sun.jersey.core.util.MultivaluedMapImpl;
import org.apache.hadoop.shaded.javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.shaded.javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.shaded.javax.ws.rs.DefaultValue;
import org.apache.hadoop.shaded.javax.ws.rs.GET;
import org.apache.hadoop.shaded.javax.ws.rs.Path;
import org.apache.hadoop.shaded.javax.ws.rs.PathParam;
import org.apache.hadoop.shaded.javax.ws.rs.Produces;
import org.apache.hadoop.shaded.javax.ws.rs.QueryParam;
import org.apache.hadoop.shaded.javax.ws.rs.core.Context;
import org.apache.hadoop.shaded.javax.ws.rs.core.MultivaluedMap;
import org.apache.hadoop.shaded.javax.ws.rs.core.Response;
import org.apache.hadoop.thirdparty.com.google.common.base.Joiner;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntityType;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileControllerFactory;
import org.apache.hadoop.yarn.server.webapp.AppInfoProvider;
import org.apache.hadoop.yarn.server.webapp.BasicAppInfo;
import org.apache.hadoop.yarn.server.webapp.LogServlet;
import org.apache.hadoop.yarn.server.webapp.LogWebServiceUtils;
import org.apache.hadoop.yarn.server.webapp.WrappedLogMetaRequest;
import org.apache.hadoop.yarn.webapp.YarnJacksonJaxbJsonProvider;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Path(value="/ws/v2/applicationlog")
public class LogWebService
implements AppInfoProvider {
    private static final Logger LOG = LoggerFactory.getLogger(LogWebService.class);
    private static final String RESOURCE_URI_STR_V2 = "/ws/v2/timeline/";
    private static final String NM_DOWNLOAD_URI_STR = "/ws/v1/node/containers";
    private static final Joiner JOINER = Joiner.on((String)"");
    private static Configuration yarnConf = new YarnConfiguration();
    private static LogAggregationFileControllerFactory factory;
    private static String base;
    private static String defaultClusterid;
    private final LogServlet logServlet = new LogServlet(yarnConf, this);
    private volatile Client webTimelineClient;

    private static void init() {
        factory = new LogAggregationFileControllerFactory(yarnConf);
        base = JOINER.join((Object)WebAppUtils.getHttpSchemePrefix((Configuration)yarnConf), (Object)WebAppUtils.getTimelineReaderWebAppURLWithoutScheme((Configuration)yarnConf), new Object[]{RESOURCE_URI_STR_V2});
        defaultClusterid = yarnConf.get("yarn.resourcemanager.cluster-id", "yarn_cluster");
        LOG.info("Initialized LogWeService with clusterid " + defaultClusterid + " for URI: " + base);
    }

    private Client createTimelineWebClient() {
        DefaultClientConfig cfg = new DefaultClientConfig();
        cfg.getClasses().add(YarnJacksonJaxbJsonProvider.class);
        Client client = new Client((ClientHandler)new URLConnectionClientHandler(new HttpURLConnectionFactory(){

            public HttpURLConnection getHttpURLConnection(URL url) throws IOException {
                AuthenticatedURL.Token token = new AuthenticatedURL.Token();
                HttpURLConnection conn = null;
                try {
                    conn = new AuthenticatedURL().openConnection(url, token);
                    LOG.info("LogWeService:Connecetion created.");
                }
                catch (AuthenticationException e) {
                    throw new IOException(e);
                }
                return conn;
            }
        }), (ClientConfig)cfg);
        return client;
    }

    private void initForReadableEndpoints(HttpServletResponse response) {
        response.setContentType(null);
    }

    @GET
    @Path(value="/containers/{containerid}/logs")
    @Produces(value={"application/json", "application/xml"})
    public Response getContainerLogsInfo(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="containerid") String containerIdStr, @QueryParam(value="nm.id") String nmId, @QueryParam(value="redirected_from_node") @DefaultValue(value="false") boolean redirectedFromNode, @QueryParam(value="clusterid") String clusterId, @QueryParam(value="manual_redirection") @DefaultValue(value="false") boolean manualRedirection) {
        this.initForReadableEndpoints(res);
        WrappedLogMetaRequest.Builder logMetaRequestBuilder = LogServlet.createRequestFromContainerId(containerIdStr);
        return this.logServlet.getContainerLogsInfo(req, logMetaRequestBuilder, nmId, redirectedFromNode, clusterId, manualRedirection);
    }

    @Override
    public String getNodeHttpAddress(HttpServletRequest req, String appId, String appAttemptId, String containerId, String clusterId) {
        UserGroupInformation callerUGI = LogWebServiceUtils.getUser(req);
        String cId = clusterId != null ? clusterId : defaultClusterid;
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"fields", (Object)"INFO");
        final String path = JOINER.join((Object)"clusters/", (Object)cId, new Object[]{"/apps/", appId, "/entities/", TimelineEntityType.YARN_CONTAINER.toString(), "/", containerId});
        TimelineEntity conEntity = null;
        try {
            if (callerUGI == null) {
                conEntity = this.getEntity(path, (MultivaluedMap<String, String>)params);
            } else {
                this.setUserName((MultivaluedMap<String, String>)params, callerUGI.getShortUserName());
                conEntity = (TimelineEntity)callerUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<TimelineEntity>((MultivaluedMap)params){
                    final /* synthetic */ MultivaluedMap val$params;
                    {
                        this.val$params = multivaluedMap;
                    }

                    @Override
                    public TimelineEntity run() throws Exception {
                        return LogWebService.this.getEntity(path, (MultivaluedMap<String, String>)this.val$params);
                    }
                });
            }
        }
        catch (Exception e) {
            LogWebServiceUtils.rewrapAndThrowException(e);
        }
        if (conEntity == null) {
            return null;
        }
        return (String)conEntity.getInfo().get("YARN_CONTAINER_ALLOCATED_HOST_HTTP_ADDRESS");
    }

    @Override
    public BasicAppInfo getApp(HttpServletRequest req, String appId, String clusterId) {
        UserGroupInformation callerUGI = LogWebServiceUtils.getUser(req);
        String cId = clusterId != null ? clusterId : defaultClusterid;
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"fields", (Object)"INFO");
        final String path = JOINER.join((Object)"clusters/", (Object)cId, new Object[]{"/apps/", appId});
        TimelineEntity appEntity = null;
        try {
            if (callerUGI == null) {
                appEntity = this.getEntity(path, (MultivaluedMap<String, String>)params);
            } else {
                this.setUserName((MultivaluedMap<String, String>)params, callerUGI.getShortUserName());
                appEntity = (TimelineEntity)callerUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<TimelineEntity>((MultivaluedMap)params){
                    final /* synthetic */ MultivaluedMap val$params;
                    {
                        this.val$params = multivaluedMap;
                    }

                    @Override
                    public TimelineEntity run() throws Exception {
                        return LogWebService.this.getEntity(path, (MultivaluedMap<String, String>)this.val$params);
                    }
                });
            }
        }
        catch (Exception e) {
            LogWebServiceUtils.rewrapAndThrowException(e);
        }
        if (appEntity == null) {
            return null;
        }
        String appOwner = (String)appEntity.getInfo().get("YARN_APPLICATION_USER");
        String state = (String)appEntity.getInfo().get("YARN_APPLICATION_STATE");
        YarnApplicationState appState = YarnApplicationState.valueOf((String)state);
        return new BasicAppInfo(appState, appOwner);
    }

    @GET
    @Path(value="/containers/{containerid}/logs/{filename}")
    @Produces(value={"text/plain"})
    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public Response getContainerLogFile(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="containerid") String containerIdStr, @PathParam(value="filename") String filename, @QueryParam(value="format") String format, @QueryParam(value="size") String size, @QueryParam(value="nm.id") String nmId, @QueryParam(value="redirected_from_node") boolean redirectedFromNode, @QueryParam(value="clusterid") String clusterId, @QueryParam(value="manual_redirection") @DefaultValue(value="false") boolean manualRedirection) {
        return this.getLogs(req, res, containerIdStr, filename, format, size, nmId, redirectedFromNode, clusterId, manualRedirection);
    }

    @GET
    @Path(value="/containerlogs/{containerid}/{filename}")
    @Produces(value={"text/plain; charset=utf-8"})
    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public Response getLogs(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="containerid") String containerIdStr, @PathParam(value="filename") String filename, @QueryParam(value="format") String format, @QueryParam(value="size") String size, @QueryParam(value="nm.id") String nmId, @QueryParam(value="redirected_from_node") @DefaultValue(value="false") boolean redirectedFromNode, @QueryParam(value="clusterid") String clusterId, @QueryParam(value="manual_redirection") @DefaultValue(value="false") boolean manualRedirection) {
        this.initForReadableEndpoints(res);
        return this.logServlet.getLogFile(req, containerIdStr, filename, format, size, nmId, redirectedFromNode, clusterId, manualRedirection);
    }

    @VisibleForTesting
    protected TimelineEntity getEntity(String path, MultivaluedMap<String, String> params) throws IOException {
        ClientResponse resp = (ClientResponse)((WebResource.Builder)this.getClient().resource(base).path(path).queryParams(params).accept(new String[]{"application/json"}).type("application/json")).get(ClientResponse.class);
        if (resp == null || resp.getStatusInfo().getStatusCode() != ClientResponse.Status.OK.getStatusCode()) {
            String msg = "Response from the timeline reader server is " + (resp == null ? "null" : "not successful, HTTP error code: " + resp.getStatus() + ", Server response:\n" + (String)resp.getEntity(String.class));
            LOG.error(msg);
            throw new IOException(msg);
        }
        TimelineEntity entity = (TimelineEntity)resp.getEntity(TimelineEntity.class);
        return entity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Client getClient() {
        if (this.webTimelineClient != null) return this.webTimelineClient;
        Class<LogWebService> clazz = LogWebService.class;
        synchronized (LogWebService.class) {
            if (this.webTimelineClient != null) return this.webTimelineClient;
            this.webTimelineClient = this.createTimelineWebClient();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.webTimelineClient;
        }
    }

    private void setUserName(MultivaluedMap<String, String> params, String user) {
        if (!UserGroupInformation.isSecurityEnabled()) {
            params.add((Object)"user.name", (Object)user);
        }
    }

    static {
        LogWebService.init();
    }
}

