/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import org.apache.hadoop.shaded.com.google.inject.Inject;
import org.apache.hadoop.yarn.nodelabels.RMNodeLabel;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RmView;
import org.apache.hadoop.yarn.webapp.SubView;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet2.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.HtmlPage;

public class NodeLabelsPage
extends RmView {
    @Override
    protected void preHead(Hamlet.HTML<HtmlPage.__> html) {
        this.commonPreHead(html);
        String title = "Node labels of the cluster";
        this.setTitle(title);
        this.set("ui.dataTables.id", "nodelabels");
        this.setTableStyles(html, "nodelabels", new String[]{".healthStatus {width:10em}", ".healthReport {width:10em}"});
    }

    @Override
    protected Class<? extends SubView> content() {
        return NodeLabelsBlock.class;
    }

    static class NodeLabelsBlock
    extends HtmlBlock {
        final ResourceManager rm;

        @Inject
        NodeLabelsBlock(ResourceManager rm, View.ViewContext ctx) {
            super(ctx);
            this.rm = rm;
        }

        protected void render(HtmlBlock.Block html) {
            Hamlet.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)html.table("#nodelabels").thead().tr().th(".name", "Label Name").th(".type", "Label Type").th(".numOfActiveNMs", "Num Of Active NMs").th(".totalResource", "Total Resource").__()).__()).tbody();
            RMNodeLabelsManager nlm = this.rm.getRMContext().getNodeLabelManager();
            for (RMNodeLabel info : nlm.pullRMNodeLabelsInfo()) {
                Hamlet.TR row = tbody.tr().td(info.getLabelName().isEmpty() ? "<DEFAULT_PARTITION>" : info.getLabelName());
                String type = info.getIsExclusive() ? "Exclusive Partition" : "Non Exclusive Partition";
                row = row.td(type);
                int nActiveNMs = info.getNumActiveNMs();
                row = nActiveNMs > 0 ? (Hamlet.TR)row.td().a(this.url(new String[]{"nodes", "?node.label=" + info.getLabelName()}), String.valueOf(nActiveNMs)).__() : row.td(String.valueOf(nActiveNMs));
                row.td(info.getResource().toFormattedString()).__();
            }
            ((Hamlet.TABLE)tbody.__()).__();
        }
    }
}

