/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.jsonschema2pojo.rules;

import java.util.List;
import java.util.Set;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.hadoop.shaded.com.sun.codemodel.JClass;
import org.apache.hadoop.shaded.com.sun.codemodel.JPackage;
import org.apache.hadoop.shaded.com.sun.codemodel.JType;
import org.apache.hadoop.shaded.org.jsonschema2pojo.Schema;
import org.apache.hadoop.shaded.org.jsonschema2pojo.rules.Rule;
import org.apache.hadoop.shaded.org.jsonschema2pojo.rules.RuleFactory;
import org.apache.hadoop.shaded.org.jsonschema2pojo.util.Inflector;

public class ArrayRule
implements Rule<JPackage, JClass> {
    private final RuleFactory ruleFactory;

    protected ArrayRule(RuleFactory ruleFactory) {
        this.ruleFactory = ruleFactory;
    }

    @Override
    public JClass apply(String nodeName, JsonNode node, JsonNode parent, JPackage jpackage, Schema schema) {
        boolean uniqueItems = node.has("uniqueItems") && node.get("uniqueItems").asBoolean();
        boolean rootSchemaIsArray = !schema.isGenerated();
        JType itemType = node.has("items") ? this.ruleFactory.getSchemaRule().apply(this.makeSingular(nodeName), node.get("items"), node, jpackage, schema) : jpackage.owner().ref(Object.class);
        JClass arrayType = uniqueItems ? jpackage.owner().ref(Set.class).narrow(itemType) : jpackage.owner().ref(List.class).narrow(itemType);
        if (rootSchemaIsArray) {
            schema.setJavaType(arrayType);
        }
        return arrayType;
    }

    private String makeSingular(String nodeName) {
        return Inflector.getInstance().singularize(nodeName);
    }
}

