/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.ehcache.core.statistics;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.hadoop.shaded.org.ehcache.core.statistics.ValueStatistic;
import org.apache.hadoop.shaded.org.terracotta.management.model.stats.StatisticType;

public class SuppliedValueStatistic<T extends Serializable>
implements ValueStatistic<T> {
    private final Supplier<T> supplier;
    private final StatisticType type;

    public SuppliedValueStatistic(StatisticType type, Supplier<T> supplier) {
        this.type = Objects.requireNonNull(type);
        this.supplier = Objects.requireNonNull(supplier);
    }

    @Override
    public T value() {
        return (T)((Serializable)this.supplier.get());
    }

    @Override
    public StatisticType type() {
        return this.type;
    }

    public static <T extends Number> ValueStatistic<T> counter(Supplier<T> supplier) {
        return SuppliedValueStatistic.supply(StatisticType.COUNTER, supplier);
    }

    public static <T extends Serializable> ValueStatistic<T> supply(StatisticType type, Supplier<T> supplier) {
        return new SuppliedValueStatistic<T>(type, supplier);
    }
}

