/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.ehcache.core;

import org.apache.hadoop.shaded.org.ehcache.Status;

enum InternalStatus {
    UNINITIALIZED{

        @Override
        public Transition init() {
            return new Transition(AVAILABLE);
        }

        @Override
        public Transition maintenance() {
            return new Transition(MAINTENANCE);
        }

        @Override
        public Status toPublicStatus() {
            return Status.UNINITIALIZED;
        }
    }
    ,
    MAINTENANCE{

        @Override
        public Transition close() {
            return new Transition(UNINITIALIZED);
        }

        @Override
        public Status toPublicStatus() {
            return Status.MAINTENANCE;
        }
    }
    ,
    AVAILABLE{

        @Override
        public Transition close() {
            return new Transition(UNINITIALIZED);
        }

        @Override
        public Status toPublicStatus() {
            return Status.AVAILABLE;
        }
    };


    public Transition init() {
        throw new IllegalStateException("Init not supported from " + this.name());
    }

    public Transition close() {
        throw new IllegalStateException("Close not supported from " + this.name());
    }

    public Transition maintenance() {
        throw new IllegalStateException("Maintenance not supported from " + this.name());
    }

    public abstract Status toPublicStatus();

    public static Transition initial() {
        Transition close = MAINTENANCE.close();
        close.succeeded();
        return close;
    }

    public class Transition {
        private final InternalStatus to;
        private final Thread owner = Thread.currentThread();
        private volatile InternalStatus done;

        private Transition(InternalStatus to) {
            if (to == null) {
                throw new NullPointerException();
            }
            this.to = to;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InternalStatus get() {
            if (this.done != null) {
                return this.done;
            }
            if (this.owner == Thread.currentThread()) {
                return this.to.compareTo(this.from()) > 0 ? this.to : this.from();
            }
            Transition transition = this;
            synchronized (transition) {
                boolean interrupted = false;
                try {
                    while (this.done == null) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            interrupted = true;
                        }
                    }
                }
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
                return this.done;
            }
        }

        public synchronized void succeeded() {
            this.done = this.to;
            this.notifyAll();
        }

        public synchronized void failed() {
            this.done = this.to.compareTo(this.from()) > 0 ? this.from() : this.to;
            this.notifyAll();
        }

        public InternalStatus from() {
            return InternalStatus.this;
        }

        public InternalStatus to() {
            return this.to;
        }

        public boolean done() {
            return this.done != null;
        }
    }
}

