/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.aliyun.oss;

import com.aliyun.oss.model.ListObjectsRequest;
import com.aliyun.oss.model.ListObjectsV2Request;

public class OSSListRequest {
    private static final String DESCRIPTION = "List %s:/%s delimiter=%s keys=%d";
    private final ListObjectsRequest v1Request;
    private final ListObjectsV2Request v2Request;

    private OSSListRequest(ListObjectsRequest v1, ListObjectsV2Request v2) {
        this.v1Request = v1;
        this.v2Request = v2;
    }

    public static OSSListRequest v1(ListObjectsRequest request) {
        return new OSSListRequest(request, null);
    }

    public static OSSListRequest v2(ListObjectsV2Request request) {
        return new OSSListRequest(null, request);
    }

    public boolean isV1() {
        return this.v1Request != null;
    }

    public ListObjectsRequest getV1() {
        return this.v1Request;
    }

    public ListObjectsV2Request getV2() {
        return this.v2Request;
    }

    public String toString() {
        if (this.isV1()) {
            return String.format(DESCRIPTION, this.v1Request.getBucketName(), this.v1Request.getPrefix(), this.v1Request.getDelimiter(), this.v1Request.getMaxKeys());
        }
        return String.format(DESCRIPTION, this.v2Request.getBucketName(), this.v2Request.getPrefix(), this.v2Request.getDelimiter(), this.v2Request.getMaxKeys());
    }
}

