/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.shadow.org.terracotta.statistics.registry;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.ehcache.shadow.org.terracotta.context.ContextManager;
import org.ehcache.shadow.org.terracotta.context.TreeNode;
import org.ehcache.shadow.org.terracotta.context.query.Matcher;
import org.ehcache.shadow.org.terracotta.context.query.Matchers;
import org.ehcache.shadow.org.terracotta.context.query.QueryBuilder;
import org.ehcache.shadow.org.terracotta.statistics.OperationStatistic;
import org.ehcache.shadow.org.terracotta.statistics.StatisticType;
import org.ehcache.shadow.org.terracotta.statistics.Table;
import org.ehcache.shadow.org.terracotta.statistics.ValueStatistic;
import org.ehcache.shadow.org.terracotta.statistics.ValueStatistics;
import org.ehcache.shadow.org.terracotta.statistics.registry.OperationStatisticDescriptor;
import org.ehcache.shadow.org.terracotta.statistics.registry.Statistic;
import org.ehcache.shadow.org.terracotta.statistics.registry.ValueStatisticDescriptor;

public class StatisticRegistry {
    private final Object contextObject;
    private final LongSupplier timeSource;
    private final Map<String, ValueStatistic<? extends Serializable>> statistics = new HashMap<String, ValueStatistic<? extends Serializable>>();

    public StatisticRegistry(Object contextObject, LongSupplier timeSource) {
        this.contextObject = contextObject;
        this.timeSource = Objects.requireNonNull(timeSource);
    }

    protected Map<String, ValueStatistic<? extends Serializable>> getStatistics() {
        return this.statistics;
    }

    public <T extends Serializable> Optional<Statistic<T>> queryStatistic(String fullStatisticName) {
        return this.queryStatistic(fullStatisticName, 0L);
    }

    public <T extends Serializable> Optional<Statistic<T>> queryStatistic(String fullStatisticName, long sinceMillis) {
        ValueStatistic<? extends Serializable> valueStatistic = this.statistics.get(fullStatisticName);
        if (valueStatistic == null) {
            return Optional.empty();
        }
        return Optional.of(Statistic.extract(valueStatistic, sinceMillis, this.timeSource.getAsLong()));
    }

    public Map<String, Statistic<? extends Serializable>> queryStatistics() {
        return this.queryStatistics(0L);
    }

    public Map<String, Statistic<? extends Serializable>> queryStatistics(long sinceMillis) {
        long now = this.timeSource.getAsLong();
        return this.statistics.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Statistic.extract((ValueStatistic)e.getValue(), sinceMillis, now)));
    }

    public <T extends Serializable> void registerStatistic(String fullStatName, StatisticType type, Supplier<T> accessor) {
        this.registerStatistic(fullStatName, ValueStatistics.supply(type, accessor));
    }

    public <T extends Serializable> void registerStatistic(String fullStatName, ValueStatistic<T> accessor) {
        if (this.statistics.put(fullStatName, accessor) != null) {
            throw new IllegalArgumentException("Found duplicate statistic " + fullStatName);
        }
    }

    public void registerTable(String fullStatName, Supplier<Table> accessor) {
        this.registerStatistic(fullStatName, ValueStatistics.table(accessor));
    }

    public void registerGauge(String fullStatName, Supplier<Number> accessor) {
        this.registerStatistic(fullStatName, ValueStatistics.gauge(accessor));
    }

    public void registerCounter(String fullStatName, Supplier<Number> accessor) {
        this.registerStatistic(fullStatName, ValueStatistics.counter(accessor));
    }

    public <T extends Serializable> boolean registerStatistic(String statNameSuffix, ValueStatisticDescriptor descriptor) {
        if (this.contextObject == null) {
            return false;
        }
        TreeNode treeNode = ContextManager.nodeFor(this.contextObject);
        if (treeNode == null) {
            return false;
        }
        Set<TreeNode> result = QueryBuilder.queryBuilder().descendants().filter(Matchers.context(Matchers.attributes(Matchers.allOf(Matchers.hasAttribute("name", descriptor.getObserverName()), this.hasTags(descriptor.getTags()))))).filter(Matchers.context(Matchers.identifier(Matchers.subclassOf(ValueStatistic.class)))).build().execute(Collections.singleton(treeNode));
        if (!result.isEmpty()) {
            for (TreeNode node : result) {
                String discriminator = null;
                Map properties = (Map)node.getContext().attributes().get("properties");
                if (properties != null && properties.containsKey("discriminator")) {
                    discriminator = properties.get("discriminator").toString();
                }
                String fullStatName = (discriminator == null ? "" : discriminator + ":") + statNameSuffix;
                ValueStatistic statistic = (ValueStatistic)node.getContext().attributes().get("this");
                this.registerStatistic(fullStatName, statistic);
            }
            return true;
        }
        return false;
    }

    public <T extends Enum<T>> boolean registerStatistic(String statNameSuffix, OperationStatisticDescriptor<T> descriptor, EnumSet<T> outcomes) {
        if (this.contextObject == null) {
            return false;
        }
        TreeNode treeNode = ContextManager.nodeFor(this.contextObject);
        if (treeNode == null) {
            return false;
        }
        Set<TreeNode> result = QueryBuilder.queryBuilder().descendants().filter(Matchers.context(Matchers.attributes(Matchers.allOf(Matchers.hasAttribute("type", descriptor.getType()), Matchers.hasAttribute("name", descriptor.getObserverName()), this.hasTags(descriptor.getTags()))))).filter(Matchers.context(Matchers.identifier(Matchers.subclassOf(OperationStatistic.class)))).build().execute(Collections.singleton(treeNode));
        if (!result.isEmpty()) {
            for (TreeNode node : result) {
                String discriminator = null;
                Map properties = (Map)node.getContext().attributes().get("properties");
                if (properties != null && properties.containsKey("discriminator")) {
                    discriminator = properties.get("discriminator").toString();
                }
                String fullStatName = (discriminator == null ? "" : discriminator + ":") + statNameSuffix;
                OperationStatistic statistic = (OperationStatistic)node.getContext().attributes().get("this");
                this.registerStatistic(fullStatName, statistic.statistic(outcomes));
            }
            return true;
        }
        return false;
    }

    private Matcher<Map<String, Object>> hasTags(final Collection<String> tags) {
        return Matchers.hasAttribute("tags", (Matcher<? extends Object>)new Matcher<Collection<String>>(){

            @Override
            protected boolean matchesSafely(Collection<String> object) {
                return object.containsAll(tags);
            }
        });
    }
}

