/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.io.physical.prefetcher;

import lombok.Generated;
import software.amazon.s3.analyticsaccelerator.common.Preconditions;
import software.amazon.s3.analyticsaccelerator.io.physical.data.BlockStore;

public class SequentialPatternDetector {
    private final BlockStore blockStore;

    public boolean isSequentialRead(long pos) {
        Preconditions.checkArgument(pos >= 0L, "`pos` must be non-negative");
        if (pos == 0L) {
            return false;
        }
        return this.blockStore.getBlock(pos - 1L).isPresent();
    }

    public long getGeneration(long pos) {
        Preconditions.checkArgument(pos >= 0L, "`pos` must be non-negative");
        if (this.isSequentialRead(pos)) {
            return this.blockStore.getBlock(pos - 1L).get().getGeneration() + 1L;
        }
        return 0L;
    }

    @Generated
    public SequentialPatternDetector(BlockStore blockStore) {
        this.blockStore = blockStore;
    }
}

