/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.query.aggregation;

import com.microsoft.azure.cosmosdb.Undefined;
import com.microsoft.azure.cosmosdb.internal.Utils;
import com.microsoft.azure.cosmosdb.internal.query.aggregation.Aggregator;
import java.io.IOException;

public class AverageAggregator
implements Aggregator {
    private AverageInfo averageInfo = new AverageInfo();

    @Override
    public void aggregate(Object item) {
        AverageInfo averageInfo;
        try {
            averageInfo = (AverageInfo)Utils.getSimpleObjectMapper().readValue(item.toString(), AverageInfo.class);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to deserialize aggregate result");
        }
        this.averageInfo.add(averageInfo);
    }

    @Override
    public Object getResult() {
        return this.averageInfo.getAverage();
    }

    private static class AverageInfo {
        public Double sum;
        public long count;

        private AverageInfo() {
        }

        public void add(AverageInfo other) {
            if (other == null) {
                throw new IllegalArgumentException("other");
            }
            if (other.sum == null) {
                return;
            }
            if (this.sum == null) {
                this.sum = 0.0;
            }
            AverageInfo averageInfo = this;
            averageInfo.sum = averageInfo.sum + other.sum;
            this.count += other.count;
        }

        Object getAverage() {
            if (this.sum == null || this.count <= 0L) {
                return Undefined.Value();
            }
            return this.sum / (double)this.count;
        }
    }
}

