/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor.invariants;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.AbstractMetric;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecord;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.impl.MetricsCollectorImpl;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.source.JvmMetrics;
import org.apache.hadoop.thirdparty.com.google.common.io.Files;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.invariants.InvariantsChecker;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsInvariantChecker
extends InvariantsChecker {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsInvariantChecker.class);
    public static final String INVARIANTS_FILE = "yarn.resourcemanager.invariant-checker.file";
    private MetricsSystem metricsSystem;
    private MetricsCollectorImpl collector;
    private SimpleBindings bindings;
    private ScriptEngineManager manager;
    private Compilable scriptEngine;
    private String invariantFile;
    private Map<String, CompiledScript> invariants;
    private CompiledScript combinedInvariants;
    private QueueMetrics queueMetrics;
    private JvmMetrics jvmMetrics;

    @Override
    public void init(Configuration config, RMContext rmContext, ResourceScheduler scheduler) {
        super.init(config, rmContext, scheduler);
        this.metricsSystem = DefaultMetricsSystem.instance();
        this.queueMetrics = QueueMetrics.forQueue(this.metricsSystem, "root", null, false, this.getConf());
        this.jvmMetrics = (JvmMetrics)this.metricsSystem.getSource("JvmMetrics");
        this.collector = new MetricsCollectorImpl();
        this.queueMetrics.getMetrics((MetricsCollector)this.collector, true);
        this.jvmMetrics.getMetrics((MetricsCollector)this.collector, true);
        this.bindings = new SimpleBindings();
        this.manager = new ScriptEngineManager();
        this.scriptEngine = (Compilable)((Object)this.manager.getEngineByName("JavaScript"));
        this.invariantFile = this.getConf().get(INVARIANTS_FILE);
        this.invariants = new HashMap<String, CompiledScript>();
        this.queueMetrics.getMetrics((MetricsCollector)this.collector, true);
        this.jvmMetrics.getMetrics((MetricsCollector)this.collector, true);
        for (MetricsRecord record : this.collector.getRecords()) {
            for (AbstractMetric am : record.metrics()) {
                this.bindings.put(am.name().replace(' ', '_'), (Object)am.value());
            }
        }
        StringBuilder sb = new StringBuilder();
        try {
            List tempInv = Files.readLines((File)new File(this.invariantFile), (Charset)StandardCharsets.UTF_8);
            boolean first = true;
            for (String inv : tempInv) {
                if (first) {
                    first = false;
                } else {
                    sb.append("&&");
                }
                this.invariants.put(inv, this.scriptEngine.compile(inv));
                sb.append(" (").append(inv).append(") ");
            }
            this.combinedInvariants = this.scriptEngine.compile(sb.toString());
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading invariant file: " + e.getMessage());
        }
        catch (ScriptException e) {
            throw new RuntimeException("Error compiling invariant " + e.getMessage());
        }
    }

    @Override
    public void editSchedule() {
        this.collector.clear();
        this.queueMetrics.getMetrics((MetricsCollector)this.collector, false);
        this.jvmMetrics.getMetrics((MetricsCollector)this.collector, false);
        for (MetricsRecord record : this.collector.getRecords()) {
            for (AbstractMetric am : record.metrics()) {
                this.bindings.put(am.name().replace(' ', '_'), (Object)am.value());
            }
        }
        try {
            boolean allInvHold = (Boolean)this.combinedInvariants.eval(this.bindings);
            if (!allInvHold) {
                for (Map.Entry<String, CompiledScript> e : this.invariants.entrySet()) {
                    boolean invariantsHold = (Boolean)e.getValue().eval(this.bindings);
                    if (invariantsHold) continue;
                    Map<String, Object> matchingBindings = MetricsInvariantChecker.extractMatchingBindings(e.getKey(), this.bindings);
                    this.logOrThrow("Invariant \"" + e.getKey() + "\" is NOT holding, with bindings: " + matchingBindings);
                }
            }
        }
        catch (ScriptException e) {
            this.logOrThrow(e.getMessage());
        }
    }

    private static Map<String, Object> extractMatchingBindings(String inv, SimpleBindings allBindings) {
        HashMap<String, Object> matchingBindings = new HashMap<String, Object>();
        for (Map.Entry<String, Object> s : allBindings.entrySet()) {
            if (!inv.contains(s.getKey())) continue;
            matchingBindings.put(s.getKey(), s.getValue());
        }
        return matchingBindings;
    }
}

