/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.resource.PlacementConstraint;
import org.apache.hadoop.yarn.api.resource.PlacementConstraints;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.PlacementConstraintManagerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class MemoryPlacementConstraintManager
extends PlacementConstraintManagerService {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryPlacementConstraintManager.class);
    private ReentrantReadWriteLock.ReadLock readLock;
    private ReentrantReadWriteLock.WriteLock writeLock;
    private Map<String, PlacementConstraint> globalConstraints = new HashMap<String, PlacementConstraint>();
    private Map<ApplicationId, Map<String, PlacementConstraint>> appConstraints = new HashMap<ApplicationId, Map<String, PlacementConstraint>>();

    public MemoryPlacementConstraintManager() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    protected void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerApplication(ApplicationId appId, Map<Set<String>, PlacementConstraint> constraintMap) {
        HashMap<String, PlacementConstraint> constraintsForApp = new HashMap<String, PlacementConstraint>();
        this.readLock.lock();
        try {
            if (this.appConstraints.get(appId) != null) {
                LOG.warn("Application {} has already been registered.", (Object)appId);
                return;
            }
            for (Map.Entry<Set<String>, PlacementConstraint> entry : constraintMap.entrySet()) {
                PlacementConstraint constraint;
                Set<String> sourceTags = entry.getKey();
                if (!this.validateConstraint(sourceTags, constraint = entry.getValue())) continue;
                String sourceTag = this.getValidSourceTag(sourceTags);
                constraintsForApp.put(sourceTag, constraint);
            }
        }
        finally {
            this.readLock.unlock();
        }
        if (constraintsForApp.isEmpty()) {
            LOG.info("Application {} was registered, but no constraints were added.", (Object)appId);
        }
        this.writeLock.lock();
        try {
            this.appConstraints.put(appId, constraintsForApp);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConstraint(ApplicationId appId, Set<String> sourceTags, PlacementConstraint placementConstraint, boolean replace) {
        this.writeLock.lock();
        try {
            Map<String, PlacementConstraint> constraintsForApp = this.appConstraints.get(appId);
            if (constraintsForApp == null) {
                LOG.info("Cannot add constraint to application {}, as it has not been registered yet.", (Object)appId);
                return;
            }
            this.addConstraintToMap(constraintsForApp, sourceTags, placementConstraint, replace);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addGlobalConstraint(Set<String> sourceTags, PlacementConstraint placementConstraint, boolean replace) {
        this.writeLock.lock();
        try {
            this.addConstraintToMap(this.globalConstraints, sourceTags, placementConstraint, replace);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void addConstraintToMap(Map<String, PlacementConstraint> constraintMap, Set<String> sourceTags, PlacementConstraint placementConstraint, boolean replace) {
        if (this.validateConstraint(sourceTags, placementConstraint)) {
            String sourceTag = this.getValidSourceTag(sourceTags);
            if (constraintMap.get(sourceTag) == null || replace) {
                if (replace) {
                    LOG.info("Replacing the constraint associated with tag {} with {}.", (Object)sourceTag, (Object)placementConstraint);
                }
                constraintMap.put(sourceTag, placementConstraint);
            } else {
                LOG.info("Constraint {} will not be added. There is already a constraint associated with tag {}.", (Object)placementConstraint, (Object)sourceTag);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Set<String>, PlacementConstraint> getConstraints(ApplicationId appId) {
        this.readLock.lock();
        try {
            if (this.appConstraints.get(appId) == null) {
                LOG.debug("Application {} is not registered in the Placement Constraint Manager.", (Object)appId);
                Map<Set<String>, PlacementConstraint> map = null;
                return map;
            }
            Map<Set, PlacementConstraint> constraintMap = this.appConstraints.get(appId).entrySet().stream().collect(Collectors.toMap(e -> Stream.of(e.getKey()).collect(Collectors.toSet()), e -> (PlacementConstraint)e.getValue()));
            Map<Set<String>, PlacementConstraint> map = Collections.unmodifiableMap(constraintMap);
            return map;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PlacementConstraint getConstraint(ApplicationId appId, Set<String> sourceTags) {
        if (!this.validateSourceTags(sourceTags)) {
            return null;
        }
        String sourceTag = this.getValidSourceTag(sourceTags);
        this.readLock.lock();
        try {
            if (this.appConstraints.get(appId) == null) {
                LOG.debug("Application {} is not registered in the Placement Constraint Manager.", (Object)appId);
                PlacementConstraint placementConstraint = null;
                return placementConstraint;
            }
            PlacementConstraint placementConstraint = this.appConstraints.get(appId).get(sourceTag);
            return placementConstraint;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PlacementConstraint getGlobalConstraint(Set<String> sourceTags) {
        if (!this.validateSourceTags(sourceTags)) {
            return null;
        }
        String sourceTag = this.getValidSourceTag(sourceTags);
        this.readLock.lock();
        try {
            PlacementConstraint placementConstraint = this.globalConstraints.get(sourceTag);
            return placementConstraint;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public PlacementConstraint getMultilevelConstraint(ApplicationId appId, Set<String> sourceTags, PlacementConstraint schedulingRequestConstraint) {
        ArrayList<PlacementConstraint> constraints = new ArrayList<PlacementConstraint>();
        if (schedulingRequestConstraint != null) {
            constraints.add(schedulingRequestConstraint);
        }
        if (appId != null && sourceTags != null && !sourceTags.isEmpty()) {
            constraints.add(this.getConstraint(appId, sourceTags));
        }
        if (sourceTags != null && !sourceTags.isEmpty()) {
            constraints.add(this.getGlobalConstraint(sourceTags));
        }
        List<PlacementConstraint.AbstractConstraint> allConstraints = constraints.stream().filter(placementConstraint -> placementConstraint != null && placementConstraint.getConstraintExpr() != null).map(PlacementConstraint::getConstraintExpr).distinct().collect(Collectors.toList());
        PlacementConstraint.And andConstraint = PlacementConstraints.and((PlacementConstraint.AbstractConstraint[])allConstraints.toArray(new PlacementConstraint.AbstractConstraint[allConstraints.size()]));
        return andConstraint.build();
    }

    @Override
    public void unregisterApplication(ApplicationId appId) {
        this.writeLock.lock();
        try {
            this.appConstraints.remove(appId);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void removeGlobalConstraint(Set<String> sourceTags) {
        if (!this.validateSourceTags(sourceTags)) {
            return;
        }
        String sourceTag = this.getValidSourceTag(sourceTags);
        this.writeLock.lock();
        try {
            this.globalConstraints.remove(sourceTag);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public int getNumRegisteredApplications() {
        this.readLock.lock();
        try {
            int n = this.appConstraints.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public int getNumGlobalConstraints() {
        this.readLock.lock();
        try {
            int n = this.globalConstraints.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }
}

