/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.store.utils;

import java.util.List;
import org.apache.hadoop.shaded.org.apache.commons.collections4.CollectionUtils;
import org.apache.hadoop.yarn.server.federation.store.exception.FederationStateStoreInvalidInputException;
import org.apache.hadoop.yarn.server.federation.store.records.DeleteSubClusterPoliciesConfigurationsRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterPolicyConfigurationRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SetSubClusterPolicyConfigurationRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterPolicyConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FederationPolicyStoreInputValidator {
    private static final Logger LOG = LoggerFactory.getLogger(FederationPolicyStoreInputValidator.class);

    private FederationPolicyStoreInputValidator() {
    }

    public static void validate(GetSubClusterPolicyConfigurationRequest request) throws FederationStateStoreInvalidInputException {
        if (request == null) {
            String message = "Missing GetSubClusterPolicyConfiguration Request. Please try again by specifying a policy selection information.";
            LOG.warn(message);
            throw new FederationStateStoreInvalidInputException(message);
        }
        FederationPolicyStoreInputValidator.checkQueue(request.getQueue());
    }

    public static void validate(SetSubClusterPolicyConfigurationRequest request) throws FederationStateStoreInvalidInputException {
        if (request == null) {
            String message = "Missing SetSubClusterPolicyConfiguration Request. Please try again by specifying an policy insertion information.";
            LOG.warn(message);
            throw new FederationStateStoreInvalidInputException(message);
        }
        FederationPolicyStoreInputValidator.checkSubClusterPolicyConfiguration(request.getPolicyConfiguration());
    }

    private static void checkSubClusterPolicyConfiguration(SubClusterPolicyConfiguration policyConfiguration) throws FederationStateStoreInvalidInputException {
        if (policyConfiguration == null) {
            String message = "Missing SubClusterPolicyConfiguration. Please try again by specifying a SubClusterPolicyConfiguration.";
            LOG.warn(message);
            throw new FederationStateStoreInvalidInputException(message);
        }
        FederationPolicyStoreInputValidator.checkQueue(policyConfiguration.getQueue());
        FederationPolicyStoreInputValidator.checkType(policyConfiguration.getType());
    }

    private static void checkQueue(String queue) throws FederationStateStoreInvalidInputException {
        if (queue == null || queue.isEmpty()) {
            String message = "Missing Queue. Please try again by specifying a Queue.";
            LOG.warn(message);
            throw new FederationStateStoreInvalidInputException(message);
        }
    }

    private static void checkType(String type) throws FederationStateStoreInvalidInputException {
        if (type == null || type.isEmpty()) {
            String message = "Missing Policy Type. Please try again by specifying a Policy Type.";
            LOG.warn(message);
            throw new FederationStateStoreInvalidInputException(message);
        }
    }

    public static void validate(DeleteSubClusterPoliciesConfigurationsRequest request) throws FederationStateStoreInvalidInputException {
        if (request == null) {
            String message = "Missing DeleteSubClusterPoliciesConfigurationsRequest Request. Please try again by specifying an policy insertion information.";
            LOG.warn(message);
            throw new FederationStateStoreInvalidInputException(message);
        }
        List<String> queues = request.getQueues();
        if (CollectionUtils.isEmpty(queues)) {
            throw new FederationStateStoreInvalidInputException("The queues that needs to be deleted cannot be empty.");
        }
    }
}

