/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.sun.codemodel;

import org.apache.hadoop.shaded.com.sun.codemodel.JArray;
import org.apache.hadoop.shaded.com.sun.codemodel.JArrayCompRef;
import org.apache.hadoop.shaded.com.sun.codemodel.JAssignment;
import org.apache.hadoop.shaded.com.sun.codemodel.JAssignmentTarget;
import org.apache.hadoop.shaded.com.sun.codemodel.JAtom;
import org.apache.hadoop.shaded.com.sun.codemodel.JCast;
import org.apache.hadoop.shaded.com.sun.codemodel.JClass;
import org.apache.hadoop.shaded.com.sun.codemodel.JExpression;
import org.apache.hadoop.shaded.com.sun.codemodel.JExpressionImpl;
import org.apache.hadoop.shaded.com.sun.codemodel.JFieldRef;
import org.apache.hadoop.shaded.com.sun.codemodel.JFormatter;
import org.apache.hadoop.shaded.com.sun.codemodel.JInvocation;
import org.apache.hadoop.shaded.com.sun.codemodel.JMethod;
import org.apache.hadoop.shaded.com.sun.codemodel.JNarrowedClass;
import org.apache.hadoop.shaded.com.sun.codemodel.JStringLiteral;
import org.apache.hadoop.shaded.com.sun.codemodel.JType;
import org.apache.hadoop.shaded.com.sun.codemodel.JVar;

public abstract class JExpr {
    private static final JExpression __this = new JAtom("this");
    private static final JExpression __super = new JAtom("super");
    private static final JExpression __null = new JAtom("null");
    public static final JExpression TRUE = new JAtom("true");
    public static final JExpression FALSE = new JAtom("false");
    static final String charEscape = "\b\t\n\f\r\"'\\";
    static final String charMacro = "btnfr\"'\\";

    private JExpr() {
    }

    public static JExpression assign(JAssignmentTarget lhs, JExpression rhs) {
        return new JAssignment(lhs, rhs);
    }

    public static JExpression assignPlus(JAssignmentTarget lhs, JExpression rhs) {
        return new JAssignment(lhs, rhs, "+");
    }

    public static JInvocation _new(JClass c) {
        return new JInvocation(c);
    }

    public static JInvocation _new(JType t) {
        return new JInvocation(t);
    }

    public static JInvocation invoke(String method) {
        return new JInvocation((JExpression)null, method);
    }

    public static JInvocation invoke(JMethod method) {
        return new JInvocation((JExpression)null, method);
    }

    public static JInvocation invoke(JExpression lhs, JMethod method) {
        return new JInvocation(lhs, method);
    }

    public static JInvocation invoke(JExpression lhs, String method) {
        return new JInvocation(lhs, method);
    }

    public static JFieldRef ref(String field) {
        return new JFieldRef((JExpression)null, field);
    }

    public static JFieldRef ref(JExpression lhs, JVar field) {
        return new JFieldRef(lhs, field);
    }

    public static JFieldRef ref(JExpression lhs, String field) {
        return new JFieldRef(lhs, field);
    }

    public static JFieldRef refthis(String field) {
        return new JFieldRef(null, field, true);
    }

    public static JExpression dotclass(final JClass cl) {
        return new JExpressionImpl(){

            public void generate(JFormatter f) {
                JClass c = cl instanceof JNarrowedClass ? ((JNarrowedClass)cl).basis : cl;
                f.g(c).p(".class");
            }
        };
    }

    public static JArrayCompRef component(JExpression lhs, JExpression index) {
        return new JArrayCompRef(lhs, index);
    }

    public static JCast cast(JType type, JExpression expr) {
        return new JCast(type, expr);
    }

    public static JArray newArray(JType type) {
        return JExpr.newArray(type, null);
    }

    public static JArray newArray(JType type, JExpression size) {
        return new JArray(type.erasure(), size);
    }

    public static JArray newArray(JType type, int size) {
        return JExpr.newArray(type, JExpr.lit(size));
    }

    public static JExpression _this() {
        return __this;
    }

    public static JExpression _super() {
        return __super;
    }

    public static JExpression _null() {
        return __null;
    }

    public static JExpression lit(boolean b) {
        return b ? TRUE : FALSE;
    }

    public static JExpression lit(int n) {
        return new JAtom(Integer.toString(n));
    }

    public static JExpression lit(long n) {
        return new JAtom(Long.toString(n) + "L");
    }

    public static JExpression lit(float f) {
        if (f == Float.NEGATIVE_INFINITY) {
            return new JAtom("java.lang.Float.NEGATIVE_INFINITY");
        }
        if (f == Float.POSITIVE_INFINITY) {
            return new JAtom("java.lang.Float.POSITIVE_INFINITY");
        }
        if (Float.isNaN(f)) {
            return new JAtom("java.lang.Float.NaN");
        }
        return new JAtom(Float.toString(f) + "F");
    }

    public static JExpression lit(double d) {
        if (d == Double.NEGATIVE_INFINITY) {
            return new JAtom("java.lang.Double.NEGATIVE_INFINITY");
        }
        if (d == Double.POSITIVE_INFINITY) {
            return new JAtom("java.lang.Double.POSITIVE_INFINITY");
        }
        if (Double.isNaN(d)) {
            return new JAtom("java.lang.Double.NaN");
        }
        return new JAtom(Double.toString(d) + "D");
    }

    public static String quotify(char quote, String s) {
        int n = s.length();
        StringBuilder sb = new StringBuilder(n + 2);
        sb.append(quote);
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            int j = charEscape.indexOf(c);
            if (j >= 0) {
                if (quote == '\"' && c == '\'' || quote == '\'' && c == '\"') {
                    sb.append(c);
                    continue;
                }
                sb.append('\\');
                sb.append(charMacro.charAt(j));
                continue;
            }
            if (c < ' ' || '~' < c) {
                sb.append("\\u");
                String hex = Integer.toHexString(c & 0xFFFF);
                for (int k = hex.length(); k < 4; ++k) {
                    sb.append('0');
                }
                sb.append(hex);
                continue;
            }
            sb.append(c);
        }
        sb.append(quote);
        return sb.toString();
    }

    public static JExpression lit(char c) {
        return new JAtom(JExpr.quotify('\'', "" + c));
    }

    public static JExpression lit(String s) {
        return new JStringLiteral(s);
    }

    public static JExpression direct(final String source) {
        return new JExpressionImpl(){

            public void generate(JFormatter f) {
                f.p('(').p(source).p(')');
            }
        };
    }
}

