/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.slive;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.slive.ArgumentParser;
import org.apache.hadoop.fs.slive.ConfigExtractor;
import org.apache.hadoop.fs.slive.ConfigOption;
import org.apache.hadoop.fs.slive.Constants;
import org.apache.hadoop.fs.slive.OperationData;
import org.apache.hadoop.fs.slive.Range;
import org.apache.hadoop.util.StringUtils;

class ConfigMerger {
    ConfigMerger() {
    }

    Configuration getMerged(ArgumentParser.ParsedOutput opts, Configuration base) throws ConfigException {
        return this.handleOptions(opts, base);
    }

    private Map<Constants.OperationType, OperationData> getBaseOperations() {
        Constants.OperationType[] types;
        HashMap<Constants.OperationType, OperationData> base = new HashMap<Constants.OperationType, OperationData>();
        for (Constants.OperationType type : types = Constants.OperationType.values()) {
            base.put(type, new OperationData(Constants.Distribution.UNIFORM, null));
        }
        return base;
    }

    private Configuration handleOperations(ArgumentParser.ParsedOutput opts, Configuration base, ConfigExtractor extractor) throws ConfigException {
        HashMap<Constants.OperationType, OperationData> mpcp;
        Map<Constants.OperationType, OperationData> operations = this.getBaseOperations();
        Map<Constants.OperationType, OperationData> cfgOperations = extractor.getOperations();
        for (Constants.OperationType opType : cfgOperations.keySet()) {
            operations.put(opType, cfgOperations.get((Object)opType));
        }
        for (Constants.OperationType opType : Constants.OperationType.values()) {
            String opName = opType.lowerName();
            String opVal = opts.getValue(opName);
            if (opVal == null) continue;
            operations.put(opType, new OperationData(opVal));
        }
        HashMap<Constants.OperationType, OperationData> cleanedOps = new HashMap<Constants.OperationType, OperationData>();
        for (Constants.OperationType opType : operations.keySet()) {
            OperationData data = operations.get((Object)opType);
            if (data.getPercent() != null && !(data.getPercent() > 0.0)) continue;
            cleanedOps.put(opType, data);
        }
        operations = cleanedOps;
        if (operations.isEmpty()) {
            throw new ConfigException("No operations provided!");
        }
        double currPct = 0.0;
        int needFill = 0;
        for (Constants.OperationType type : operations.keySet()) {
            OperationData op = operations.get((Object)type);
            if (op.getPercent() != null) {
                currPct += op.getPercent().doubleValue();
                continue;
            }
            ++needFill;
        }
        if (currPct > 1.0) {
            throw new ConfigException("Unable to have accumlative percent greater than 100%");
        }
        if (needFill > 0 && currPct < 1.0) {
            double leftOver = 1.0 - currPct;
            mpcp = new HashMap<Constants.OperationType, OperationData>();
            for (Constants.OperationType type : operations.keySet()) {
                Object op = operations.get((Object)type);
                if (((OperationData)op).getPercent() == null) {
                    op = new OperationData(((OperationData)op).getDistribution(), leftOver / (double)needFill);
                }
                mpcp.put(type, (OperationData)op);
            }
            operations = mpcp;
        } else if (needFill == 0 && currPct < 1.0) {
            double leftOver = 1.0 - currPct;
            mpcp = new HashMap();
            double each = leftOver / (double)operations.keySet().size();
            for (Constants.OperationType t : operations.keySet()) {
                OperationData op = operations.get((Object)t);
                op = new OperationData(op.getDistribution(), op.getPercent() + each);
                mpcp.put(t, op);
            }
            operations = mpcp;
        } else if (needFill > 0 && currPct >= 1.0) {
            throw new ConfigException(needFill + " unfilled operations but no percentage left to fill with");
        }
        for (Constants.OperationType opType : operations.keySet()) {
            String opName = opType.lowerName();
            OperationData opData = operations.get((Object)opType);
            String distr = opData.getDistribution().lowerName();
            String ratio = new Double(opData.getPercent() * 100.0).toString();
            base.set(String.format("slive.op.%s", opName), opData.toString());
            base.set(String.format("slive.op.%s.dist", opName), distr);
            base.set(String.format("slive.op.%s.pct", opName), ratio);
        }
        return base;
    }

    private Configuration handleOptions(ArgumentParser.ParsedOutput opts, Configuration base) throws ConfigException {
        String pSize;
        ConfigExtractor extractor = new ConfigExtractor(base);
        Integer mapAmount = null;
        try {
            mapAmount = extractor.getMapAmount(opts.getValue(ConfigOption.MAPS.getOpt()));
        }
        catch (Exception e) {
            throw new ConfigException("Error extracting & merging map amount", e);
        }
        if (mapAmount != null) {
            if (mapAmount <= 0) {
                throw new ConfigException("Map amount can not be less than or equal to zero");
            }
            base.set(ConfigOption.MAPS.getCfgOption(), mapAmount.toString());
        }
        Integer reduceAmount = null;
        try {
            reduceAmount = extractor.getMapAmount(opts.getValue(ConfigOption.REDUCES.getOpt()));
        }
        catch (Exception e) {
            throw new ConfigException("Error extracting & merging reducer amount", e);
        }
        if (reduceAmount != null) {
            if (reduceAmount <= 0) {
                throw new ConfigException("Reducer amount can not be less than or equal to zero");
            }
            base.set(ConfigOption.REDUCES.getCfgOption(), reduceAmount.toString());
        }
        Integer duration = null;
        try {
            duration = extractor.getDuration(opts.getValue(ConfigOption.DURATION.getOpt()));
        }
        catch (Exception e) {
            throw new ConfigException("Error extracting & merging duration", e);
        }
        if (duration != null) {
            if (duration <= 0) {
                throw new ConfigException("Duration can not be less than or equal to zero");
            }
            base.set(ConfigOption.DURATION.getCfgOption(), duration.toString());
        }
        Integer operationAmount = null;
        try {
            operationAmount = extractor.getOpCount(opts.getValue(ConfigOption.OPS.getOpt()));
        }
        catch (Exception e) {
            throw new ConfigException("Error extracting & merging operation amount", e);
        }
        if (operationAmount != null) {
            if (operationAmount <= 0) {
                throw new ConfigException("Operation amount can not be less than or equal to zero");
            }
            base.set(ConfigOption.OPS.getCfgOption(), operationAmount.toString());
        }
        try {
            boolean exitOnError = extractor.shouldExitOnFirstError(opts.getValue(ConfigOption.EXIT_ON_ERROR.getOpt()));
            base.setBoolean(ConfigOption.EXIT_ON_ERROR.getCfgOption(), exitOnError);
        }
        catch (Exception e) {
            throw new ConfigException("Error extracting & merging exit on error value", e);
        }
        try {
            boolean waitOnTruncate = extractor.shouldWaitOnTruncate(opts.getValue(ConfigOption.TRUNCATE_WAIT.getOpt()));
            base.setBoolean(ConfigOption.TRUNCATE_WAIT.getCfgOption(), waitOnTruncate);
        }
        catch (Exception e) {
            throw new ConfigException("Error extracting & merging wait on truncate value", e);
        }
        Integer fileAm = null;
        try {
            fileAm = extractor.getTotalFiles(opts.getValue(ConfigOption.FILES.getOpt()));
        }
        catch (Exception e) {
            throw new ConfigException("Error extracting & merging total file limit amount", e);
        }
        if (fileAm != null) {
            if (fileAm <= 0) {
                throw new ConfigException("File amount can not be less than or equal to zero");
            }
            base.set(ConfigOption.FILES.getCfgOption(), fileAm.toString());
        }
        try {
            String qname = extractor.getQueueName(opts.getValue(ConfigOption.QUEUE_NAME.getOpt()));
            if (qname != null) {
                base.set(ConfigOption.QUEUE_NAME.getCfgOption(), qname);
            }
        }
        catch (Exception e) {
            throw new ConfigException("Error extracting & merging queue name", e);
        }
        Integer directoryLimit = null;
        try {
            directoryLimit = extractor.getDirSize(opts.getValue(ConfigOption.DIR_SIZE.getOpt()));
        }
        catch (Exception e) {
            throw new ConfigException("Error extracting & merging directory file limit", e);
        }
        if (directoryLimit != null) {
            if (directoryLimit <= 0) {
                throw new ConfigException("Directory file limit can not be less than or equal to zero");
            }
            base.set(ConfigOption.DIR_SIZE.getCfgOption(), directoryLimit.toString());
        }
        Path basedir = null;
        try {
            basedir = extractor.getBaseDirectory(opts.getValue(ConfigOption.BASE_DIR.getOpt()));
        }
        catch (Exception e) {
            throw new ConfigException("Error extracting & merging base directory", e);
        }
        if (basedir != null) {
            basedir = new Path(basedir, "slive");
            base.set(ConfigOption.BASE_DIR.getCfgOption(), basedir.toString());
        }
        String fn = null;
        try {
            fn = extractor.getResultFile(opts.getValue(ConfigOption.RESULT_FILE.getOpt()));
        }
        catch (Exception e) {
            throw new ConfigException("Error extracting & merging result file", e);
        }
        if (fn != null) {
            base.set(ConfigOption.RESULT_FILE.getCfgOption(), fn);
        }
        fn = null;
        try {
            fn = extractor.getResultFile(opts.getValue(ConfigOption.RESULT_FILE.getOpt()));
        }
        catch (Exception e) {
            throw new ConfigException("Error extracting & merging result file", e);
        }
        if (fn != null) {
            base.set(ConfigOption.RESULT_FILE.getCfgOption(), fn);
        }
        try {
            base = this.handleOperations(opts, base, extractor);
        }
        catch (Exception e) {
            throw new ConfigException("Error extracting & merging operations", e);
        }
        Range<Short> replicationAm = null;
        try {
            replicationAm = extractor.getReplication(opts.getValue(ConfigOption.REPLICATION_AM.getOpt()));
        }
        catch (Exception e) {
            throw new ConfigException("Error extracting & merging replication amount range", e);
        }
        if (replicationAm != null) {
            int minRepl = base.getInt("dfs.namenode.replication.min", 1);
            if (replicationAm.getLower() < minRepl) {
                throw new ConfigException("Replication amount minimum is less than property configured minimum " + minRepl);
            }
            if (replicationAm.getLower() > replicationAm.getUpper()) {
                throw new ConfigException("Replication amount minimum is greater than its maximum");
            }
            if (replicationAm.getLower() <= 0) {
                throw new ConfigException("Replication amount minimum must be greater than zero");
            }
            base.set(ConfigOption.REPLICATION_AM.getCfgOption(), replicationAm.toString());
        }
        Range<Long> sleepRange = null;
        try {
            sleepRange = extractor.getSleepRange(opts.getValue(ConfigOption.SLEEP_TIME.getOpt()));
        }
        catch (Exception e) {
            throw new ConfigException("Error extracting & merging sleep size range", e);
        }
        if (sleepRange != null) {
            if (sleepRange.getLower() > sleepRange.getUpper()) {
                throw new ConfigException("Sleep range minimum is greater than its maximum");
            }
            if (sleepRange.getLower() <= 0L) {
                throw new ConfigException("Sleep range minimum must be greater than zero");
            }
            base.set(ConfigOption.SLEEP_TIME.getCfgOption(), sleepRange.toString());
        }
        if ((pSize = opts.getValue(ConfigOption.PACKET_SIZE.getOpt())) == null) {
            pSize = ConfigOption.PACKET_SIZE.getDefault();
        }
        if (pSize != null) {
            try {
                Long packetSize = StringUtils.TraditionalBinaryPrefix.string2long((String)pSize);
                base.set(ConfigOption.PACKET_SIZE.getCfgOption(), packetSize.toString());
            }
            catch (Exception e) {
                throw new ConfigException("Error extracting & merging write packet size", e);
            }
        }
        Range<Long> blockSize = null;
        try {
            blockSize = extractor.getBlockSize(opts.getValue(ConfigOption.BLOCK_SIZE.getOpt()));
        }
        catch (Exception e) {
            throw new ConfigException("Error extracting & merging block size range", e);
        }
        if (blockSize != null) {
            if (blockSize.getLower() > blockSize.getUpper()) {
                throw new ConfigException("Block size minimum is greater than its maximum");
            }
            if (blockSize.getLower() <= 0L) {
                throw new ConfigException("Block size minimum must be greater than zero");
            }
            Long bytesPerChecksum = extractor.getByteCheckSum();
            if (bytesPerChecksum != null) {
                if (blockSize.getLower() % bytesPerChecksum != 0L) {
                    throw new ConfigException("Blocksize lower bound must be a multiple of " + bytesPerChecksum);
                }
                if (blockSize.getUpper() % bytesPerChecksum != 0L) {
                    throw new ConfigException("Blocksize upper bound must be a multiple of " + bytesPerChecksum);
                }
            }
            base.set(ConfigOption.BLOCK_SIZE.getCfgOption(), blockSize.toString());
        }
        Range<Long> readSize = null;
        try {
            readSize = extractor.getReadSize(opts.getValue(ConfigOption.READ_SIZE.getOpt()));
        }
        catch (Exception e) {
            throw new ConfigException("Error extracting & merging read size range", e);
        }
        if (readSize != null) {
            if (readSize.getLower() > readSize.getUpper()) {
                throw new ConfigException("Read size minimum is greater than its maximum");
            }
            if (readSize.getLower() < 0L) {
                throw new ConfigException("Read size minimum must be greater than or equal to zero");
            }
            base.set(ConfigOption.READ_SIZE.getCfgOption(), readSize.toString());
        }
        Range<Long> writeSize = null;
        try {
            writeSize = extractor.getWriteSize(opts.getValue(ConfigOption.WRITE_SIZE.getOpt()));
        }
        catch (Exception e) {
            throw new ConfigException("Error extracting & merging write size range", e);
        }
        if (writeSize != null) {
            if (writeSize.getLower() > writeSize.getUpper()) {
                throw new ConfigException("Write size minimum is greater than its maximum");
            }
            if (writeSize.getLower() < 0L) {
                throw new ConfigException("Write size minimum must be greater than or equal to zero");
            }
            base.set(ConfigOption.WRITE_SIZE.getCfgOption(), writeSize.toString());
        }
        Range<Long> appendSize = null;
        try {
            appendSize = extractor.getAppendSize(opts.getValue(ConfigOption.APPEND_SIZE.getOpt()));
        }
        catch (Exception e) {
            throw new ConfigException("Error extracting & merging append size range", e);
        }
        if (appendSize != null) {
            if (appendSize.getLower() > appendSize.getUpper()) {
                throw new ConfigException("Append size minimum is greater than its maximum");
            }
            if (appendSize.getLower() < 0L) {
                throw new ConfigException("Append size minimum must be greater than or equal to zero");
            }
            base.set(ConfigOption.APPEND_SIZE.getCfgOption(), appendSize.toString());
        }
        Range<Long> truncateSize = null;
        try {
            truncateSize = extractor.getTruncateSize(opts.getValue(ConfigOption.TRUNCATE_SIZE.getOpt()));
        }
        catch (Exception e) {
            throw new ConfigException("Error extracting & merging truncate size range", e);
        }
        if (truncateSize != null) {
            if (truncateSize.getLower() > truncateSize.getUpper()) {
                throw new ConfigException("Truncate size minimum is greater than its maximum");
            }
            if (truncateSize.getLower() < 0L) {
                throw new ConfigException("Truncate size minimum must be greater than or equal to zero");
            }
            base.set(ConfigOption.TRUNCATE_SIZE.getCfgOption(), truncateSize.toString());
        }
        Long seed = null;
        try {
            seed = extractor.getRandomSeed(opts.getValue(ConfigOption.RANDOM_SEED.getOpt()));
        }
        catch (Exception e) {
            throw new ConfigException("Error extracting & merging random number seed", e);
        }
        if (seed != null) {
            base.set(ConfigOption.RANDOM_SEED.getCfgOption(), seed.toString());
        }
        return base;
    }

    static class ConfigException
    extends IOException {
        private static final long serialVersionUID = 2047129184917444550L;

        ConfigException(String msg) {
            super(msg);
        }

        ConfigException(String msg, Throwable e) {
            super(msg, e);
        }
    }
}

