/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.router.webapp;

import org.apache.hadoop.yarn.server.resourcemanager.webapp.JAXBContextResolver;
import org.apache.hadoop.yarn.server.router.Router;
import org.apache.hadoop.yarn.server.router.webapp.RouterController;
import org.apache.hadoop.yarn.server.router.webapp.RouterWebServices;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.WebApp;
import org.apache.hadoop.yarn.webapp.YarnWebParams;

public class RouterWebApp
extends WebApp
implements YarnWebParams {
    private Router router;

    public RouterWebApp(Router router) {
        this.router = router;
    }

    public void setup() {
        this.bind(JAXBContextResolver.class);
        this.bind(RouterWebServices.class);
        this.bind(GenericExceptionHandler.class);
        this.bind(RouterWebApp.class).toInstance((Object)this);
        if (this.router != null) {
            this.bind(Router.class).toInstance((Object)this.router);
        }
        this.route("/", RouterController.class);
        this.route("/cluster", RouterController.class, "about");
        this.route("/about", RouterController.class, "about");
        this.route(StringHelper.pajoin((Object[])new Object[]{"/apps", "app.subcluster", "app.state"}), RouterController.class, "apps");
        this.route(StringHelper.pajoin((Object[])new Object[]{"/nodes", "node.subcluster"}), RouterController.class, "nodes");
        this.route("/federation", RouterController.class, "federation");
        this.route(StringHelper.pajoin((Object[])new Object[]{"/nodelabels", "node.subcluster"}), RouterController.class, "nodeLabels");
    }
}

