/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.placement.converter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;

public class LegacyMappingRuleToJson {
    public static final String RULE_PART_DELIMITER = ":";
    public static final String PREFIX_USER_MAPPING = "u";
    public static final String PREFIX_GROUP_MAPPING = "g";
    public static final String MATCHER_APPLICATION = "%application";
    public static final String MATCHER_USER = "%user";
    public static final String MAPPING_PRIMARY_GROUP = "%primary_group";
    public static final String MAPPING_SECONDARY_GROUP = "%secondary_group";
    public static final String MAPPING_USER = "%user";
    public static final String JSON_MATCH_ALL = "*";
    public static final String JSON_NODE_POLICY = "policy";
    public static final String JSON_NODE_PARENT_QUEUE = "parentQueue";
    public static final String JSON_NODE_CUSTOM_PLACEMENT = "customPlacement";
    public static final String JSON_NODE_MATCHES = "matches";
    private ObjectMapper objectMapper = new ObjectMapper();
    private Collection<String> userGroupMappingRules = new ArrayList<String>();
    private Collection<String> applicationNameMappingRules = new ArrayList<String>();

    public LegacyMappingRuleToJson setUserGroupMappingRules(String rules) {
        this.setUserGroupMappingRules(StringUtils.getTrimmedStringCollection((String)rules));
        return this;
    }

    public LegacyMappingRuleToJson setUserGroupMappingRules(Collection<String> rules) {
        this.userGroupMappingRules = rules != null ? rules : new ArrayList<String>();
        return this;
    }

    public LegacyMappingRuleToJson setAppNameMappingRules(String rules) {
        this.setAppNameMappingRules(StringUtils.getTrimmedStringCollection((String)rules));
        return this;
    }

    public LegacyMappingRuleToJson setAppNameMappingRules(Collection<String> rules) {
        this.applicationNameMappingRules = rules != null ? rules : new ArrayList<String>();
        return this;
    }

    public String convert() {
        ObjectNode rootNode = this.objectMapper.createObjectNode();
        ArrayNode rulesNode = this.objectMapper.createArrayNode();
        rootNode.set("rules", (JsonNode)rulesNode);
        for (String rule : this.userGroupMappingRules) {
            rulesNode.add((JsonNode)this.convertUserGroupMappingRule(rule));
        }
        for (String rule : this.applicationNameMappingRules) {
            rulesNode.add((JsonNode)this.convertAppNameMappingRule(rule));
        }
        if (rulesNode.size() == 0) {
            return null;
        }
        try {
            return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)rootNode);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    ObjectNode convertUserGroupMappingRule(String rule) {
        String[] mapping = this.splitRule(rule, 3);
        String ruleType = mapping[0];
        String ruleMatch = mapping[1];
        String ruleTarget = mapping[2];
        if (ruleType.equals(PREFIX_USER_MAPPING)) {
            return this.createUserMappingRule(ruleMatch, ruleTarget);
        }
        if (ruleType.equals(PREFIX_GROUP_MAPPING)) {
            return this.createGroupMappingRule(ruleMatch, ruleTarget);
        }
        throw new IllegalArgumentException("User group mapping rule must start with prefix 'u' or 'g'");
    }

    ObjectNode convertAppNameMappingRule(String rule) {
        String[] mapping = this.splitRule(rule, 2);
        String ruleMatch = mapping[0];
        String ruleTarget = mapping[1];
        return this.createApplicationNameMappingRule(ruleMatch, ruleTarget);
    }

    private String[] splitRule(String rule, int expectedParts) {
        String[] mapping = StringUtils.getTrimmedStringCollection((String)rule, (String)RULE_PART_DELIMITER).toArray(new String[0]);
        if (mapping.length != expectedParts) {
            throw new IllegalArgumentException("Invalid rule '" + rule + "' expected parts: " + expectedParts + " actual parts: " + mapping.length);
        }
        for (int i = 0; i < mapping.length; ++i) {
            if (mapping[i].length() != 0) continue;
            throw new IllegalArgumentException("Invalid rule '" + rule + "' with empty part, mapping rules must not contain empty parts!");
        }
        return mapping;
    }

    private ObjectNode createDefaultRuleNode(String type) {
        return this.objectMapper.createObjectNode().put("type", type).put("fallbackResult", "placeDefault").put("create", true);
    }

    private ObjectNode createUserMappingRule(String match, String target) {
        ObjectNode ruleNode = this.createDefaultRuleNode("user");
        QueuePath targetPath = new QueuePath(target);
        if (match.equals("%user")) {
            match = JSON_MATCH_ALL;
        }
        ruleNode.put(JSON_NODE_MATCHES, match);
        switch (targetPath.getLeafName()) {
            case "%user": {
                ruleNode.put(JSON_NODE_POLICY, "user");
                if (!targetPath.hasParent()) break;
                QueuePath targetParentPath = new QueuePath(targetPath.getParent());
                String parentShortName = targetParentPath.getLeafName();
                if (parentShortName.equals(MAPPING_PRIMARY_GROUP)) {
                    ruleNode.put(JSON_NODE_POLICY, "primaryGroupUser");
                    targetPath = new QueuePath(targetParentPath.getParent(), targetPath.getLeafName());
                    break;
                }
                if (!parentShortName.equals(MAPPING_SECONDARY_GROUP)) break;
                ruleNode.put(JSON_NODE_POLICY, "secondaryGroupUser");
                targetPath = new QueuePath(targetParentPath.getParent(), targetPath.getLeafName());
                break;
            }
            case "%primary_group": {
                ruleNode.put(JSON_NODE_POLICY, "primaryGroup");
                break;
            }
            case "%secondary_group": {
                ruleNode.put(JSON_NODE_POLICY, "secondaryGroup");
                break;
            }
            default: {
                ruleNode.put(JSON_NODE_POLICY, "custom");
                ruleNode.put(JSON_NODE_CUSTOM_PLACEMENT, targetPath.getFullPath());
            }
        }
        if (targetPath.hasParent()) {
            ruleNode.put(JSON_NODE_PARENT_QUEUE, targetPath.getParent());
        }
        return ruleNode;
    }

    private ObjectNode createGroupMappingRule(String match, String target) {
        ObjectNode ruleNode = this.createDefaultRuleNode("group");
        QueuePath targetPath = new QueuePath(target);
        ruleNode.put(JSON_NODE_MATCHES, match);
        if (targetPath.getLeafName().matches("%user")) {
            ruleNode.put(JSON_NODE_POLICY, "user");
            if (targetPath.hasParent()) {
                ruleNode.put(JSON_NODE_PARENT_QUEUE, targetPath.getParent());
            }
        } else {
            ruleNode.put(JSON_NODE_POLICY, "custom");
            ruleNode.put(JSON_NODE_CUSTOM_PLACEMENT, targetPath.getFullPath());
        }
        return ruleNode;
    }

    private ObjectNode createApplicationNameMappingRule(String match, String target) {
        ObjectNode ruleNode = this.createDefaultRuleNode("application");
        QueuePath targetPath = new QueuePath(target);
        ruleNode.put(JSON_NODE_MATCHES, match);
        if (targetPath.getLeafName().matches(MATCHER_APPLICATION)) {
            ruleNode.put(JSON_NODE_POLICY, "applicationName");
            if (targetPath.hasParent()) {
                ruleNode.put(JSON_NODE_PARENT_QUEUE, targetPath.getParent());
            }
        } else {
            ruleNode.put(JSON_NODE_POLICY, "custom");
            ruleNode.put(JSON_NODE_CUSTOM_PLACEMENT, targetPath.getFullPath());
        }
        return ruleNode;
    }
}

