/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.ReadStripedFileWithDecodingHelper;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class TestReadStripedFileWithDNFailure {
    static final Logger LOG = LoggerFactory.getLogger(TestReadStripedFileWithDNFailure.class);
    private static MiniDFSCluster cluster;
    private static DistributedFileSystem dfs;
    @Rule
    public Timeout globalTimeout = new Timeout(300000);
    private int fileLength;
    private int dnFailureNum;

    @BeforeClass
    public static void setup() throws IOException {
        cluster = ReadStripedFileWithDecodingHelper.initializeCluster();
        dfs = cluster.getFileSystem();
    }

    @AfterClass
    public static void tearDown() throws IOException {
        ReadStripedFileWithDecodingHelper.tearDownCluster(cluster);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (int fileLength : ReadStripedFileWithDecodingHelper.FILE_LENGTHS) {
            for (int i = 0; i < ReadStripedFileWithDecodingHelper.NUM_PARITY_UNITS; ++i) {
                params.add(new Object[]{fileLength, i + 1});
            }
        }
        return params;
    }

    public TestReadStripedFileWithDNFailure(int fileLength, int dnFailureNum) {
        this.fileLength = fileLength;
        this.dnFailureNum = dnFailureNum;
    }

    @Test
    public void testReadWithDNFailure() throws Exception {
        try {
            TestReadStripedFileWithDNFailure.setup();
            ReadStripedFileWithDecodingHelper.testReadWithDNFailure(cluster, dfs, this.fileLength, this.dnFailureNum);
        }
        catch (IOException ioe) {
            String fileType = this.fileLength < ReadStripedFileWithDecodingHelper.BLOCK_SIZE * ReadStripedFileWithDecodingHelper.NUM_DATA_UNITS ? "smallFile" : "largeFile";
            LOG.error("Failed to read file with DN failure: fileType = " + fileType + ", dnFailureNum = " + this.dnFailureNum);
        }
        finally {
            TestReadStripedFileWithDNFailure.tearDown();
        }
    }
}

