/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.YarnConfigurationStore;

public class InMemoryConfigurationStore
extends YarnConfigurationStore {
    private Configuration schedConf;
    private long configVersion;

    @Override
    public void initialize(Configuration conf, Configuration schedConf, RMContext rmContext) {
        this.schedConf = schedConf;
        this.configVersion = 1L;
    }

    @Override
    public void logMutation(YarnConfigurationStore.LogMutation logMutation) {
    }

    @Override
    public void confirmMutation(YarnConfigurationStore.LogMutation pendingMutation, boolean isValid) {
        if (isValid) {
            for (Map.Entry<String, String> kv : pendingMutation.getUpdates().entrySet()) {
                if (kv.getValue() == null) {
                    this.schedConf.unset(kv.getKey());
                    continue;
                }
                this.schedConf.set(kv.getKey(), kv.getValue());
            }
            ++this.configVersion;
        }
    }

    @Override
    public void format() {
        this.schedConf = null;
    }

    @Override
    public synchronized Configuration retrieve() {
        return this.schedConf;
    }

    @Override
    public long getConfigVersion() {
        return this.configVersion;
    }

    @Override
    public List<YarnConfigurationStore.LogMutation> getConfirmedConfHistory(long fromId) {
        return null;
    }

    @Override
    protected LinkedList<YarnConfigurationStore.LogMutation> getLogs() {
        return null;
    }

    @Override
    public Version getConfStoreVersion() throws Exception {
        return null;
    }

    @Override
    public void storeVersion() throws Exception {
    }

    @Override
    public Version getCurrentVersion() {
        return null;
    }

    @Override
    public void checkVersion() {
    }

    @Override
    public void close() throws IOException {
    }
}

