/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.fpga.discovery;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.fpga.FpgaDevice;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.fpga.discovery.DeviceSpecParser;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.fpga.discovery.FPGADiscoveryStrategy;

public class ScriptBasedFPGADiscoveryStrategy
implements FPGADiscoveryStrategy {
    private final Function<String, Optional<String>> scriptRunner;
    private final String discoveryScript;
    private final String type;

    public ScriptBasedFPGADiscoveryStrategy(String fpgaType, Function<String, Optional<String>> scriptRunner, String propValue) {
        this.scriptRunner = scriptRunner;
        this.discoveryScript = propValue;
        this.type = fpgaType;
    }

    @Override
    public List<FpgaDevice> discover() throws ResourceHandlerException {
        Optional<String> scriptOutput = this.scriptRunner.apply(this.discoveryScript);
        if (scriptOutput.isPresent()) {
            List<FpgaDevice> list = DeviceSpecParser.getDevicesFromString(this.type, scriptOutput.get());
            if (list.isEmpty()) {
                throw new ResourceHandlerException("No FPGA devices were specified");
            }
            return list;
        }
        throw new ResourceHandlerException("Unable to run external script");
    }
}

