/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.terracotta.management.model.stats;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.BinaryOperator;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import org.apache.hadoop.shaded.org.ehcache.shadow.org.terracotta.statistics.StatisticType;
import org.apache.hadoop.shaded.org.ehcache.shadow.org.terracotta.statistics.ValueStatistic;
import org.apache.hadoop.shaded.org.terracotta.management.model.capabilities.descriptors.StatisticDescriptor;
import org.apache.hadoop.shaded.org.terracotta.management.model.stats.DelegatingStatistic;
import org.apache.hadoop.shaded.org.terracotta.management.model.stats.Statistic;

public class StatisticRegistry
extends org.apache.hadoop.shaded.org.ehcache.shadow.org.terracotta.statistics.registry.StatisticRegistry {
    public StatisticRegistry(Object contextObject, LongSupplier timeSource) {
        super(contextObject, timeSource);
    }

    public Collection<StatisticDescriptor> getDescriptors() {
        HashSet<StatisticDescriptor> descriptors = new HashSet<StatisticDescriptor>(this.getStatistics().size());
        for (Map.Entry<String, ValueStatistic<? extends Serializable>> entry : this.getStatistics().entrySet()) {
            String fullStatName = entry.getKey();
            StatisticType type = entry.getValue().type();
            descriptors.add(new StatisticDescriptor(fullStatName, type.name()));
        }
        return descriptors;
    }

    public static Map<String, Statistic<? extends Serializable>> collect(StatisticRegistry registry, Collection<String> statisticNames, long since) {
        if (statisticNames == null || statisticNames.isEmpty()) {
            return registry.queryStatistics(since).entrySet().stream().filter(e -> !((org.apache.hadoop.shaded.org.ehcache.shadow.org.terracotta.statistics.registry.Statistic)e.getValue()).isEmpty()).map(x -> new Map.Entry<String, Statistic<? extends Serializable>>(){

                @Override
                public String getKey() {
                    return (String)x.getKey();
                }

                @Override
                public Statistic<? extends Serializable> getValue() {
                    return new DelegatingStatistic((org.apache.hadoop.shaded.org.ehcache.shadow.org.terracotta.statistics.registry.Statistic)x.getValue());
                }

                @Override
                public Statistic<? extends Serializable> setValue(Statistic<? extends Serializable> value) {
                    throw new UnsupportedOperationException("Can't set value");
                }
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, StatisticRegistry.throwingMerger(), TreeMap::new));
        }
        return statisticNames.stream().map(name -> new AbstractMap.SimpleEntry((String)name, registry.queryStatistic((String)name, since))).filter(e -> ((Optional)e.getValue()).isPresent() && !((org.apache.hadoop.shaded.org.ehcache.shadow.org.terracotta.statistics.registry.Statistic)((Optional)e.getValue()).get()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, e -> new DelegatingStatistic((org.apache.hadoop.shaded.org.ehcache.shadow.org.terracotta.statistics.registry.Statistic)((Optional)e.getValue()).get()), StatisticRegistry.throwingMerger(), TreeMap::new));
    }

    private static <T> BinaryOperator<T> throwingMerger() {
        return (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        };
    }
}

