/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.ehcache.xml.provider;

import java.math.BigInteger;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.shaded.org.ehcache.impl.config.executor.PooledExecutionServiceConfiguration;
import org.apache.hadoop.shaded.org.ehcache.xml.model.ConfigType;
import org.apache.hadoop.shaded.org.ehcache.xml.model.ThreadPoolsType;
import org.apache.hadoop.shaded.org.ehcache.xml.provider.SimpleCoreServiceCreationConfigurationParser;

public class PooledExecutionServiceConfigurationParser
extends SimpleCoreServiceCreationConfigurationParser<ThreadPoolsType, PooledExecutionServiceConfiguration> {
    public PooledExecutionServiceConfigurationParser() {
        super(PooledExecutionServiceConfiguration.class, ConfigType::getThreadPools, ConfigType::setThreadPools, (T config) -> {
            PooledExecutionServiceConfiguration poolsConfiguration = new PooledExecutionServiceConfiguration();
            for (ThreadPoolsType.ThreadPool pool : config.getThreadPool()) {
                if (pool.isDefault()) {
                    poolsConfiguration.addDefaultPool(pool.getAlias(), pool.getMinSize().intValue(), pool.getMaxSize().intValue());
                    continue;
                }
                poolsConfiguration.addPool(pool.getAlias(), pool.getMinSize().intValue(), pool.getMaxSize().intValue());
            }
            return poolsConfiguration;
        }, (U config) -> {
            List<ThreadPoolsType.ThreadPool> threadPools = config.getPoolConfigurations().entrySet().stream().map(entry -> {
                PooledExecutionServiceConfiguration.PoolConfiguration poolConfig = (PooledExecutionServiceConfiguration.PoolConfiguration)entry.getValue();
                String alias = (String)entry.getKey();
                ThreadPoolsType.ThreadPool threadPool = new ThreadPoolsType.ThreadPool().withAlias(alias).withMinSize(BigInteger.valueOf(poolConfig.minSize())).withMaxSize(BigInteger.valueOf(poolConfig.maxSize()));
                if (alias.equals(config.getDefaultPoolAlias())) {
                    threadPool.setDefault(true);
                }
                return threadPool;
            }).collect(Collectors.toList());
            return new ThreadPoolsType().withThreadPool(threadPools);
        });
    }
}

