/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.javax.cache.integration;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.shaded.javax.cache.integration.CompletionListener;

public class CompletionListenerFuture
implements CompletionListener,
Future<Void> {
    private final Object lock = new Object();
    private boolean isCompleted = false;
    private Exception exception = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCompletion() throws IllegalStateException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isCompleted) {
                throw new IllegalStateException("Attempted to use a CompletionListenerFuture instance more than once");
            }
            this.markAsCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onException(Exception e) throws IllegalStateException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isCompleted) {
                throw new IllegalStateException("Attempted to use a CompletionListenerFuture instance more than once");
            }
            this.exception = e;
            this.markAsCompleted();
        }
    }

    private void markAsCompleted() {
        assert (Thread.holdsLock(this.lock));
        this.isCompleted = true;
        this.lock.notifyAll();
    }

    @Override
    public boolean cancel(boolean b) {
        throw new UnsupportedOperationException("CompletionListenerFutures can't be cancelled");
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        Object object = this.lock;
        synchronized (object) {
            return this.isCompleted;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void get() throws InterruptedException, ExecutionException {
        Object object = this.lock;
        synchronized (object) {
            while (!this.isCompleted) {
                this.lock.wait();
            }
            if (this.exception != null) {
                throw new ExecutionException(this.exception);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long endTime = System.currentTimeMillis() + unit.toMillis(timeout);
        Object object = this.lock;
        synchronized (object) {
            while (!this.isCompleted) {
                long waitTime = endTime - System.currentTimeMillis();
                if (waitTime <= 0L) {
                    throw new TimeoutException();
                }
                this.lock.wait(waitTime);
            }
            if (this.exception != null) {
                throw new ExecutionException(this.exception);
            }
        }
        return null;
    }
}

