/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.Statistic;
import org.apache.hadoop.fs.s3a.impl.AbstractStoreOperation;
import org.apache.hadoop.fs.s3a.impl.StoreContext;
import org.apache.hadoop.fs.s3a.statistics.S3AStatisticsContext;
import org.apache.hadoop.fs.statistics.DurationTrackerFactory;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.s3.model.CopyObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadBucketResponse;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;

public class HeaderProcessing
extends AbstractStoreOperation {
    private static final Logger LOG = LoggerFactory.getLogger(HeaderProcessing.class);
    private static final byte[] EMPTY = new byte[0];
    public static final String XA_CACHE_CONTROL = "header.Cache-Control";
    public static final String XA_CONTENT_DISPOSITION = "header.Content-Disposition";
    public static final String XA_CONTENT_ENCODING = "header.Content-Encoding";
    public static final String XA_CONTENT_LANGUAGE = "header.Content-Language";
    public static final String XA_CONTENT_LENGTH = "header.Content-Length";
    public static final String XA_CONTENT_MD5 = "header.Content-MD5";
    public static final String XA_CONTENT_RANGE = "header.Content-Range";
    public static final String XA_CONTENT_TYPE = "header.Content-Type";
    public static final String XA_ETAG = "header.ETag";
    public static final String XA_LAST_MODIFIED = "header.Last-Modified";
    public static final String XA_ARCHIVE_STATUS = "header.x-amz-archive-status";
    public static final String XA_OBJECT_LOCK_LEGAL_HOLD_STATUS = "header.x-amz-object-lock-legal-hold";
    public static final String XA_OBJECT_LOCK_MODE = "header.x-amz-object-lock-mode";
    public static final String XA_OBJECT_LOCK_RETAIN_UNTIL_DATE = "header.x-amz-object-lock-retain-until-date";
    public static final String XA_OBJECT_REPLICATION_STATUS = "header.x-amz-replication-status";
    public static final String XA_S3_VERSION_ID = "header.x-amz-version-id";
    public static final String XA_SERVER_SIDE_ENCRYPTION = "header.x-amz-server-side-encryption";
    public static final String XA_ENCRYPTION_KEY_ID = "header.x-amz-server-side-encryption-aws-kms-key-id";
    public static final String XA_STORAGE_CLASS = "header.x-amz-storage-class";
    public static final String HEADER_REFERRER = "Referer";
    public static final String[] XA_STANDARD_HEADERS = new String[]{"header.Cache-Control", "header.Content-Disposition", "header.Content-Encoding", "header.Content-Language", "header.Content-Length", "header.Content-MD5", "header.Content-Range", "header.Content-Type", "header.ETag", "header.Last-Modified", "header.x-amz-archive-status", "header.x-amz-object-lock-legal-hold", "header.x-amz-object-lock-mode", "header.x-amz-object-lock-retain-until-date", "header.x-amz-replication-status", "header.x-amz-version-id", "header.x-amz-server-side-encryption", "header.x-amz-storage-class"};
    public static final String CONTENT_TYPE_OCTET_STREAM = "application/octet-stream";
    public static final String CONTENT_TYPE_APPLICATION_XML = "application/xml";
    public static final String CONTENT_TYPE_X_DIRECTORY = "application/x-directory";
    private final HeaderProcessingCallbacks callbacks;

    public HeaderProcessing(StoreContext storeContext, HeaderProcessingCallbacks callbacks) {
        super(storeContext);
        this.callbacks = callbacks;
    }

    private Map<String, byte[]> retrieveHeaders(Path path, Statistic statistic) throws IOException {
        HeadObjectResponse md;
        StoreContext context = this.getStoreContext();
        String objectKey = context.pathToKey(path);
        String symbol = statistic.getSymbol();
        S3AStatisticsContext instrumentation = context.getInstrumentation();
        TreeMap<String, byte[]> headers = new TreeMap<String, byte[]>();
        if (objectKey.isEmpty()) {
            HeadBucketResponse headBucketResponse = (HeadBucketResponse)IOStatisticsBinding.trackDuration((DurationTrackerFactory)instrumentation, (String)symbol, () -> this.callbacks.getBucketMetadata());
            if (headBucketResponse.sdkHttpResponse() != null && headBucketResponse.sdkHttpResponse().headers() != null && headBucketResponse.sdkHttpResponse().headers().get("Content-Type") != null) {
                this.maybeSetHeader(headers, XA_CONTENT_TYPE, ((List)headBucketResponse.sdkHttpResponse().headers().get("Content-Type")).get(0));
            }
            this.maybeSetHeader(headers, XA_CONTENT_LENGTH, 0);
            return headers;
        }
        try {
            md = (HeadObjectResponse)IOStatisticsBinding.trackDuration((DurationTrackerFactory)instrumentation, (String)symbol, () -> this.callbacks.getObjectMetadata(objectKey));
        }
        catch (FileNotFoundException e) {
            md = (HeadObjectResponse)IOStatisticsBinding.trackDuration((DurationTrackerFactory)instrumentation, (String)symbol, () -> this.callbacks.getObjectMetadata(objectKey + "/"));
        }
        Map rawHeaders = md.metadata();
        rawHeaders.forEach((key, value) -> headers.put("header." + key, HeaderProcessing.encodeBytes(value)));
        this.maybeSetHeader(headers, XA_CACHE_CONTROL, md.cacheControl());
        this.maybeSetHeader(headers, XA_CONTENT_DISPOSITION, md.contentDisposition());
        this.maybeSetHeader(headers, XA_CONTENT_ENCODING, md.contentEncoding());
        this.maybeSetHeader(headers, XA_CONTENT_LANGUAGE, md.contentLanguage());
        this.maybeSetHeader(headers, XA_CONTENT_LENGTH, md.contentLength());
        if (md.sdkHttpResponse() != null && md.sdkHttpResponse().headers() != null && md.sdkHttpResponse().headers().get("Content-Range") != null) {
            this.maybeSetHeader(headers, XA_CONTENT_RANGE, ((List)md.sdkHttpResponse().headers().get("Content-Range")).get(0));
        }
        this.maybeSetHeader(headers, XA_CONTENT_TYPE, md.contentType());
        this.maybeSetHeader(headers, XA_ETAG, md.eTag());
        this.maybeSetHeader(headers, XA_LAST_MODIFIED, Date.from(md.lastModified()));
        this.maybeSetHeader(headers, XA_ARCHIVE_STATUS, md.archiveStatus());
        this.maybeSetHeader(headers, XA_OBJECT_LOCK_LEGAL_HOLD_STATUS, md.objectLockLegalHoldStatus());
        this.maybeSetHeader(headers, XA_OBJECT_LOCK_MODE, md.objectLockMode());
        this.maybeSetHeader(headers, XA_OBJECT_LOCK_RETAIN_UNTIL_DATE, md.objectLockRetainUntilDate());
        this.maybeSetHeader(headers, XA_OBJECT_REPLICATION_STATUS, md.replicationStatus());
        this.maybeSetHeader(headers, XA_S3_VERSION_ID, md.versionId());
        this.maybeSetHeader(headers, XA_SERVER_SIDE_ENCRYPTION, md.serverSideEncryptionAsString());
        this.maybeSetHeader(headers, XA_ENCRYPTION_KEY_ID, md.ssekmsKeyId());
        this.maybeSetHeader(headers, XA_STORAGE_CLASS, md.storageClassAsString());
        return headers;
    }

    private void maybeSetHeader(Map<String, byte[]> headers, String name, Object value) {
        if (value != null) {
            headers.put(name, HeaderProcessing.encodeBytes(value));
        }
    }

    public static byte[] encodeBytes(@Nullable Object s) {
        return s == null ? EMPTY : s.toString().getBytes(StandardCharsets.UTF_8);
    }

    public static String decodeBytes(byte[] bytes) {
        return bytes == null ? null : new String(bytes, StandardCharsets.UTF_8);
    }

    public byte[] getXAttr(Path path, String name) throws IOException {
        return this.retrieveHeaders(path, Statistic.INVOCATION_XATTR_GET_NAMED).get(name);
    }

    public Map<String, byte[]> getXAttrs(Path path) throws IOException {
        return this.retrieveHeaders(path, Statistic.INVOCATION_XATTR_GET_MAP);
    }

    public List<String> listXAttrs(Path path) throws IOException {
        return new ArrayList<String>(this.retrieveHeaders(path, Statistic.INVOCATION_OP_XATTR_LIST).keySet());
    }

    public Map<String, byte[]> getXAttrs(Path path, List<String> names) throws IOException {
        Map<String, byte[]> headers = this.retrieveHeaders(path, Statistic.INVOCATION_XATTR_GET_NAMED_MAP);
        TreeMap<String, byte[]> result = new TreeMap<String, byte[]>();
        headers.entrySet().stream().filter(entry -> names.contains(entry.getKey())).forEach(entry -> {
            byte[] cfr_ignored_0 = (byte[])result.put((String)entry.getKey(), (byte[])entry.getValue());
        });
        return result;
    }

    public static Optional<Long> extractXAttrLongValue(byte[] data) {
        String xAttr = HeaderProcessing.decodeBytes(data);
        if (StringUtils.isNotEmpty((CharSequence)xAttr)) {
            try {
                long l = Long.parseLong(xAttr);
                if (l >= 0L) {
                    return Optional.of(l);
                }
            }
            catch (NumberFormatException ex) {
                LOG.warn("Not a number: {}", (Object)xAttr, (Object)ex);
            }
        }
        return Optional.empty();
    }

    public static void cloneObjectMetadata(HeadObjectResponse source, Map<String, String> dest, CopyObjectRequest.Builder copyObjectRequestBuilder) {
        if (source.cacheControl() != null) {
            copyObjectRequestBuilder.cacheControl(source.cacheControl());
        }
        if (source.contentDisposition() != null) {
            copyObjectRequestBuilder.contentDisposition(source.contentDisposition());
        }
        if (source.contentEncoding() != null) {
            copyObjectRequestBuilder.contentEncoding(source.contentEncoding());
        }
        if (source.contentType() != null) {
            copyObjectRequestBuilder.contentType(source.contentType());
        }
        if (source.serverSideEncryption() != null) {
            copyObjectRequestBuilder.serverSideEncryption(source.serverSideEncryption());
        }
        if (source.sseCustomerAlgorithm() != null) {
            copyObjectRequestBuilder.copySourceSSECustomerAlgorithm(source.sseCustomerAlgorithm());
        }
        if (source.sseCustomerKeyMD5() != null) {
            copyObjectRequestBuilder.copySourceSSECustomerKeyMD5(source.sseCustomerKeyMD5());
        }
        source.metadata().entrySet().stream().filter(e -> !((String)e.getKey()).equals("x-hadoop-s3a-magic-data-length")).forEach(e -> {
            String cfr_ignored_0 = (String)dest.put((String)e.getKey(), (String)e.getValue());
        });
    }

    public static interface HeaderProcessingCallbacks {
        public HeadObjectResponse getObjectMetadata(String var1) throws IOException;

        public HeadBucketResponse getBucketMetadata() throws IOException;
    }
}

