/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal.caches;

import com.microsoft.azure.cosmosdb.DocumentClientException;
import com.microsoft.azure.cosmosdb.FeedOptions;
import com.microsoft.azure.cosmosdb.PartitionKeyRange;
import com.microsoft.azure.cosmosdb.internal.OperationType;
import com.microsoft.azure.cosmosdb.internal.ResourceType;
import com.microsoft.azure.cosmosdb.internal.routing.CollectionRoutingMap;
import com.microsoft.azure.cosmosdb.internal.routing.InMemoryCollectionRoutingMap;
import com.microsoft.azure.cosmosdb.internal.routing.Range;
import com.microsoft.azure.cosmosdb.rx.AsyncDocumentClient;
import com.microsoft.azure.cosmosdb.rx.internal.Exceptions;
import com.microsoft.azure.cosmosdb.rx.internal.NotFoundException;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import com.microsoft.azure.cosmosdb.rx.internal.Utils;
import com.microsoft.azure.cosmosdb.rx.internal.caches.AsyncCache;
import com.microsoft.azure.cosmosdb.rx.internal.caches.IPartitionKeyRangeCache;
import com.microsoft.azure.cosmosdb.rx.internal.caches.RxCollectionCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Single;

public class RxPartitionKeyRangeCache
implements IPartitionKeyRangeCache {
    private final Logger logger = LoggerFactory.getLogger(RxPartitionKeyRangeCache.class);
    private final AsyncCache<String, CollectionRoutingMap> routingMapCache = new AsyncCache();
    private final AsyncDocumentClient client;
    private final RxCollectionCache collectionCache;

    public RxPartitionKeyRangeCache(AsyncDocumentClient client, RxCollectionCache collectionCache) {
        this.client = client;
        this.collectionCache = collectionCache;
    }

    public Single<CollectionRoutingMap> tryLookupAsync(String collectionRid, CollectionRoutingMap previousValue, Map<String, Object> properties) {
        return this.routingMapCache.getAsync((Object)collectionRid, (Object)previousValue, () -> this.getRoutingMapForCollectionAsync(collectionRid, previousValue, properties)).onErrorResumeNext(err -> {
            this.logger.debug("tryLookupAsync on collectionRid {} encountered failure", (Object)collectionRid, err);
            DocumentClientException dce = (DocumentClientException)Utils.as((Object)err, DocumentClientException.class);
            if (dce != null && Exceptions.isStatusCode((DocumentClientException)dce, (int)404)) {
                return Single.just(null);
            }
            return Single.error((Throwable)err);
        });
    }

    public Single<CollectionRoutingMap> tryLookupAsync(String collectionRid, CollectionRoutingMap previousValue, boolean forceRefreshCollectionRoutingMap, Map<String, Object> properties) {
        return this.tryLookupAsync(collectionRid, previousValue, properties);
    }

    public Single<List<PartitionKeyRange>> tryGetOverlappingRangesAsync(String collectionRid, Range<String> range, boolean forceRefresh, Map<String, Object> properties) {
        Single<CollectionRoutingMap> routingMapObs = this.tryLookupAsync(collectionRid, null, properties);
        return routingMapObs.flatMap(routingMap -> {
            if (forceRefresh && routingMap != null) {
                this.logger.debug("tryGetOverlappingRangesAsync with forceRefresh on collectionRid {}", (Object)collectionRid);
                return this.tryLookupAsync(collectionRid, (CollectionRoutingMap)routingMap, properties);
            }
            return Single.just((Object)routingMap);
        }).map(routingMap -> {
            if (routingMap != null) {
                return new ArrayList(routingMap.getOverlappingRanges(range));
            }
            this.logger.debug("Routing Map Null for collection: {} for range: {}, forceRefresh:{}", new Object[]{collectionRid, range.toString(), forceRefresh});
            return null;
        });
    }

    public Single<PartitionKeyRange> tryGetPartitionKeyRangeByIdAsync(String collectionResourceId, String partitionKeyRangeId, boolean forceRefresh, Map<String, Object> properties) {
        Single<CollectionRoutingMap> routingMapObs = this.tryLookupAsync(collectionResourceId, null, properties);
        return routingMapObs.flatMap(routingMap -> {
            if (forceRefresh && routingMap != null) {
                return this.tryLookupAsync(collectionResourceId, (CollectionRoutingMap)routingMap, properties);
            }
            return Single.just((Object)routingMap);
        }).map(routingMap -> {
            if (routingMap != null) {
                return routingMap.getRangeByPartitionKeyRangeId(partitionKeyRangeId);
            }
            this.logger.debug("Routing Map Null for collection: {}, PartitionKeyRangeId: {}, forceRefresh:{}", new Object[]{collectionResourceId, partitionKeyRangeId, forceRefresh});
            return null;
        });
    }

    public Single<PartitionKeyRange> tryGetRangeByPartitionKeyRangeId(String collectionRid, String partitionKeyRangeId, Map<String, Object> properties) {
        Single routingMapObs = this.routingMapCache.getAsync((Object)collectionRid, null, () -> this.getRoutingMapForCollectionAsync(collectionRid, null, properties));
        return routingMapObs.map(routingMap -> routingMap.getRangeByPartitionKeyRangeId(partitionKeyRangeId)).onErrorResumeNext(err -> {
            DocumentClientException dce = (DocumentClientException)Utils.as((Object)err, DocumentClientException.class);
            this.logger.debug("tryGetRangeByPartitionKeyRangeId on collectionRid {} and partitionKeyRangeId {} encountered failure", new Object[]{collectionRid, partitionKeyRangeId, err});
            if (dce != null && Exceptions.isStatusCode((DocumentClientException)dce, (int)404)) {
                return Single.just(null);
            }
            return Single.error((Throwable)dce);
        });
    }

    private Single<CollectionRoutingMap> getRoutingMapForCollectionAsync(String collectionRid, CollectionRoutingMap previousRoutingMap, Map<String, Object> properties) {
        Single<List<PartitionKeyRange>> rangesObs = this.getPartitionKeyRange(collectionRid, false, properties);
        return rangesObs.flatMap(ranges -> {
            CollectionRoutingMap routingMap;
            List rangesTuples = ranges.stream().map(range -> new ImmutablePair(range, (Object)null)).collect(Collectors.toList());
            if (previousRoutingMap == null) {
                HashSet goneRanges = new HashSet(ranges.stream().flatMap(range -> CollectionUtils.emptyIfNull((Collection)range.getParents()).stream()).collect(Collectors.toSet()));
                routingMap = InMemoryCollectionRoutingMap.tryCreateCompleteRoutingMap((Iterable)rangesTuples.stream().filter(tuple -> !goneRanges.contains(((PartitionKeyRange)tuple.left).getId())).collect(Collectors.toList()), (String)collectionRid);
            } else {
                routingMap = previousRoutingMap.tryCombine(rangesTuples);
            }
            if (routingMap == null) {
                return Single.error((Throwable)new NotFoundException(String.format("GetRoutingMapForCollectionAsync(collectionRid: {%s}), Range information either doesn't exist or is not complete.", collectionRid)));
            }
            return Single.just((Object)routingMap);
        });
    }

    private Single<List<PartitionKeyRange>> getPartitionKeyRange(String collectionRid, boolean forceRefresh, Map<String, Object> properties) {
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create((OperationType)OperationType.ReadFeed, (String)collectionRid, (ResourceType)ResourceType.PartitionKeyRange, null);
        request.requestContext.resolvedCollectionRid = collectionRid;
        Single collectionObs = this.collectionCache.resolveCollectionAsync(request);
        return collectionObs.flatMap(coll -> {
            FeedOptions feedOptions = new FeedOptions();
            if (properties != null) {
                feedOptions.setProperties(properties);
            }
            Observable rs = this.client.readPartitionKeyRanges(coll.getSelfLink(), feedOptions).flatMap(p -> Observable.from((Iterable)p.getResults()), 1).toList();
            return rs.toSingle();
        });
    }
}

