/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.gridmix.FilePool;
import org.apache.hadoop.mapred.gridmix.GridmixJob;
import org.apache.hadoop.mapred.gridmix.GridmixKey;
import org.apache.hadoop.mapred.gridmix.RandomAlgorithms;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.tools.rumen.JobStory;
import org.apache.hadoop.tools.rumen.ReduceTaskAttemptInfo;
import org.apache.hadoop.tools.rumen.TaskAttemptInfo;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SleepJob
extends GridmixJob {
    public static final Logger LOG = LoggerFactory.getLogger(SleepJob.class);
    private static final ThreadLocal<Random> rand = new ThreadLocal<Random>(){

        @Override
        protected Random initialValue() {
            return new Random();
        }
    };
    public static final String SLEEPJOB_MAPTASK_ONLY = "gridmix.sleep.maptask-only";
    private final boolean mapTasksOnly;
    private final int fakeLocations;
    private final String[] hosts;
    private final RandomAlgorithms.Selector selector;
    public static final String GRIDMIX_SLEEP_INTERVAL = "gridmix.sleep.interval";
    public static final String GRIDMIX_SLEEP_MAX_MAP_TIME = "gridmix.sleep.max-map-time";
    public static final String GRIDMIX_SLEEP_MAX_REDUCE_TIME = "gridmix.sleep.max-reduce-time";
    private final long mapMaxSleepTime;
    private final long reduceMaxSleepTime;

    public SleepJob(Configuration conf, long submissionMillis, JobStory jobdesc, Path outRoot, UserGroupInformation ugi, int seq, int numLocations, String[] hosts) throws IOException {
        super(conf, submissionMillis, jobdesc, outRoot, ugi, seq);
        this.fakeLocations = numLocations;
        this.hosts = (String[])hosts.clone();
        this.selector = this.fakeLocations > 0 ? new RandomAlgorithms.Selector(hosts.length, (float)this.fakeLocations / (float)hosts.length, rand.get()) : null;
        this.mapTasksOnly = conf.getBoolean(SLEEPJOB_MAPTASK_ONLY, false);
        this.mapMaxSleepTime = conf.getLong(GRIDMIX_SLEEP_MAX_MAP_TIME, Long.MAX_VALUE);
        this.reduceMaxSleepTime = conf.getLong(GRIDMIX_SLEEP_MAX_REDUCE_TIME, Long.MAX_VALUE);
    }

    @Override
    protected boolean canEmulateCompression() {
        return false;
    }

    @Override
    public Job call() throws IOException, InterruptedException, ClassNotFoundException {
        this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Job>(){

            @Override
            public Job run() throws IOException, ClassNotFoundException, InterruptedException {
                SleepJob.this.job.setMapperClass(SleepMapper.class);
                SleepJob.this.job.setReducerClass(SleepReducer.class);
                SleepJob.this.job.setNumReduceTasks(SleepJob.this.mapTasksOnly ? 0 : SleepJob.this.jobdesc.getNumberReduces());
                SleepJob.this.job.setMapOutputKeyClass(GridmixKey.class);
                SleepJob.this.job.setMapOutputValueClass(NullWritable.class);
                SleepJob.this.job.setSortComparatorClass(GridmixKey.Comparator.class);
                SleepJob.this.job.setGroupingComparatorClass(GridmixJob.SpecGroupingComparator.class);
                SleepJob.this.job.setInputFormatClass(SleepInputFormat.class);
                SleepJob.this.job.setOutputFormatClass(NullOutputFormat.class);
                SleepJob.this.job.setPartitionerClass(GridmixJob.DraftPartitioner.class);
                SleepJob.this.job.setJarByClass(SleepJob.class);
                SleepJob.this.job.getConfiguration().setBoolean("mapreduce.client.genericoptionsparser.used", true);
                SleepJob.this.job.submit();
                return SleepJob.this.job;
            }
        });
        return this.job;
    }

    private TaskAttemptInfo getSuccessfulAttemptInfo(TaskType type, int task) {
        TaskAttemptInfo ret;
        int i = 0;
        while ((ret = this.jobdesc.getTaskAttemptInfo(type, task, i)).getRunState() != TaskStatus.State.SUCCEEDED) {
            ++i;
        }
        if (ret.getRunState() != TaskStatus.State.SUCCEEDED) {
            LOG.warn("No sucessful attempts tasktype " + type + " task " + task);
        }
        return ret;
    }

    @Override
    void buildSplits(FilePool inputDir) throws IOException {
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        int reds = this.mapTasksOnly ? 0 : this.jobdesc.getNumberReduces();
        int maps = this.jobdesc.getNumberMaps();
        for (int i = 0; i < maps; ++i) {
            int index;
            int nSpec = reds / maps + (reds % maps > i ? 1 : 0);
            long[] redDurations = new long[nSpec];
            for (int j = 0; j < nSpec; ++j) {
                ReduceTaskAttemptInfo info = (ReduceTaskAttemptInfo)this.getSuccessfulAttemptInfo(TaskType.REDUCE, i + j * maps);
                redDurations[j] = Math.min(this.reduceMaxSleepTime, info.getMergeRuntime() + info.getReduceRuntime());
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug(String.format("SPEC(%d) %d -> %d %d/%d", this.id(), i, i + j * maps, redDurations[j], info.getRuntime()));
            }
            TaskAttemptInfo info = this.getSuccessfulAttemptInfo(TaskType.MAP, i);
            ArrayList<String> locations = new ArrayList<String>(this.fakeLocations);
            if (this.fakeLocations > 0) {
                this.selector.reset();
            }
            for (int k = 0; k < this.fakeLocations && (index = this.selector.next()) >= 0; ++k) {
                locations.add(this.hosts[index]);
            }
            splits.add(new SleepSplit(i, Math.min(info.getRuntime(), this.mapMaxSleepTime), redDurations, maps, locations.toArray(new String[locations.size()])));
        }
        SleepJob.pushDescription(this.id(), splits);
    }

    public static class SleepSplit
    extends InputSplit
    implements Writable {
        private int id;
        private int nSpec;
        private int nMaps;
        private long sleepDuration;
        private long[] reduceDurations = new long[0];
        private String[] locations = new String[0];

        public SleepSplit() {
        }

        public SleepSplit(int id, long sleepDuration, long[] reduceDurations, int nMaps, String[] locations) {
            this.id = id;
            this.sleepDuration = sleepDuration;
            this.nSpec = reduceDurations.length;
            this.reduceDurations = (long[])reduceDurations.clone();
            this.nMaps = nMaps;
            this.locations = (String[])locations.clone();
        }

        public void write(DataOutput out) throws IOException {
            int i;
            WritableUtils.writeVInt((DataOutput)out, (int)this.id);
            WritableUtils.writeVLong((DataOutput)out, (long)this.sleepDuration);
            WritableUtils.writeVInt((DataOutput)out, (int)this.nMaps);
            WritableUtils.writeVInt((DataOutput)out, (int)this.nSpec);
            for (i = 0; i < this.nSpec; ++i) {
                WritableUtils.writeVLong((DataOutput)out, (long)this.reduceDurations[i]);
            }
            WritableUtils.writeVInt((DataOutput)out, (int)this.locations.length);
            for (i = 0; i < this.locations.length; ++i) {
                Text.writeString((DataOutput)out, (String)this.locations[i]);
            }
        }

        public void readFields(DataInput in) throws IOException {
            this.id = WritableUtils.readVInt((DataInput)in);
            this.sleepDuration = WritableUtils.readVLong((DataInput)in);
            this.nMaps = WritableUtils.readVInt((DataInput)in);
            this.nSpec = WritableUtils.readVInt((DataInput)in);
            if (this.reduceDurations.length < this.nSpec) {
                this.reduceDurations = new long[this.nSpec];
            }
            for (int i = 0; i < this.nSpec; ++i) {
                this.reduceDurations[i] = WritableUtils.readVLong((DataInput)in);
            }
            int nLoc = WritableUtils.readVInt((DataInput)in);
            if (nLoc != this.locations.length) {
                this.locations = new String[nLoc];
            }
            for (int i = 0; i < nLoc; ++i) {
                this.locations[i] = Text.readString((DataInput)in);
            }
        }

        public long getLength() {
            return this.sleepDuration;
        }

        public int getId() {
            return this.id;
        }

        public int getNumMaps() {
            return this.nMaps;
        }

        public long getReduceDurations(int i) {
            return this.reduceDurations[i];
        }

        public String[] getLocations() {
            return (String[])this.locations.clone();
        }
    }

    public static class SleepInputFormat
    extends InputFormat<LongWritable, LongWritable> {
        public List<InputSplit> getSplits(JobContext jobCtxt) throws IOException {
            return GridmixJob.pullDescription(jobCtxt);
        }

        public RecordReader<LongWritable, LongWritable> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            final long duration = split.getLength();
            long sleepInterval = context.getConfiguration().getLong(SleepJob.GRIDMIX_SLEEP_INTERVAL, 5L);
            final long RINTERVAL = TimeUnit.MILLISECONDS.convert(sleepInterval, TimeUnit.SECONDS);
            if (RINTERVAL <= 0L) {
                throw new IOException("Invalid gridmix.sleep.interval: " + RINTERVAL);
            }
            return new RecordReader<LongWritable, LongWritable>(){
                long start = -1L;
                long slept = 0L;
                long sleep = 0L;
                final LongWritable key = new LongWritable();
                final LongWritable val = new LongWritable();

                public boolean nextKeyValue() throws IOException {
                    if (this.start == -1L) {
                        this.start = System.currentTimeMillis();
                    }
                    this.slept += this.sleep;
                    this.sleep = Math.min(duration - this.slept, RINTERVAL);
                    this.key.set(this.slept + this.sleep + this.start);
                    this.val.set(duration - this.slept);
                    return this.slept < duration;
                }

                public float getProgress() throws IOException {
                    return (float)this.slept / (float)duration;
                }

                public LongWritable getCurrentKey() {
                    return this.key;
                }

                public LongWritable getCurrentValue() {
                    return this.val;
                }

                public void close() throws IOException {
                    String msg = "Slept for " + duration;
                    LOG.info(msg);
                }

                public void initialize(InputSplit split, TaskAttemptContext ctxt) {
                }
            };
        }
    }

    public static class SleepReducer
    extends Reducer<GridmixKey, NullWritable, NullWritable, NullWritable> {
        private long duration = 0L;

        protected void setup(Reducer.Context context) throws IOException, InterruptedException {
            if (!context.nextKey() || ((GridmixKey)context.getCurrentKey()).getType() != 0) {
                throw new IOException("Missing reduce spec");
            }
            for (NullWritable ignored : context.getValues()) {
                GridmixKey spec = (GridmixKey)context.getCurrentKey();
                this.duration += spec.getReduceOutputBytes();
            }
            long sleepInterval = context.getConfiguration().getLong(SleepJob.GRIDMIX_SLEEP_INTERVAL, 5L);
            long RINTERVAL = TimeUnit.MILLISECONDS.convert(sleepInterval, TimeUnit.SECONDS);
            long start = Time.monotonicNow();
            long slept = 0L;
            long sleep = 0L;
            while (slept < this.duration) {
                long rem = this.duration - slept;
                sleep = Math.min(rem, RINTERVAL);
                context.setStatus("Sleeping... " + rem + " ms left");
                TimeUnit.MILLISECONDS.sleep(sleep);
                slept = Time.monotonicNow() - start;
            }
        }

        protected void cleanup(Reducer.Context context) throws IOException, InterruptedException {
            String msg = "Slept for " + this.duration;
            LOG.info(msg);
            context.setStatus(msg);
        }
    }

    public static class SleepMapper
    extends Mapper<LongWritable, LongWritable, GridmixKey, NullWritable> {
        public void map(LongWritable key, LongWritable value, Mapper.Context context) throws IOException, InterruptedException {
            context.setStatus("Sleeping... " + value.get() + " ms left");
            long now = System.currentTimeMillis();
            if (now < key.get()) {
                TimeUnit.MILLISECONDS.sleep(key.get() - now);
            }
        }

        public void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            int nReds = context.getNumReduceTasks();
            if (nReds > 0) {
                SleepSplit split = (SleepSplit)context.getInputSplit();
                int id = split.getId();
                int nMaps = split.getNumMaps();
                GridmixKey key = new GridmixKey(0, 0, 0L);
                int idx = 0;
                for (int i = id; i < nReds; i += nMaps) {
                    key.setPartition(i);
                    key.setReduceOutputBytes(split.getReduceDurations(idx++));
                    id += nReds;
                    context.write((Object)key, (Object)NullWritable.get());
                }
            }
        }
    }
}

