/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.netio;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.ojalgo.netio.Batch;
import org.ojalgo.netio.Message;

public class ProcessInputStream
extends DataInputStream {
    private static String EMPTY = "";
    private String myLastArgument = EMPTY;
    private String myLastCommand = EMPTY;
    private final String myLastCommandPrefix;
    private long myWaitTime = 1L;

    public ProcessInputStream(Process aProcess, String aLastCommandPrefix) {
        super(aProcess.getInputStream());
        this.myLastCommandPrefix = aLastCommandPrefix;
    }

    private ProcessInputStream(InputStream someIn) {
        super(someIn);
        this.myLastCommandPrefix = null;
    }

    public List<Message> collectMessages() {
        Batch retVal = new Batch();
        this.myWaitTime = 1L;
        boolean tmpReadOneMore = true;
        while (tmpReadOneMore) {
            Message tmpMessage = this.constructMessage();
            if (tmpMessage == null) continue;
            retVal.add(tmpMessage);
            tmpReadOneMore &= !tmpMessage.getCommand().startsWith(this.myLastCommandPrefix);
        }
        return retVal;
    }

    public String getLastArgument() {
        return this.myLastArgument;
    }

    public String getLastCommand() {
        return this.myLastCommand;
    }

    private Message constructMessage() {
        Message retVal = null;
        String tmpString = this.readString();
        if (tmpString != null && !tmpString.equals(EMPTY)) {
            int tmpFirst = 0;
            int tmpLast = tmpString.indexOf(10);
            String tmpCommand = tmpString.substring(tmpFirst, tmpLast);
            tmpFirst = tmpLast + 1;
            tmpLast = tmpString.length();
            String tmpArgument = tmpString.substring(tmpFirst, tmpLast);
            this.myLastCommand = tmpCommand;
            this.myLastArgument = tmpArgument;
            retVal = new Message(tmpCommand, tmpArgument);
        } else {
            try {
                this.wait(this.myWaitTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.myWaitTime *= 2L;
        }
        return retVal;
    }

    private String readString() {
        StringBuilder retVal = new StringBuilder();
        try {
            int tmpInt;
            int tmpByteCount = 0;
            while ((tmpInt = this.readByteAsInt()) != 32 && tmpInt >= 48 && tmpInt <= 57) {
                tmpByteCount *= 10;
                tmpByteCount += tmpInt - 48;
            }
            for (int i = 0; i < tmpByteCount; ++i) {
                char tmpChar = this.readByteAsChar();
                if (tmpChar == '\r') continue;
                retVal.append(tmpChar);
            }
        }
        catch (IOException anException) {
            retVal.append(' ');
            retVal.append(anException);
        }
        return retVal.toString();
    }

    protected char readByteAsChar() throws IOException {
        int retVal = this.read();
        if (retVal < 0) {
            throw new EOFException();
        }
        return (char)retVal;
    }

    protected int readByteAsInt() throws IOException {
        int retVal = this.read();
        if (retVal < 0) {
            throw new EOFException();
        }
        return retVal;
    }
}

