/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store.operation;

import java.math.BigDecimal;
import org.ojalgo.function.BigFunction;
import org.ojalgo.matrix.store.operation.MatrixOperation;
import org.ojalgo.scalar.ComplexNumber;

public final class RotateLeft
extends MatrixOperation {
    public static final RotateLeft SETUP = new RotateLeft();
    public static int THRESHOLD = 128;

    public static void invoke(BigDecimal[] aData, int aColDim, int aRowA, int aRowB, BigDecimal aCos, BigDecimal aSin) {
        int tmpIndexA = aRowA;
        int tmpIndexB = aRowB;
        int tmpIndexStep = aData.length / aColDim;
        for (int j = 0; j < aColDim; ++j) {
            BigDecimal tmpOldA = aData[tmpIndexA];
            BigDecimal tmpOldB = aData[tmpIndexB];
            aData[tmpIndexA] = BigFunction.ADD.invoke(BigFunction.MULTIPLY.invoke(aCos, tmpOldA), BigFunction.MULTIPLY.invoke(aSin, tmpOldB));
            aData[tmpIndexB] = BigFunction.SUBTRACT.invoke(BigFunction.MULTIPLY.invoke(aCos, tmpOldB), BigFunction.MULTIPLY.invoke(aSin, tmpOldA));
            tmpIndexA += tmpIndexStep;
            tmpIndexB += tmpIndexStep;
        }
    }

    public static void invoke(ComplexNumber[] aData, int aColDim, int aRowA, int aRowB, ComplexNumber aCos, ComplexNumber aSin) {
        int tmpIndexA = aRowA;
        int tmpIndexB = aRowB;
        int tmpIndexStep = aData.length / aColDim;
        for (int j = 0; j < aColDim; ++j) {
            ComplexNumber tmpOldA = aData[tmpIndexA];
            ComplexNumber tmpOldB = aData[tmpIndexB];
            aData[tmpIndexA] = aCos.multiply(tmpOldA).add(aSin.multiply(tmpOldB));
            aData[tmpIndexB] = aCos.multiply(tmpOldB).subtract(aSin.multiply(tmpOldA));
            tmpIndexA += tmpIndexStep;
            tmpIndexB += tmpIndexStep;
        }
    }

    public static void invoke(double[] aData, int aColDim, int aRowA, int aRowB, double aCos, double aSin) {
        int tmpIndexA = aRowA;
        int tmpIndexB = aRowB;
        int tmpIndexStep = aData.length / aColDim;
        for (int j = 0; j < aColDim; ++j) {
            double tmpOldA = aData[tmpIndexA];
            double tmpOldB = aData[tmpIndexB];
            aData[tmpIndexA] = aCos * tmpOldA + aSin * tmpOldB;
            aData[tmpIndexB] = aCos * tmpOldB - aSin * tmpOldA;
            tmpIndexA += tmpIndexStep;
            tmpIndexB += tmpIndexStep;
        }
    }

    private RotateLeft() {
    }

    @Override
    public int threshold() {
        return THRESHOLD;
    }
}

