/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.concurrent;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.ojalgo.OjAlgoUtils;
import org.ojalgo.ProgrammingError;
import org.ojalgo.concurrent.DaemonPoolExecutor;

public abstract class DivideAndConquer {
    public final void invoke(int first, int limit, int threshold) {
        int tmpThreshold = Math.max(1, threshold * threshold / (limit - first));
        int tmpWorkers = OjAlgoUtils.ENVIRONMENT.threads;
        this.divide(first, limit, tmpThreshold, tmpWorkers);
    }

    protected abstract void conquer(int var1, int var2);

    final void divide(int first, int limit, int threshold, int workers) {
        int tmpCount = limit - first;
        if (tmpCount > threshold && workers > 1) {
            int tmpSplit = first + tmpCount / 2;
            int tmpWorkers = workers / 2;
            Future<Void> tmpFirstPart = DaemonPoolExecutor.INSTANCE.submit(() -> {
                this.divide(first, tmpSplit, threshold, tmpWorkers);
                return null;
            });
            Future<Void> tmpSecondPart = DaemonPoolExecutor.INSTANCE.submit(() -> {
                this.divide(tmpSplit, limit, threshold, tmpWorkers);
                return null;
            });
            try {
                tmpFirstPart.get();
                tmpSecondPart.get();
            }
            catch (InterruptedException | ExecutionException exception) {
                exception.printStackTrace();
                throw new ProgrammingError(exception);
            }
        } else {
            this.conquer(first, limit);
        }
    }
}

