/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal.query;

import com.microsoft.azure.cosmosdb.DocumentCollection;
import com.microsoft.azure.cosmosdb.FeedOptions;
import com.microsoft.azure.cosmosdb.PartitionKeyRange;
import com.microsoft.azure.cosmosdb.Resource;
import com.microsoft.azure.cosmosdb.SqlQuerySpec;
import com.microsoft.azure.cosmosdb.internal.OperationType;
import com.microsoft.azure.cosmosdb.internal.ResourceType;
import com.microsoft.azure.cosmosdb.internal.query.PartitionedQueryExecutionInfo;
import com.microsoft.azure.cosmosdb.internal.query.QueryInfo;
import com.microsoft.azure.cosmosdb.rx.internal.BadRequestException;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import com.microsoft.azure.cosmosdb.rx.internal.Utils;
import com.microsoft.azure.cosmosdb.rx.internal.caches.RxCollectionCache;
import com.microsoft.azure.cosmosdb.rx.internal.query.IDocumentQueryClient;
import com.microsoft.azure.cosmosdb.rx.internal.query.IDocumentQueryExecutionContext;
import com.microsoft.azure.cosmosdb.rx.internal.query.PipelinedDocumentQueryExecutionContext;
import com.microsoft.azure.cosmosdb.rx.internal.query.ProxyDocumentQueryExecutionContext;
import java.util.List;
import java.util.UUID;
import rx.Observable;
import rx.Single;

public class DocumentQueryExecutionContextFactory {
    private static final int PageSizeFactorForTop = 5;

    private static Single<DocumentCollection> resolveCollection(IDocumentQueryClient client, SqlQuerySpec query, ResourceType resourceTypeEnum, String resourceLink) {
        RxCollectionCache collectionCache = client.getCollectionCache();
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create((OperationType)OperationType.Query, (ResourceType)resourceTypeEnum, (String)resourceLink, null);
        return collectionCache.resolveCollectionAsync(request);
    }

    public static <T extends Resource> Observable<? extends IDocumentQueryExecutionContext<T>> createDocumentQueryExecutionContextAsync(IDocumentQueryClient client, ResourceType resourceTypeEnum, Class<T> resourceType, SqlQuerySpec query, FeedOptions feedOptions, String resourceLink, boolean isContinuationExpected, UUID correlatedActivityId) {
        Observable collectionObs = Observable.just(null);
        if (resourceTypeEnum.isCollectionChild()) {
            collectionObs = DocumentQueryExecutionContextFactory.resolveCollection(client, query, resourceTypeEnum, resourceLink).toObservable();
        }
        Observable proxyQueryExecutionContext = collectionObs.flatMap(collection -> ProxyDocumentQueryExecutionContext.createAsync(client, resourceTypeEnum, resourceType, query, feedOptions, resourceLink, collection, isContinuationExpected, correlatedActivityId));
        return proxyQueryExecutionContext;
    }

    public static <T extends Resource> Observable<? extends IDocumentQueryExecutionContext<T>> createSpecializedDocumentQueryExecutionContextAsync(IDocumentQueryClient client, ResourceType resourceTypeEnum, Class<T> resourceType, SqlQuerySpec query, FeedOptions feedOptions, String resourceLink, boolean isContinuationExpected, PartitionedQueryExecutionInfo partitionedQueryExecutionInfo, List<PartitionKeyRange> targetRanges, String collectionRid, UUID correlatedActivityId) {
        int top;
        int initialPageSize = Utils.getValueOrDefault((Integer)feedOptions.getMaxItemCount(), (int)100);
        BadRequestException validationError = Utils.checkRequestOrReturnException((initialPageSize > 0 ? 1 : 0) != 0, (String)"MaxItemCount", (String)"Invalid MaxItemCount %s", (Object[])new Object[]{initialPageSize});
        if (validationError != null) {
            return Observable.error((Throwable)validationError);
        }
        QueryInfo queryInfo = partitionedQueryExecutionInfo.getQueryInfo();
        boolean getLazyFeedResponse = queryInfo.hasTop();
        if (queryInfo.hasOrderBy() && queryInfo.hasTop() && (top = partitionedQueryExecutionInfo.getQueryInfo().getTop().intValue()) > 0) {
            int pageSizeWithTop = Math.min((int)Math.ceil((double)top / (double)targetRanges.size()) * 5, top);
            initialPageSize = initialPageSize > 0 ? Math.min(pageSizeWithTop, initialPageSize) : pageSizeWithTop;
        }
        return PipelinedDocumentQueryExecutionContext.createAsync(client, resourceTypeEnum, resourceType, query, feedOptions, resourceLink, collectionRid, partitionedQueryExecutionInfo, targetRanges, initialPageSize, isContinuationExpected, getLazyFeedResponse, correlatedActivityId);
    }
}

