/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal.query;

import com.microsoft.azure.cosmosdb.BridgeInternal;
import com.microsoft.azure.cosmosdb.ConsistencyLevel;
import com.microsoft.azure.cosmosdb.FeedOptions;
import com.microsoft.azure.cosmosdb.FeedResponse;
import com.microsoft.azure.cosmosdb.PartitionKeyRange;
import com.microsoft.azure.cosmosdb.Resource;
import com.microsoft.azure.cosmosdb.SqlParameterCollection;
import com.microsoft.azure.cosmosdb.SqlQuerySpec;
import com.microsoft.azure.cosmosdb.internal.OperationType;
import com.microsoft.azure.cosmosdb.internal.ResourceType;
import com.microsoft.azure.cosmosdb.internal.routing.PartitionKeyInternal;
import com.microsoft.azure.cosmosdb.internal.routing.PartitionKeyRangeIdentity;
import com.microsoft.azure.cosmosdb.rx.internal.ReplicatedResourceClientUtils;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceResponse;
import com.microsoft.azure.cosmosdb.rx.internal.Strings;
import com.microsoft.azure.cosmosdb.rx.internal.Utils;
import com.microsoft.azure.cosmosdb.rx.internal.query.IDocumentQueryClient;
import com.microsoft.azure.cosmosdb.rx.internal.query.IDocumentQueryExecutionContext;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import rx.Observable;
import rx.Single;

public abstract class DocumentQueryExecutionContextBase<T extends Resource>
implements IDocumentQueryExecutionContext<T> {
    protected ResourceType resourceTypeEnum;
    protected String resourceLink;
    protected IDocumentQueryClient client;
    protected Class<T> resourceType;
    protected FeedOptions feedOptions;
    protected SqlQuerySpec query;
    protected UUID correlatedActivityId;
    protected boolean shouldExecuteQueryRequest;

    protected DocumentQueryExecutionContextBase(IDocumentQueryClient client, ResourceType resourceTypeEnum, Class<T> resourceType, SqlQuerySpec query, FeedOptions feedOptions, String resourceLink, boolean getLazyFeedResponse, UUID correlatedActivityId) {
        this.client = client;
        this.resourceTypeEnum = resourceTypeEnum;
        this.resourceType = resourceType;
        this.query = query;
        this.shouldExecuteQueryRequest = query != null;
        this.feedOptions = feedOptions;
        this.resourceLink = resourceLink;
        this.correlatedActivityId = correlatedActivityId;
    }

    @Override
    public abstract Observable<FeedResponse<T>> executeAsync();

    public String getPartitionKeyId() {
        return this.feedOptions.getPartitionKeyRangeIdInternal();
    }

    public RxDocumentServiceRequest createDocumentServiceRequest(Map<String, String> requestHeaders, SqlQuerySpec querySpec, PartitionKeyInternal partitionKey) {
        RxDocumentServiceRequest request = querySpec != null ? this.createQueryDocumentServiceRequest(requestHeaders, querySpec) : this.createReadFeedDocumentServiceRequest(requestHeaders);
        this.populatePartitionKeyInfo(request, partitionKey);
        return request;
    }

    protected RxDocumentServiceRequest createDocumentServiceRequest(Map<String, String> requestHeaders, SqlQuerySpec querySpec, PartitionKeyRange targetRange, String collectionRid) {
        RxDocumentServiceRequest request = querySpec != null ? this.createQueryDocumentServiceRequest(requestHeaders, querySpec) : this.createReadFeedDocumentServiceRequest(requestHeaders);
        this.populatePartitionKeyRangeInfo(request, targetRange, collectionRid);
        return request;
    }

    public Single<FeedResponse<T>> executeRequestAsync(RxDocumentServiceRequest request) {
        return this.shouldExecuteQueryRequest ? this.executeQueryRequestAsync(request) : this.executeReadFeedRequestAsync(request);
    }

    public Single<FeedResponse<T>> executeQueryRequestAsync(RxDocumentServiceRequest request) {
        return this.getFeedResponse(this.executeQueryRequestInternalAsync(request));
    }

    public Single<FeedResponse<T>> executeReadFeedRequestAsync(RxDocumentServiceRequest request) {
        return this.getFeedResponse(this.client.readFeedAsync(request));
    }

    protected Single<FeedResponse<T>> getFeedResponse(Single<RxDocumentServiceResponse> response) {
        return response.map(resp -> BridgeInternal.toFeedResponsePage((RxDocumentServiceResponse)resp, this.resourceType));
    }

    public FeedOptions getFeedOptions(String continuationToken, Integer maxPageSize) {
        FeedOptions options = new FeedOptions(this.feedOptions);
        options.setRequestContinuation(continuationToken);
        options.setMaxItemCount(maxPageSize);
        return options;
    }

    private Single<RxDocumentServiceResponse> executeQueryRequestInternalAsync(RxDocumentServiceRequest request) {
        return this.client.executeQueryAsync(request);
    }

    public Map<String, String> createCommonHeadersAsync(FeedOptions feedOptions) {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        ConsistencyLevel defaultConsistencyLevel = this.client.getDefaultConsistencyLevelAsync();
        ConsistencyLevel desiredConsistencyLevel = this.client.getDesiredConsistencyLevelAsync();
        if (!(Strings.isNullOrEmpty((String)feedOptions.getSessionToken()) || ReplicatedResourceClientUtils.isReadingFromMaster(this.resourceTypeEnum, OperationType.ReadFeed) || defaultConsistencyLevel != ConsistencyLevel.Session && desiredConsistencyLevel != ConsistencyLevel.Session)) {
            requestHeaders.put("x-ms-session-token", feedOptions.getSessionToken());
        }
        requestHeaders.put("x-ms-continuation", feedOptions.getRequestContinuation());
        requestHeaders.put("x-ms-documentdb-isquery", Strings.toString((boolean)true));
        if (feedOptions.getMaxItemCount() != null && feedOptions.getMaxItemCount() > 0) {
            requestHeaders.put("x-ms-max-item-count", Strings.toString((int)feedOptions.getMaxItemCount()));
        }
        if (feedOptions.getEnableCrossPartitionQuery() != null) {
            requestHeaders.put("x-ms-documentdb-query-enablecrosspartition", Strings.toString((boolean)feedOptions.getEnableCrossPartitionQuery()));
        }
        if (feedOptions.getMaxDegreeOfParallelism() != 0) {
            requestHeaders.put("x-ms-documentdb-query-parallelizecrosspartitionquery", Strings.toString((boolean)true));
        }
        if (this.feedOptions.getEnableCrossPartitionQuery() != null) {
            requestHeaders.put("x-ms-documentdb-query-enable-scan", Strings.toString((boolean)this.feedOptions.getEnableCrossPartitionQuery()));
        }
        if (this.feedOptions.getResponseContinuationTokenLimitInKb() > 0) {
            requestHeaders.put("x-ms-documentdb-responsecontinuationtokenlimitinkb", Strings.toString((int)feedOptions.getResponseContinuationTokenLimitInKb()));
        }
        if (desiredConsistencyLevel != null) {
            requestHeaders.put("x-ms-consistency-level", desiredConsistencyLevel.name());
        }
        if (feedOptions.getPopulateQueryMetrics()) {
            requestHeaders.put("x-ms-documentdb-populatequerymetrics", String.valueOf(feedOptions.getPopulateQueryMetrics()));
        }
        return requestHeaders;
    }

    private void populatePartitionKeyInfo(RxDocumentServiceRequest request, PartitionKeyInternal partitionKey) {
        if (request == null) {
            throw new NullPointerException("request");
        }
        if (this.resourceTypeEnum.isPartitioned() && partitionKey != null) {
            request.getHeaders().put("x-ms-documentdb-partitionkey", partitionKey.toJson());
        }
    }

    public void populatePartitionKeyRangeInfo(RxDocumentServiceRequest request, PartitionKeyRange range, String collectionRid) {
        if (request == null) {
            throw new NullPointerException("request");
        }
        if (range == null) {
            throw new NullPointerException("range");
        }
        if (this.resourceTypeEnum.isPartitioned()) {
            request.routeTo(new PartitionKeyRangeIdentity(collectionRid, range.getId()));
        }
    }

    private RxDocumentServiceRequest createQueryDocumentServiceRequest(Map<String, String> requestHeaders, SqlQuerySpec querySpec) {
        String queryText;
        RxDocumentServiceRequest executeQueryRequest;
        switch (this.client.getQueryCompatibilityMode()) {
            case SqlQuery: {
                SqlParameterCollection params = querySpec.getParameters();
                Utils.checkStateOrThrow((params != null && params.size() > 0 ? 1 : 0) != 0, (String)"query.parameters", (String)"Unsupported argument in query compatibility mode '%s'", (Object[])new Object[]{this.client.getQueryCompatibilityMode().toString()});
                executeQueryRequest = RxDocumentServiceRequest.create((OperationType)OperationType.SqlQuery, (ResourceType)this.resourceTypeEnum, (String)this.resourceLink, requestHeaders);
                executeQueryRequest.getHeaders().put("Content-Type", "application/json");
                queryText = querySpec.getQueryText();
                break;
            }
            default: {
                executeQueryRequest = RxDocumentServiceRequest.create((OperationType)OperationType.Query, (ResourceType)this.resourceTypeEnum, (String)this.resourceLink, requestHeaders);
                executeQueryRequest.getHeaders().put("Content-Type", "application/query+json");
                queryText = querySpec.toJson();
            }
        }
        try {
            executeQueryRequest.setContentBytes(queryText.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return executeQueryRequest;
    }

    private RxDocumentServiceRequest createReadFeedDocumentServiceRequest(Map<String, String> requestHeaders) {
        if (this.resourceTypeEnum == ResourceType.Database || this.resourceTypeEnum == ResourceType.Offer) {
            return RxDocumentServiceRequest.create((OperationType)OperationType.ReadFeed, null, (ResourceType)this.resourceTypeEnum, requestHeaders);
        }
        return RxDocumentServiceRequest.create((OperationType)OperationType.ReadFeed, (ResourceType)this.resourceTypeEnum, (String)this.resourceLink, requestHeaders);
    }
}

