/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router.security.token;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.federation.router.security.token.DistributedSQLCounter;
import org.apache.hadoop.hdfs.server.federation.router.security.token.HikariDataSourceConnectionFactory;
import org.apache.hadoop.hdfs.server.federation.router.security.token.SQLConnectionFactory;
import org.apache.hadoop.hdfs.server.federation.router.security.token.SQLSecretManagerRetriableHandler;
import org.apache.hadoop.hdfs.server.federation.router.security.token.SQLSecretManagerRetriableHandlerImpl;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.apache.hadoop.security.token.delegation.SQLDelegationTokenSecretManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLDelegationTokenSecretManagerImpl
extends SQLDelegationTokenSecretManager<AbstractDelegationTokenIdentifier> {
    private static final Logger LOG = LoggerFactory.getLogger(SQLDelegationTokenSecretManagerImpl.class);
    private static final String SEQ_NUM_COUNTER_FIELD = "sequenceNum";
    private static final String SEQ_NUM_COUNTER_TABLE = "LastSequenceNum";
    private static final String KEY_ID_COUNTER_FIELD = "keyId";
    private static final String KEY_ID_COUNTER_TABLE = "LastDelegationKeyId";
    private final SQLConnectionFactory connectionFactory;
    private final DistributedSQLCounter sequenceNumCounter;
    private final DistributedSQLCounter delegationKeyIdCounter;
    private final SQLSecretManagerRetriableHandler retryHandler;

    public SQLDelegationTokenSecretManagerImpl(Configuration conf) {
        this(conf, new HikariDataSourceConnectionFactory(conf), SQLSecretManagerRetriableHandlerImpl.getInstance(conf));
    }

    public SQLDelegationTokenSecretManagerImpl(Configuration conf, SQLConnectionFactory connectionFactory, SQLSecretManagerRetriableHandler retryHandler) {
        super(conf);
        this.connectionFactory = connectionFactory;
        this.sequenceNumCounter = new DistributedSQLCounter(SEQ_NUM_COUNTER_FIELD, SEQ_NUM_COUNTER_TABLE, connectionFactory);
        this.delegationKeyIdCounter = new DistributedSQLCounter(KEY_ID_COUNTER_FIELD, KEY_ID_COUNTER_TABLE, connectionFactory);
        this.retryHandler = retryHandler;
        try {
            super.startThreads();
        }
        catch (IOException e) {
            throw new RuntimeException("Error starting threads for MySQL secret manager", e);
        }
        LOG.info("MySQL delegation token secret manager instantiated");
    }

    public DelegationTokenIdentifier createIdentifier() {
        return new DelegationTokenIdentifier();
    }

    public void stopThreads() {
        super.stopThreads();
        this.connectionFactory.shutdown();
    }

    protected void insertToken(int sequenceNum, byte[] tokenIdentifier, byte[] tokenInfo) throws SQLException {
        this.retryHandler.execute(() -> {
            try (Connection connection = this.connectionFactory.getConnection(true);
                 PreparedStatement statement = connection.prepareStatement("INSERT INTO Tokens (sequenceNum, tokenIdentifier, tokenInfo) VALUES (?, ?, ?)");){
                statement.setInt(1, sequenceNum);
                statement.setBytes(2, tokenIdentifier);
                statement.setBytes(3, tokenInfo);
                statement.execute();
            }
        });
    }

    protected void updateToken(int sequenceNum, byte[] tokenIdentifier, byte[] tokenInfo) throws SQLException {
        this.retryHandler.execute(() -> {
            try (Connection connection = this.connectionFactory.getConnection(true);
                 PreparedStatement statement = connection.prepareStatement("UPDATE Tokens SET tokenInfo = ? WHERE sequenceNum = ? AND tokenIdentifier = ?");){
                statement.setBytes(1, tokenInfo);
                statement.setInt(2, sequenceNum);
                statement.setBytes(3, tokenIdentifier);
                statement.execute();
            }
        });
    }

    protected void deleteToken(int sequenceNum, byte[] tokenIdentifier) throws SQLException {
        this.retryHandler.execute(() -> {
            try (Connection connection = this.connectionFactory.getConnection(true);
                 PreparedStatement statement = connection.prepareStatement("DELETE FROM Tokens WHERE sequenceNum = ? AND tokenIdentifier = ?");){
                statement.setInt(1, sequenceNum);
                statement.setBytes(2, tokenIdentifier);
                statement.execute();
            }
        });
    }

    protected byte[] selectTokenInfo(int sequenceNum, byte[] tokenIdentifier) throws SQLException {
        return this.retryHandler.execute(() -> {
            try (Connection connection = this.connectionFactory.getConnection();
                 PreparedStatement statement = connection.prepareStatement("SELECT tokenInfo FROM Tokens WHERE sequenceNum = ? AND tokenIdentifier = ?");){
                statement.setInt(1, sequenceNum);
                statement.setBytes(2, tokenIdentifier);
                try (ResultSet result = statement.executeQuery();){
                    if (result.next()) {
                        byte[] byArray = result.getBytes("tokenInfo");
                        return byArray;
                    }
                }
            }
            return null;
        });
    }

    protected Map<byte[], byte[]> selectStaleTokenInfos(long maxModifiedTime, int maxResults) throws SQLException {
        return this.retryHandler.execute(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    protected void insertDelegationKey(int keyId, byte[] delegationKey) throws SQLException {
        this.retryHandler.execute(() -> {
            try (Connection connection = this.connectionFactory.getConnection(true);
                 PreparedStatement statement = connection.prepareStatement("INSERT INTO DelegationKeys (keyId, delegationKey) VALUES (?, ?)");){
                statement.setInt(1, keyId);
                statement.setBytes(2, delegationKey);
                statement.execute();
            }
        });
    }

    protected void updateDelegationKey(int keyId, byte[] delegationKey) throws SQLException {
        this.retryHandler.execute(() -> {
            try (Connection connection = this.connectionFactory.getConnection(true);
                 PreparedStatement statement = connection.prepareStatement("UPDATE DelegationKeys SET delegationKey = ? WHERE keyId = ?");){
                statement.setBytes(1, delegationKey);
                statement.setInt(2, keyId);
                statement.execute();
            }
        });
    }

    protected void deleteDelegationKey(int keyId) throws SQLException {
        this.retryHandler.execute(() -> {
            try (Connection connection = this.connectionFactory.getConnection(true);
                 PreparedStatement statement = connection.prepareStatement("DELETE FROM DelegationKeys WHERE keyId = ?");){
                statement.setInt(1, keyId);
                statement.execute();
            }
        });
    }

    protected byte[] selectDelegationKey(int keyId) throws SQLException {
        return this.retryHandler.execute(() -> {
            try (Connection connection = this.connectionFactory.getConnection();
                 PreparedStatement statement = connection.prepareStatement("SELECT delegationKey FROM DelegationKeys WHERE keyId = ?");){
                statement.setInt(1, keyId);
                try (ResultSet result = statement.executeQuery();){
                    if (result.next()) {
                        byte[] byArray = result.getBytes("delegationKey");
                        return byArray;
                    }
                }
            }
            return null;
        });
    }

    protected int selectSequenceNum() throws SQLException {
        return this.retryHandler.execute(() -> this.sequenceNumCounter.selectCounterValue());
    }

    protected void updateSequenceNum(int value) throws SQLException {
        this.retryHandler.execute(() -> this.sequenceNumCounter.updateCounterValue(value));
    }

    protected int incrementSequenceNum(int amount) throws SQLException {
        return this.retryHandler.execute(() -> this.sequenceNumCounter.incrementCounterValue(amount));
    }

    protected int selectKeyId() throws SQLException {
        return this.retryHandler.execute(this.delegationKeyIdCounter::selectCounterValue);
    }

    protected void updateKeyId(int value) throws SQLException {
        this.retryHandler.execute(() -> this.delegationKeyIdCounter.updateCounterValue(value));
    }

    protected int incrementKeyId(int amount) throws SQLException {
        return this.retryHandler.execute(() -> this.delegationKeyIdCounter.incrementCounterValue(amount));
    }

    @VisibleForTesting
    protected SQLConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }
}

