/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.dnssec;

import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.xbill.DNS.NSEC3Record;
import org.xbill.DNS.Name;
import org.xbill.DNS.utils.base32;

class Nsec3ValidationState {
    private static final base32 b32 = new base32("0123456789ABCDEFGHIJKLMNOPQRSTUV=", false, false);
    private final Map<String, Nsec3CacheEntry> cache = new HashMap<String, Nsec3CacheEntry>();
    public int numCalc;
    public int numCalcErrors;

    Nsec3ValidationState() {
    }

    public Nsec3CacheEntry computeIfAbsent(NSEC3Record nsec3, Name name) throws NoSuchAlgorithmException {
        String key = this.key(nsec3, name);
        Nsec3CacheEntry entry = this.cache.get(key);
        if (entry == null) {
            byte[] hash = nsec3.hashName(name);
            entry = new Nsec3CacheEntry(hash);
            this.cache.put(key, entry);
            ++this.numCalc;
        }
        return entry;
    }

    private String key(NSEC3Record nsec3, Name name) {
        return name + "/" + nsec3.getHashAlgorithm() + "/" + nsec3.getIterations() + "/" + (nsec3.getSalt() == null ? "-" : new BigInteger(nsec3.getSalt()).toString());
    }

    static class Nsec3CacheEntry {
        private final byte[] hash;
        private String asBase32;

        String getHashAsBase32() {
            if (this.asBase32 == null) {
                this.asBase32 = b32.toString(this.hash);
            }
            return this.asBase32;
        }

        @Generated
        public Nsec3CacheEntry(byte[] hash) {
            this.hash = hash;
        }

        @Generated
        public byte[] getHash() {
            return this.hash;
        }
    }
}

