/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline.recovery;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.security.client.TimelineDelegationTokenIdentifier;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class TimelineStateStore
extends AbstractService {
    public TimelineStateStore() {
        super(TimelineStateStore.class.getName());
    }

    public TimelineStateStore(String name) {
        super(name);
    }

    public void serviceInit(Configuration conf) throws IOException {
        this.initStorage(conf);
    }

    public void serviceStart() throws IOException {
        this.startStorage();
    }

    public void serviceStop() throws IOException {
        this.closeStorage();
    }

    protected abstract void initStorage(Configuration var1) throws IOException;

    protected abstract void startStorage() throws IOException;

    protected abstract void closeStorage() throws IOException;

    public abstract TimelineServiceState loadState() throws IOException;

    public abstract void storeToken(TimelineDelegationTokenIdentifier var1, Long var2) throws IOException;

    public abstract void updateToken(TimelineDelegationTokenIdentifier var1, Long var2) throws IOException;

    public abstract void removeToken(TimelineDelegationTokenIdentifier var1) throws IOException;

    public abstract void storeTokenMasterKey(DelegationKey var1) throws IOException;

    public abstract void removeTokenMasterKey(DelegationKey var1) throws IOException;

    public static class TimelineServiceState {
        int latestSequenceNumber = 0;
        Map<TimelineDelegationTokenIdentifier, Long> tokenState = new HashMap<TimelineDelegationTokenIdentifier, Long>();
        Set<DelegationKey> tokenMasterKeyState = new HashSet<DelegationKey>();

        public int getLatestSequenceNumber() {
            return this.latestSequenceNumber;
        }

        public Map<TimelineDelegationTokenIdentifier, Long> getTokenState() {
            return this.tokenState;
        }

        public Set<DelegationKey> getTokenMasterKeyState() {
            return this.tokenMasterKeyState;
        }
    }
}

