/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.net.DNS;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.service.api.records.Configuration;
import org.apache.hadoop.yarn.service.containerlaunch.ClasspathConstructor;
import org.apache.hadoop.yarn.service.exceptions.BadClusterStateException;
import org.apache.hadoop.yarn.service.exceptions.SliderException;
import org.apache.hadoop.yarn.service.utils.SliderFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceUtils {
    private static final Logger log = LoggerFactory.getLogger(ServiceUtils.class);

    private ServiceUtils() {
    }

    public static boolean isUnset(String s) {
        return s == null || s.isEmpty();
    }

    public static boolean isSet(String s) {
        return !ServiceUtils.isUnset(s);
    }

    public static boolean isEmpty(Collection l) {
        return l == null || l.isEmpty();
    }

    public static File findContainingJarOrFail(Class clazz) throws IOException {
        File localFile = ServiceUtils.findContainingJar(clazz);
        if (null == localFile) {
            throw new FileNotFoundException("Could not find JAR containing " + clazz);
        }
        return localFile;
    }

    public static File findContainingJar(Class my_class) throws IOException {
        ClassLoader loader = my_class.getClassLoader();
        if (loader == null) {
            throw new IOException("Class " + my_class + " does not have a classloader!");
        }
        String class_file = my_class.getName().replaceAll("\\.", "/") + ".class";
        Enumeration<java.net.URL> urlEnumeration = loader.getResources(class_file);
        while (urlEnumeration.hasMoreElements()) {
            java.net.URL url = urlEnumeration.nextElement();
            if ("jar".equals(url.getProtocol())) {
                String toReturn = url.getPath();
                if (toReturn.startsWith("file:")) {
                    toReturn = toReturn.substring("file:".length());
                }
                toReturn = toReturn.replaceAll("\\+", "%2B");
                toReturn = URLDecoder.decode(toReturn, "UTF-8");
                String jarFilePath = toReturn.replaceAll("!.*$", "");
                return new File(jarFilePath);
            }
            log.info("could not locate JAR containing {} URL={}", (Object)my_class, (Object)url);
        }
        return null;
    }

    public static void copy(org.apache.hadoop.conf.Configuration conf, Path srcFile, Path destFile) throws IOException, BadClusterStateException {
        FileSystem srcFS = FileSystem.get((URI)srcFile.toUri(), (org.apache.hadoop.conf.Configuration)conf);
        if (!srcFS.exists(srcFile)) {
            throw new FileNotFoundException("Source file not found " + srcFile);
        }
        if (!srcFS.isFile(srcFile)) {
            throw new FileNotFoundException("Source file not a file " + srcFile);
        }
        FileSystem destFS = FileSystem.get((URI)destFile.toUri(), (org.apache.hadoop.conf.Configuration)conf);
        FileUtil.copy((FileSystem)srcFS, (Path)srcFile, (FileSystem)destFS, (Path)destFile, (boolean)false, (boolean)true, (org.apache.hadoop.conf.Configuration)conf);
    }

    public static List<String> collectionToStringList(Collection c) {
        ArrayList<String> l = new ArrayList<String>(c.size());
        for (Object o : c) {
            l.add(o.toString());
        }
        return l;
    }

    public static String join(Collection collection, String separator) {
        return ServiceUtils.join(collection, separator, true);
    }

    public static String join(Collection collection, String separator, boolean trailing) {
        StringBuilder b = new StringBuilder();
        if (collection.isEmpty()) {
            return trailing ? separator : "";
        }
        for (Object o : collection) {
            b.append(o).append(separator);
        }
        int length = separator.length();
        String s = b.toString();
        return trailing || s.isEmpty() ? s : b.substring(0, b.length() - length);
    }

    public static String join(String[] collection, String separator, boolean trailing) {
        return ServiceUtils.join(Arrays.asList(collection), separator, trailing);
    }

    public static String mandatoryEnvVariable(String key) throws BadClusterStateException {
        String v = System.getenv(key);
        if (v == null) {
            throw new BadClusterStateException("Missing Environment variable " + key, new Object[0]);
        }
        return v;
    }

    public static <T1, T2> Map<T1, T2> mergeMapsIgnoreDuplicateKeys(Map<T1, T2> first, Map<T1, T2> second) {
        Preconditions.checkArgument((first != null ? 1 : 0) != 0, (Object)"Null 'first' value");
        Preconditions.checkArgument((second != null ? 1 : 0) != 0, (Object)"Null 'second' value");
        for (Map.Entry<T1, T2> entry : second.entrySet()) {
            T1 key = entry.getKey();
            if (first.containsKey(key)) continue;
            first.put(key, entry.getValue());
        }
        return first;
    }

    public static String stringifyMap(Map<String, String> map) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            builder.append(entry.getKey()).append("=\"").append(entry.getValue()).append("\"\n");
        }
        return builder.toString();
    }

    public static String stringify(URL url) {
        StringBuilder builder = new StringBuilder();
        builder.append(url.getScheme()).append("://");
        if (url.getHost() != null) {
            builder.append(url.getHost()).append(":").append(url.getPort());
        }
        builder.append(url.getFile());
        return builder.toString();
    }

    public static int getOpenPort() throws IOException {
        try (ServerSocket socket = null;){
            socket = new ServerSocket(0);
            int n = socket.getLocalPort();
            return n;
        }
    }

    public static boolean isPortAvailable(int port) {
        try {
            ServerSocket socket = new ServerSocket(port);
            socket.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static Map<String, String> buildEnvMap(Configuration conf, Map<String, String> tokenMap) {
        if (tokenMap == null) {
            return conf.getEnv();
        }
        HashMap<String, String> env = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : conf.getEnv().entrySet()) {
            String key = entry.getKey();
            String val = entry.getValue();
            for (Map.Entry<String, String> token : tokenMap.entrySet()) {
                val = val.replaceAll(Pattern.quote(token.getKey()), token.getValue());
            }
            env.put(key, val);
        }
        return env;
    }

    public static String[] getLibDirs() {
        String libDirStr = System.getProperty("service.libdir");
        if (ServiceUtils.isUnset(libDirStr)) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        return StringUtils.split((String)libDirStr, (char)',');
    }

    public static LocalResource putJar(Map<String, LocalResource> providerResources, SliderFileSystem sliderFileSystem, Class clazz, Path tempPath, String libdir, String jarName) throws IOException, SliderException {
        LocalResource res = sliderFileSystem.submitJarWithClass(clazz, tempPath, libdir, jarName);
        providerResources.put(libdir + "/" + jarName, res);
        return res;
    }

    public static void putAllJars(Map<String, LocalResource> providerResources, SliderFileSystem sliderFileSystem, Path tempPath, String libDir, String srcPath) throws IOException, SliderException {
        log.debug("Loading all dependencies from {}", (Object)srcPath);
        if (ServiceUtils.isSet(srcPath)) {
            File srcFolder = new File(srcPath);
            FilenameFilter jarFilter = ServiceUtils.createJarFilter();
            File[] listOfJars = srcFolder.listFiles(jarFilter);
            if (listOfJars == null || listOfJars.length == 0) {
                return;
            }
            for (File jarFile : listOfJars) {
                if (!jarFile.exists()) {
                    log.debug("File does not exist, skipping: " + jarFile);
                    continue;
                }
                LocalResource res = sliderFileSystem.submitFile(jarFile, tempPath, libDir, jarFile.getName());
                providerResources.put(libDir + "/" + jarFile.getName(), res);
            }
        }
    }

    public static FilenameFilter createJarFilter() {
        return new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase(Locale.ENGLISH).endsWith(".jar");
            }
        };
    }

    public static Path createLocalPath(File file) {
        return new Path(file.toURI());
    }

    public static ClasspathConstructor buildClasspath(String sliderConfDir, String libdir, SliderFileSystem sliderFileSystem, String configClassPath, boolean usingMiniMRCluster) {
        ClasspathConstructor classpath = new ClasspathConstructor();
        classpath.append("yarnservice-log4j.properties");
        if (usingMiniMRCluster) {
            classpath.appendAll(classpath.localJVMClasspath());
        } else {
            if (sliderConfDir != null) {
                classpath.addClassDirectory(sliderConfDir);
            }
            classpath.addLibDir(libdir);
            if (sliderFileSystem.isFile(sliderFileSystem.getDependencyTarGzip())) {
                classpath.addLibDir("service_dep");
            }
            classpath.addRemoteClasspathEnvVar();
            classpath.append(ApplicationConstants.Environment.HADOOP_CONF_DIR.$$());
        }
        if (!configClassPath.isEmpty()) {
            classpath.appendAll(Arrays.asList(configClassPath.split(",")));
        }
        return classpath;
    }

    public static void tarGzipFolder(String[] libDirs, File tarGzipFile, FilenameFilter filter) throws IOException {
        log.info("Tar-gzipping folders {} to {}", (Object)libDirs, (Object)tarGzipFile.getAbsolutePath());
        try (TarArchiveOutputStream taos = new TarArchiveOutputStream((OutputStream)new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(tarGzipFile))));){
            for (String libDir : libDirs) {
                File srcFolder = new File(libDir);
                ArrayList<String> files = new ArrayList<String>();
                ServiceUtils.generateFileList(files, srcFolder, srcFolder, true, filter);
                for (String file : files) {
                    File srcFile = new File(srcFolder, file);
                    TarArchiveEntry tarEntry = new TarArchiveEntry(srcFile, file);
                    taos.putArchiveEntry(tarEntry);
                    try (FileInputStream in = new FileInputStream(srcFile);){
                        IOUtils.copy((InputStream)in, (OutputStream)taos);
                    }
                    taos.flush();
                    taos.closeArchiveEntry();
                }
            }
        }
    }

    private static void generateFileList(List<String> fileList, File node, File rootFolder, Boolean relative, FilenameFilter filter) {
        if (node.isFile()) {
            String fileFullPath = node.toString();
            if (relative.booleanValue()) {
                fileList.add(fileFullPath.substring(rootFolder.toString().length() + 1, fileFullPath.length()));
            } else {
                fileList.add(fileFullPath);
            }
        }
        if (node.isDirectory()) {
            String[] subNode = node.list(filter);
            if (subNode == null || subNode.length == 0) {
                return;
            }
            for (String filename : subNode) {
                ServiceUtils.generateFileList(fileList, new File(node, filename), rootFolder, relative, filter);
            }
        }
    }

    public static String createNameTag(String name) {
        return "Name: " + name;
    }

    public static String createVersionTag(String version) {
        return "Version: " + version;
    }

    public static String createDescriptionTag(String description) {
        return "Description: " + description;
    }

    public static String getLocalHostName(@Nullable org.apache.hadoop.conf.Configuration conf) throws UnknownHostException {
        if (conf != null) {
            String dnsInterface = conf.get("hadoop.security.dns.interface");
            String nameServer = conf.get("hadoop.security.dns.nameserver");
            if (dnsInterface != null) {
                return DNS.getDefaultHost((String)dnsInterface, (String)nameServer, (boolean)true);
            }
            if (nameServer != null) {
                throw new IllegalArgumentException("hadoop.security.dns.nameserver requires hadoop.security.dns.interface. Check yourconfiguration.");
            }
        }
        return InetAddress.getLocalHost().getCanonicalHostName();
    }

    public static class ProcessTerminationHandler {
        public void terminate(int exitCode) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                log.info("Interrupted on sleep while exiting.", (Throwable)e);
            }
            ExitUtil.terminate((int)exitCode);
        }
    }
}

