/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.event.AbstractEvent;
import org.apache.hadoop.yarn.server.resourcemanager.RMFatalEventType;

public class RMFatalEvent
extends AbstractEvent<RMFatalEventType> {
    private final Exception cause;
    private final String message;

    public RMFatalEvent(RMFatalEventType rmFatalEventType, String message) {
        this(rmFatalEventType, null, message);
    }

    public RMFatalEvent(RMFatalEventType rmFatalEventType, Exception cause) {
        this(rmFatalEventType, cause, null);
    }

    public RMFatalEvent(RMFatalEventType rmFatalEventType, Exception cause, String message) {
        super((Enum)rmFatalEventType);
        this.cause = cause;
        this.message = message;
    }

    public String getExplanation() {
        StringBuilder sb = new StringBuilder();
        if (this.message != null) {
            sb.append(this.message);
            if (this.cause != null) {
                sb.append(": ");
            }
        }
        if (this.cause != null) {
            sb.append(StringUtils.stringifyException((Throwable)this.cause));
        }
        return sb.toString();
    }

    public String toString() {
        return String.format("RMFatalEvent of type %s, caused by %s", ((RMFatalEventType)this.getType()).name(), this.getExplanation());
    }
}

