/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.zookeeper.server.admin;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.admin.Command;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.admin.CommandResponse;

public abstract class CommandBase
implements Command {
    private final String primaryName;
    private final Set<String> names;
    private final String doc;
    private final boolean serverRequired;

    protected CommandBase(List<String> names) {
        this(names, true, null);
    }

    protected CommandBase(List<String> names, boolean serverRequired) {
        this(names, serverRequired, null);
    }

    protected CommandBase(List<String> names, boolean serverRequired, String doc) {
        this.primaryName = names.get(0);
        this.names = new HashSet<String>(names);
        this.doc = doc;
        this.serverRequired = serverRequired;
    }

    @Override
    public String getPrimaryName() {
        return this.primaryName;
    }

    @Override
    public Set<String> getNames() {
        return this.names;
    }

    @Override
    public String getDoc() {
        return this.doc;
    }

    @Override
    public boolean isServerRequired() {
        return this.serverRequired;
    }

    protected CommandResponse initializeResponse() {
        return new CommandResponse(this.primaryName);
    }
}

