/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolPB;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.ProvidedStorageLocation;
import org.apache.hadoop.hdfs.protocol.proto.AliasMapProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.DatanodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.ErasureCodingProtos;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocol.proto.HdfsServerProtos;
import org.apache.hadoop.hdfs.protocol.proto.JournalProtocolProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.hdfs.security.token.block.BlockKey;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.hdfs.server.common.FileRegion;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.namenode.CheckpointSignature;
import org.apache.hadoop.hdfs.server.protocol.BalancerBandwidthCommand;
import org.apache.hadoop.hdfs.server.protocol.BlockCommand;
import org.apache.hadoop.hdfs.server.protocol.BlockECReconstructionCommand;
import org.apache.hadoop.hdfs.server.protocol.BlockIdCommand;
import org.apache.hadoop.hdfs.server.protocol.BlockRecoveryCommand;
import org.apache.hadoop.hdfs.server.protocol.BlockReportContext;
import org.apache.hadoop.hdfs.server.protocol.BlocksWithLocations;
import org.apache.hadoop.hdfs.server.protocol.CheckpointCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.FinalizeCommand;
import org.apache.hadoop.hdfs.server.protocol.JournalInfo;
import org.apache.hadoop.hdfs.server.protocol.KeyUpdateCommand;
import org.apache.hadoop.hdfs.server.protocol.NNHAStatusHeartbeat;
import org.apache.hadoop.hdfs.server.protocol.NamenodeCommand;
import org.apache.hadoop.hdfs.server.protocol.NamenodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.OutlierMetrics;
import org.apache.hadoop.hdfs.server.protocol.ReceivedDeletedBlockInfo;
import org.apache.hadoop.hdfs.server.protocol.RegisterCommand;
import org.apache.hadoop.hdfs.server.protocol.RemoteEditLog;
import org.apache.hadoop.hdfs.server.protocol.RemoteEditLogManifest;
import org.apache.hadoop.hdfs.server.protocol.SlowDiskReports;
import org.apache.hadoop.hdfs.server.protocol.SlowPeerReports;
import org.apache.hadoop.hdfs.server.protocol.VolumeFailureSummary;
import org.apache.hadoop.thirdparty.protobuf.ByteString;
import org.apache.hadoop.thirdparty.protobuf.ProtocolStringList;

public class PBHelper {
    private static final DatanodeProtocolProtos.RegisterCommandProto REG_CMD_PROTO = DatanodeProtocolProtos.RegisterCommandProto.newBuilder().build();
    private static final RegisterCommand REG_CMD = new RegisterCommand();

    private PBHelper() {
    }

    public static HdfsServerConstants.NamenodeRole convert(HdfsServerProtos.NamenodeRegistrationProto.NamenodeRoleProto role) {
        switch (role) {
            case NAMENODE: {
                return HdfsServerConstants.NamenodeRole.NAMENODE;
            }
            case BACKUP: {
                return HdfsServerConstants.NamenodeRole.BACKUP;
            }
            case CHECKPOINT: {
                return HdfsServerConstants.NamenodeRole.CHECKPOINT;
            }
        }
        return null;
    }

    public static HdfsServerProtos.NamenodeRegistrationProto.NamenodeRoleProto convert(HdfsServerConstants.NamenodeRole role) {
        switch (role) {
            case NAMENODE: {
                return HdfsServerProtos.NamenodeRegistrationProto.NamenodeRoleProto.NAMENODE;
            }
            case BACKUP: {
                return HdfsServerProtos.NamenodeRegistrationProto.NamenodeRoleProto.BACKUP;
            }
            case CHECKPOINT: {
                return HdfsServerProtos.NamenodeRegistrationProto.NamenodeRoleProto.CHECKPOINT;
            }
        }
        return null;
    }

    public static HdfsServerProtos.StorageInfoProto convert(StorageInfo info) {
        return HdfsServerProtos.StorageInfoProto.newBuilder().setClusterID(info.getClusterID()).setCTime(info.getCTime()).setLayoutVersion(info.getLayoutVersion()).setNamespceID(info.getNamespaceID()).build();
    }

    public static StorageInfo convert(HdfsServerProtos.StorageInfoProto info, HdfsServerConstants.NodeType type) {
        return new StorageInfo(info.getLayoutVersion(), info.getNamespceID(), info.getClusterID(), info.getCTime(), type);
    }

    public static HdfsServerProtos.NamenodeRegistrationProto convert(NamenodeRegistration reg) {
        return HdfsServerProtos.NamenodeRegistrationProto.newBuilder().setHttpAddress(reg.getHttpAddress()).setRole(PBHelper.convert(reg.getRole())).setRpcAddress(reg.getAddress()).setStorageInfo(PBHelper.convert((StorageInfo)reg)).build();
    }

    public static NamenodeRegistration convert(HdfsServerProtos.NamenodeRegistrationProto reg) {
        StorageInfo si = PBHelper.convert(reg.getStorageInfo(), HdfsServerConstants.NodeType.NAME_NODE);
        return new NamenodeRegistration(reg.getRpcAddress(), reg.getHttpAddress(), si, PBHelper.convert(reg.getRole()));
    }

    public static HdfsServerProtos.BlockWithLocationsProto convert(BlocksWithLocations.BlockWithLocations blk) {
        HdfsServerProtos.BlockWithLocationsProto.Builder builder = HdfsServerProtos.BlockWithLocationsProto.newBuilder().setBlock(PBHelperClient.convert((Block)blk.getBlock())).addAllDatanodeUuids(Arrays.asList(blk.getDatanodeUuids())).addAllStorageUuids(Arrays.asList(blk.getStorageIDs())).addAllStorageTypes(PBHelperClient.convertStorageTypes((StorageType[])blk.getStorageTypes()));
        if (blk instanceof BlocksWithLocations.StripedBlockWithLocations) {
            BlocksWithLocations.StripedBlockWithLocations sblk = (BlocksWithLocations.StripedBlockWithLocations)blk;
            builder.setIndices(PBHelperClient.getByteString((byte[])sblk.getIndices()));
            builder.setDataBlockNum(sblk.getDataBlockNum());
            builder.setCellSize(sblk.getCellSize());
        }
        return builder.build();
    }

    public static BlocksWithLocations.BlockWithLocations convert(HdfsServerProtos.BlockWithLocationsProto b) {
        ProtocolStringList datanodeUuids = b.getDatanodeUuidsList();
        ProtocolStringList storageUuids = b.getStorageUuidsList();
        List<HdfsProtos.StorageTypeProto> storageTypes = b.getStorageTypesList();
        BlocksWithLocations.BlockWithLocations blk = new BlocksWithLocations.BlockWithLocations(PBHelperClient.convert((HdfsProtos.BlockProto)b.getBlock()), datanodeUuids.toArray(new String[datanodeUuids.size()]), storageUuids.toArray(new String[storageUuids.size()]), PBHelperClient.convertStorageTypes(storageTypes, (int)storageUuids.size()));
        if (b.hasIndices()) {
            blk = new BlocksWithLocations.StripedBlockWithLocations(blk, b.getIndices().toByteArray(), (short)b.getDataBlockNum(), b.getCellSize());
        }
        return blk;
    }

    public static HdfsServerProtos.BlocksWithLocationsProto convert(BlocksWithLocations blks) {
        HdfsServerProtos.BlocksWithLocationsProto.Builder builder = HdfsServerProtos.BlocksWithLocationsProto.newBuilder();
        for (BlocksWithLocations.BlockWithLocations b : blks.getBlocks()) {
            builder.addBlocks(PBHelper.convert(b));
        }
        return builder.build();
    }

    public static BlocksWithLocations convert(HdfsServerProtos.BlocksWithLocationsProto blocks) {
        List<HdfsServerProtos.BlockWithLocationsProto> b = blocks.getBlocksList();
        BlocksWithLocations.BlockWithLocations[] ret = new BlocksWithLocations.BlockWithLocations[b.size()];
        int i = 0;
        for (HdfsServerProtos.BlockWithLocationsProto entry : b) {
            ret[i++] = PBHelper.convert(entry);
        }
        return new BlocksWithLocations(ret);
    }

    public static HdfsServerProtos.BlockKeyProto convert(BlockKey key) {
        byte[] encodedKey = key.getEncodedKey();
        ByteString keyBytes = PBHelperClient.getByteString((byte[])(encodedKey == null ? DFSUtilClient.EMPTY_BYTES : encodedKey));
        return HdfsServerProtos.BlockKeyProto.newBuilder().setKeyId(key.getKeyId()).setKeyBytes(keyBytes).setExpiryDate(key.getExpiryDate()).build();
    }

    public static BlockKey convert(HdfsServerProtos.BlockKeyProto k) {
        return new BlockKey(k.getKeyId(), k.getExpiryDate(), k.getKeyBytes().toByteArray());
    }

    public static HdfsServerProtos.ExportedBlockKeysProto convert(ExportedBlockKeys keys) {
        HdfsServerProtos.ExportedBlockKeysProto.Builder builder = HdfsServerProtos.ExportedBlockKeysProto.newBuilder();
        builder.setIsBlockTokenEnabled(keys.isBlockTokenEnabled()).setKeyUpdateInterval(keys.getKeyUpdateInterval()).setTokenLifeTime(keys.getTokenLifetime()).setCurrentKey(PBHelper.convert(keys.getCurrentKey()));
        for (BlockKey k : keys.getAllKeys()) {
            builder.addAllKeys(PBHelper.convert(k));
        }
        return builder.build();
    }

    public static ExportedBlockKeys convert(HdfsServerProtos.ExportedBlockKeysProto keys) {
        return new ExportedBlockKeys(keys.getIsBlockTokenEnabled(), keys.getKeyUpdateInterval(), keys.getTokenLifeTime(), PBHelper.convert(keys.getCurrentKey()), PBHelper.convertBlockKeys(keys.getAllKeysList()));
    }

    public static HdfsServerProtos.CheckpointSignatureProto convert(CheckpointSignature s) {
        return HdfsServerProtos.CheckpointSignatureProto.newBuilder().setBlockPoolId(s.getBlockpoolID()).setCurSegmentTxId(s.getCurSegmentTxId()).setMostRecentCheckpointTxId(s.getMostRecentCheckpointTxId()).setStorageInfo(PBHelper.convert((StorageInfo)s)).build();
    }

    public static CheckpointSignature convert(HdfsServerProtos.CheckpointSignatureProto s) {
        StorageInfo si = PBHelper.convert(s.getStorageInfo(), HdfsServerConstants.NodeType.NAME_NODE);
        return new CheckpointSignature(si, s.getBlockPoolId(), s.getMostRecentCheckpointTxId(), s.getCurSegmentTxId());
    }

    public static HdfsServerProtos.RemoteEditLogProto convert(RemoteEditLog log) {
        return HdfsServerProtos.RemoteEditLogProto.newBuilder().setStartTxId(log.getStartTxId()).setEndTxId(log.getEndTxId()).setIsInProgress(log.isInProgress()).build();
    }

    public static RemoteEditLog convert(HdfsServerProtos.RemoteEditLogProto l) {
        return new RemoteEditLog(l.getStartTxId(), l.getEndTxId(), l.getIsInProgress());
    }

    public static HdfsServerProtos.RemoteEditLogManifestProto convert(RemoteEditLogManifest manifest) {
        HdfsServerProtos.RemoteEditLogManifestProto.Builder builder = HdfsServerProtos.RemoteEditLogManifestProto.newBuilder().setCommittedTxnId(manifest.getCommittedTxnId());
        for (RemoteEditLog log : manifest.getLogs()) {
            builder.addLogs(PBHelper.convert(log));
        }
        return builder.build();
    }

    public static RemoteEditLogManifest convert(HdfsServerProtos.RemoteEditLogManifestProto manifest) {
        ArrayList<RemoteEditLog> logs = new ArrayList<RemoteEditLog>(manifest.getLogsList().size());
        for (HdfsServerProtos.RemoteEditLogProto l : manifest.getLogsList()) {
            logs.add(PBHelper.convert(l));
        }
        return new RemoteEditLogManifest(logs, manifest.getCommittedTxnId());
    }

    public static HdfsServerProtos.CheckpointCommandProto convert(CheckpointCommand cmd) {
        return HdfsServerProtos.CheckpointCommandProto.newBuilder().setSignature(PBHelper.convert(cmd.getSignature())).setNeedToReturnImage(cmd.needToReturnImage()).build();
    }

    public static HdfsServerProtos.NamenodeCommandProto convert(NamenodeCommand cmd) {
        if (cmd instanceof CheckpointCommand) {
            return HdfsServerProtos.NamenodeCommandProto.newBuilder().setAction(cmd.getAction()).setType(HdfsServerProtos.NamenodeCommandProto.Type.CheckPointCommand).setCheckpointCmd(PBHelper.convert((CheckpointCommand)cmd)).build();
        }
        return HdfsServerProtos.NamenodeCommandProto.newBuilder().setType(HdfsServerProtos.NamenodeCommandProto.Type.NamenodeCommand).setAction(cmd.getAction()).build();
    }

    public static BlockKey[] convertBlockKeys(List<HdfsServerProtos.BlockKeyProto> list) {
        BlockKey[] ret = new BlockKey[list.size()];
        int i = 0;
        for (HdfsServerProtos.BlockKeyProto k : list) {
            ret[i++] = PBHelper.convert(k);
        }
        return ret;
    }

    public static NamespaceInfo convert(HdfsServerProtos.NamespaceInfoProto info) {
        HdfsServerProtos.StorageInfoProto storage = info.getStorageInfo();
        NamespaceInfo nsInfo = new NamespaceInfo(storage.getNamespceID(), storage.getClusterID(), info.getBlockPoolID(), storage.getCTime(), info.getBuildVersion(), info.getSoftwareVersion(), info.getCapabilities(), PBHelper.convert(info.getState()));
        nsInfo.setStorageInfo(PBHelper.convert(storage, HdfsServerConstants.NodeType.NAME_NODE));
        return nsInfo;
    }

    public static NamenodeCommand convert(HdfsServerProtos.NamenodeCommandProto cmd) {
        if (cmd == null) {
            return null;
        }
        switch (cmd.getType()) {
            case CheckPointCommand: {
                HdfsServerProtos.CheckpointCommandProto chkPt = cmd.getCheckpointCmd();
                return new CheckpointCommand(PBHelper.convert(chkPt.getSignature()), chkPt.getNeedToReturnImage());
            }
        }
        return new NamenodeCommand(cmd.getAction());
    }

    public static HdfsServerProtos.RecoveringBlockProto convert(BlockRecoveryCommand.RecoveringBlock b) {
        if (b == null) {
            return null;
        }
        HdfsProtos.LocatedBlockProto lb = PBHelperClient.convertLocatedBlock((LocatedBlock)b);
        HdfsServerProtos.RecoveringBlockProto.Builder builder = HdfsServerProtos.RecoveringBlockProto.newBuilder();
        builder.setBlock(lb).setNewGenStamp(b.getNewGenerationStamp());
        if (b.getNewBlock() != null) {
            builder.setTruncateBlock(PBHelperClient.convert((Block)b.getNewBlock()));
        }
        if (b instanceof BlockRecoveryCommand.RecoveringStripedBlock) {
            BlockRecoveryCommand.RecoveringStripedBlock sb = (BlockRecoveryCommand.RecoveringStripedBlock)b;
            builder.setEcPolicy(PBHelperClient.convertErasureCodingPolicy((ErasureCodingPolicy)sb.getErasureCodingPolicy()));
            builder.setBlockIndices(PBHelperClient.getByteString((byte[])sb.getBlockIndices()));
        }
        return builder.build();
    }

    public static BlockRecoveryCommand.RecoveringBlock convert(HdfsServerProtos.RecoveringBlockProto b) {
        LocatedBlock lb = PBHelperClient.convertLocatedBlockProto((HdfsProtos.LocatedBlockProto)b.getBlock());
        BlockRecoveryCommand.RecoveringBlock rBlock = b.hasTruncateBlock() ? new BlockRecoveryCommand.RecoveringBlock(lb.getBlock(), (DatanodeInfo[])lb.getLocations(), PBHelperClient.convert((HdfsProtos.BlockProto)b.getTruncateBlock())) : new BlockRecoveryCommand.RecoveringBlock(lb.getBlock(), (DatanodeInfo[])lb.getLocations(), b.getNewGenStamp());
        if (b.hasEcPolicy()) {
            assert (b.hasBlockIndices());
            byte[] indices = b.getBlockIndices().toByteArray();
            rBlock = new BlockRecoveryCommand.RecoveringStripedBlock(rBlock, indices, PBHelperClient.convertErasureCodingPolicy((HdfsProtos.ErasureCodingPolicyProto)b.getEcPolicy()));
        }
        return rBlock;
    }

    public static HdfsServerConstants.ReplicaState convert(HdfsServerProtos.ReplicaStateProto state) {
        switch (state) {
            case RBW: {
                return HdfsServerConstants.ReplicaState.RBW;
            }
            case RUR: {
                return HdfsServerConstants.ReplicaState.RUR;
            }
            case RWR: {
                return HdfsServerConstants.ReplicaState.RWR;
            }
            case TEMPORARY: {
                return HdfsServerConstants.ReplicaState.TEMPORARY;
            }
        }
        return HdfsServerConstants.ReplicaState.FINALIZED;
    }

    public static HdfsServerProtos.ReplicaStateProto convert(HdfsServerConstants.ReplicaState state) {
        switch (state) {
            case RBW: {
                return HdfsServerProtos.ReplicaStateProto.RBW;
            }
            case RUR: {
                return HdfsServerProtos.ReplicaStateProto.RUR;
            }
            case RWR: {
                return HdfsServerProtos.ReplicaStateProto.RWR;
            }
            case TEMPORARY: {
                return HdfsServerProtos.ReplicaStateProto.TEMPORARY;
            }
        }
        return HdfsServerProtos.ReplicaStateProto.FINALIZED;
    }

    public static DatanodeProtocolProtos.DatanodeRegistrationProto convert(DatanodeRegistration registration) {
        DatanodeProtocolProtos.DatanodeRegistrationProto.Builder builder = DatanodeProtocolProtos.DatanodeRegistrationProto.newBuilder();
        return builder.setDatanodeID(PBHelperClient.convert((DatanodeID)registration)).setStorageInfo(PBHelper.convert(registration.getStorageInfo())).setKeys(PBHelper.convert(registration.getExportedKeys())).setSoftwareVersion(registration.getSoftwareVersion()).build();
    }

    public static DatanodeRegistration convert(DatanodeProtocolProtos.DatanodeRegistrationProto proto) {
        StorageInfo si = PBHelper.convert(proto.getStorageInfo(), HdfsServerConstants.NodeType.DATA_NODE);
        return new DatanodeRegistration(PBHelperClient.convert((HdfsProtos.DatanodeIDProto)proto.getDatanodeID()), si, PBHelper.convert(proto.getKeys()), proto.getSoftwareVersion());
    }

    public static DatanodeCommand convert(DatanodeProtocolProtos.DatanodeCommandProto proto) {
        switch (proto.getCmdType()) {
            case BalancerBandwidthCommand: {
                return PBHelper.convert(proto.getBalancerCmd());
            }
            case BlockCommand: {
                return PBHelper.convert(proto.getBlkCmd());
            }
            case BlockRecoveryCommand: {
                return PBHelper.convert(proto.getRecoveryCmd());
            }
            case FinalizeCommand: {
                return PBHelper.convert(proto.getFinalizeCmd());
            }
            case KeyUpdateCommand: {
                return PBHelper.convert(proto.getKeyUpdateCmd());
            }
            case RegisterCommand: {
                return REG_CMD;
            }
            case BlockIdCommand: {
                return PBHelper.convert(proto.getBlkIdCmd());
            }
            case BlockECReconstructionCommand: {
                return PBHelper.convert(proto.getBlkECReconstructionCmd());
            }
        }
        return null;
    }

    public static DatanodeProtocolProtos.BalancerBandwidthCommandProto convert(BalancerBandwidthCommand bbCmd) {
        return DatanodeProtocolProtos.BalancerBandwidthCommandProto.newBuilder().setBandwidth(bbCmd.getBalancerBandwidthValue()).build();
    }

    public static DatanodeProtocolProtos.KeyUpdateCommandProto convert(KeyUpdateCommand cmd) {
        return DatanodeProtocolProtos.KeyUpdateCommandProto.newBuilder().setKeys(PBHelper.convert(cmd.getExportedKeys())).build();
    }

    public static DatanodeProtocolProtos.BlockRecoveryCommandProto convert(BlockRecoveryCommand cmd) {
        DatanodeProtocolProtos.BlockRecoveryCommandProto.Builder builder = DatanodeProtocolProtos.BlockRecoveryCommandProto.newBuilder();
        for (BlockRecoveryCommand.RecoveringBlock b : cmd.getRecoveringBlocks()) {
            builder.addBlocks(PBHelper.convert(b));
        }
        return builder.build();
    }

    public static DatanodeProtocolProtos.FinalizeCommandProto convert(FinalizeCommand cmd) {
        return DatanodeProtocolProtos.FinalizeCommandProto.newBuilder().setBlockPoolId(cmd.getBlockPoolId()).build();
    }

    public static DatanodeProtocolProtos.BlockCommandProto convert(BlockCommand cmd) {
        DatanodeProtocolProtos.BlockCommandProto.Builder builder = DatanodeProtocolProtos.BlockCommandProto.newBuilder().setBlockPoolId(cmd.getBlockPoolId());
        switch (cmd.getAction()) {
            case 1: {
                builder.setAction(DatanodeProtocolProtos.BlockCommandProto.Action.TRANSFER);
                break;
            }
            case 2: {
                builder.setAction(DatanodeProtocolProtos.BlockCommandProto.Action.INVALIDATE);
                break;
            }
            case 3: {
                builder.setAction(DatanodeProtocolProtos.BlockCommandProto.Action.SHUTDOWN);
                break;
            }
            default: {
                throw new AssertionError((Object)"Invalid action");
            }
        }
        Block[] blocks = cmd.getBlocks();
        for (int i = 0; i < blocks.length; ++i) {
            builder.addBlocks(PBHelperClient.convert((Block)blocks[i]));
        }
        builder.addAllTargets(PBHelperClient.convert((DatanodeInfo[][])cmd.getTargets())).addAllTargetStorageUuids(PBHelper.convert(cmd.getTargetStorageIDs()));
        StorageType[][] types = cmd.getTargetStorageTypes();
        if (types != null) {
            builder.addAllTargetStorageTypes(PBHelperClient.convert((StorageType[][])types));
        }
        return builder.build();
    }

    public static DatanodeProtocolProtos.BlockIdCommandProto convert(BlockIdCommand cmd) {
        DatanodeProtocolProtos.BlockIdCommandProto.Builder builder = DatanodeProtocolProtos.BlockIdCommandProto.newBuilder().setBlockPoolId(cmd.getBlockPoolId());
        switch (cmd.getAction()) {
            case 9: {
                builder.setAction(DatanodeProtocolProtos.BlockIdCommandProto.Action.CACHE);
                break;
            }
            case 10: {
                builder.setAction(DatanodeProtocolProtos.BlockIdCommandProto.Action.UNCACHE);
                break;
            }
            default: {
                throw new AssertionError((Object)"Invalid action");
            }
        }
        long[] blockIds = cmd.getBlockIds();
        for (int i = 0; i < blockIds.length; ++i) {
            builder.addBlockIds(blockIds[i]);
        }
        return builder.build();
    }

    private static List<HdfsProtos.StorageUuidsProto> convert(String[][] targetStorageUuids) {
        HdfsProtos.StorageUuidsProto[] ret = new HdfsProtos.StorageUuidsProto[targetStorageUuids.length];
        for (int i = 0; i < targetStorageUuids.length; ++i) {
            ret[i] = HdfsProtos.StorageUuidsProto.newBuilder().addAllStorageUuids(Arrays.asList(targetStorageUuids[i])).build();
        }
        return Arrays.asList(ret);
    }

    public static DatanodeProtocolProtos.DatanodeCommandProto convert(DatanodeCommand datanodeCommand) {
        DatanodeProtocolProtos.DatanodeCommandProto.Builder builder = DatanodeProtocolProtos.DatanodeCommandProto.newBuilder();
        if (datanodeCommand == null) {
            return builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.NullDatanodeCommand).build();
        }
        switch (datanodeCommand.getAction()) {
            case 8: {
                builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.BalancerBandwidthCommand).setBalancerCmd(PBHelper.convert((BalancerBandwidthCommand)datanodeCommand));
                break;
            }
            case 7: {
                builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.KeyUpdateCommand).setKeyUpdateCmd(PBHelper.convert((KeyUpdateCommand)datanodeCommand));
                break;
            }
            case 6: {
                builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.BlockRecoveryCommand).setRecoveryCmd(PBHelper.convert((BlockRecoveryCommand)datanodeCommand));
                break;
            }
            case 5: {
                builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.FinalizeCommand).setFinalizeCmd(PBHelper.convert((FinalizeCommand)datanodeCommand));
                break;
            }
            case 4: {
                builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.RegisterCommand).setRegisterCmd(REG_CMD_PROTO);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.BlockCommand).setBlkCmd(PBHelper.convert((BlockCommand)datanodeCommand));
                break;
            }
            case 9: 
            case 10: {
                builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.BlockIdCommand).setBlkIdCmd(PBHelper.convert((BlockIdCommand)datanodeCommand));
                break;
            }
            case 11: {
                builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.BlockECReconstructionCommand).setBlkECReconstructionCmd(PBHelper.convert((BlockECReconstructionCommand)datanodeCommand));
                break;
            }
            default: {
                builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.NullDatanodeCommand);
            }
        }
        return builder.build();
    }

    public static KeyUpdateCommand convert(DatanodeProtocolProtos.KeyUpdateCommandProto keyUpdateCmd) {
        return new KeyUpdateCommand(PBHelper.convert(keyUpdateCmd.getKeys()));
    }

    public static FinalizeCommand convert(DatanodeProtocolProtos.FinalizeCommandProto finalizeCmd) {
        return new FinalizeCommand(finalizeCmd.getBlockPoolId());
    }

    public static BlockRecoveryCommand convert(DatanodeProtocolProtos.BlockRecoveryCommandProto recoveryCmd) {
        List<HdfsServerProtos.RecoveringBlockProto> list = recoveryCmd.getBlocksList();
        ArrayList<BlockRecoveryCommand.RecoveringBlock> recoveringBlocks = new ArrayList<BlockRecoveryCommand.RecoveringBlock>(list.size());
        for (HdfsServerProtos.RecoveringBlockProto rbp : list) {
            recoveringBlocks.add(PBHelper.convert(rbp));
        }
        return new BlockRecoveryCommand(recoveringBlocks);
    }

    public static BlockCommand convert(DatanodeProtocolProtos.BlockCommandProto blkCmd) {
        int i;
        List<HdfsProtos.BlockProto> blockProtoList = blkCmd.getBlocksList();
        Block[] blocks = new Block[blockProtoList.size()];
        for (int i2 = 0; i2 < blockProtoList.size(); ++i2) {
            blocks[i2] = PBHelperClient.convert((HdfsProtos.BlockProto)blockProtoList.get(i2));
        }
        List<HdfsProtos.DatanodeInfosProto> targetList = blkCmd.getTargetsList();
        DatanodeInfo[][] targets = new DatanodeInfo[targetList.size()][];
        for (int i3 = 0; i3 < targetList.size(); ++i3) {
            targets[i3] = PBHelperClient.convert((HdfsProtos.DatanodeInfosProto)targetList.get(i3));
        }
        StorageType[][] targetStorageTypes = new StorageType[targetList.size()][];
        List<HdfsProtos.StorageTypesProto> targetStorageTypesList = blkCmd.getTargetStorageTypesList();
        if (targetStorageTypesList.isEmpty()) {
            for (i = 0; i < targetStorageTypes.length; ++i) {
                targetStorageTypes[i] = new StorageType[targets[i].length];
                Arrays.fill(targetStorageTypes[i], StorageType.DEFAULT);
            }
        } else {
            for (i = 0; i < targetStorageTypes.length; ++i) {
                List p = targetStorageTypesList.get(i).getStorageTypesList();
                targetStorageTypes[i] = PBHelperClient.convertStorageTypes((List)p, (int)targets[i].length);
            }
        }
        List<HdfsProtos.StorageUuidsProto> targetStorageUuidsList = blkCmd.getTargetStorageUuidsList();
        String[][] targetStorageIDs = new String[targetStorageUuidsList.size()][];
        for (int i4 = 0; i4 < targetStorageIDs.length; ++i4) {
            ProtocolStringList storageIDs = targetStorageUuidsList.get(i4).getStorageUuidsList();
            targetStorageIDs[i4] = storageIDs.toArray(new String[storageIDs.size()]);
        }
        int action = 0;
        switch (blkCmd.getAction()) {
            case TRANSFER: {
                action = 1;
                break;
            }
            case INVALIDATE: {
                action = 2;
                break;
            }
            case SHUTDOWN: {
                action = 3;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown action type: " + (Object)((Object)blkCmd.getAction())));
            }
        }
        return new BlockCommand(action, blkCmd.getBlockPoolId(), blocks, targets, targetStorageTypes, targetStorageIDs);
    }

    public static BlockIdCommand convert(DatanodeProtocolProtos.BlockIdCommandProto blkIdCmd) {
        int numBlockIds = blkIdCmd.getBlockIdsCount();
        long[] blockIds = new long[numBlockIds];
        for (int i = 0; i < numBlockIds; ++i) {
            blockIds[i] = blkIdCmd.getBlockIds(i);
        }
        int action = 0;
        switch (blkIdCmd.getAction()) {
            case CACHE: {
                action = 9;
                break;
            }
            case UNCACHE: {
                action = 10;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown action type: " + (Object)((Object)blkIdCmd.getAction())));
            }
        }
        return new BlockIdCommand(action, blkIdCmd.getBlockPoolId(), blockIds);
    }

    public static BalancerBandwidthCommand convert(DatanodeProtocolProtos.BalancerBandwidthCommandProto balancerCmd) {
        return new BalancerBandwidthCommand(balancerCmd.getBandwidth());
    }

    public static DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto convert(ReceivedDeletedBlockInfo receivedDeletedBlockInfo) {
        DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto.BlockStatus status;
        DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto.Builder builder = DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto.newBuilder();
        switch (receivedDeletedBlockInfo.getStatus()) {
            case RECEIVING_BLOCK: {
                status = DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto.BlockStatus.RECEIVING;
                break;
            }
            case RECEIVED_BLOCK: {
                status = DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto.BlockStatus.RECEIVED;
                break;
            }
            case DELETED_BLOCK: {
                status = DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto.BlockStatus.DELETED;
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad status: " + (Object)((Object)receivedDeletedBlockInfo.getStatus()));
            }
        }
        builder.setStatus(status);
        if (receivedDeletedBlockInfo.getDelHints() != null) {
            builder.setDeleteHint(receivedDeletedBlockInfo.getDelHints());
        }
        return builder.setBlock(PBHelperClient.convert((Block)receivedDeletedBlockInfo.getBlock())).build();
    }

    public static ReceivedDeletedBlockInfo convert(DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto proto) {
        ReceivedDeletedBlockInfo.BlockStatus status = null;
        switch (proto.getStatus()) {
            case RECEIVING: {
                status = ReceivedDeletedBlockInfo.BlockStatus.RECEIVING_BLOCK;
                break;
            }
            case RECEIVED: {
                status = ReceivedDeletedBlockInfo.BlockStatus.RECEIVED_BLOCK;
                break;
            }
            case DELETED: {
                status = ReceivedDeletedBlockInfo.BlockStatus.DELETED_BLOCK;
            }
        }
        return new ReceivedDeletedBlockInfo(PBHelperClient.convert((HdfsProtos.BlockProto)proto.getBlock()), status, proto.hasDeleteHint() ? proto.getDeleteHint() : null);
    }

    public static HdfsServerProtos.NamespaceInfoProto convert(NamespaceInfo info) {
        HdfsServerProtos.NamespaceInfoProto.Builder builder = HdfsServerProtos.NamespaceInfoProto.newBuilder();
        builder.setBlockPoolID(info.getBlockPoolID()).setBuildVersion(info.getBuildVersion()).setUnused(0).setStorageInfo(PBHelper.convert((StorageInfo)info)).setSoftwareVersion(info.getSoftwareVersion()).setCapabilities(info.getCapabilities());
        HAServiceProtocol.HAServiceState state = info.getState();
        if (state != null) {
            builder.setState(PBHelper.convert(info.getState()));
        }
        return builder.build();
    }

    public static HAServiceProtocol.HAServiceState convert(HdfsServerProtos.NNHAStatusHeartbeatProto.State s) {
        if (s == null) {
            return null;
        }
        switch (s) {
            case ACTIVE: {
                return HAServiceProtocol.HAServiceState.ACTIVE;
            }
            case STANDBY: {
                return HAServiceProtocol.HAServiceState.STANDBY;
            }
            case OBSERVER: {
                return HAServiceProtocol.HAServiceState.OBSERVER;
            }
        }
        throw new IllegalArgumentException("Unexpected HAServiceStateProto:" + (Object)((Object)s));
    }

    public static HdfsServerProtos.NNHAStatusHeartbeatProto.State convert(HAServiceProtocol.HAServiceState s) {
        if (s == null) {
            return null;
        }
        switch (s) {
            case ACTIVE: {
                return HdfsServerProtos.NNHAStatusHeartbeatProto.State.ACTIVE;
            }
            case STANDBY: {
                return HdfsServerProtos.NNHAStatusHeartbeatProto.State.STANDBY;
            }
            case OBSERVER: {
                return HdfsServerProtos.NNHAStatusHeartbeatProto.State.OBSERVER;
            }
        }
        throw new IllegalArgumentException("Unexpected HAServiceState:" + s);
    }

    public static NNHAStatusHeartbeat convert(HdfsServerProtos.NNHAStatusHeartbeatProto s) {
        if (s == null) {
            return null;
        }
        return new NNHAStatusHeartbeat(PBHelper.convert(s.getState()), s.getTxid());
    }

    public static HdfsServerProtos.NNHAStatusHeartbeatProto convert(NNHAStatusHeartbeat hb) {
        if (hb == null) {
            return null;
        }
        HdfsServerProtos.NNHAStatusHeartbeatProto.Builder builder = HdfsServerProtos.NNHAStatusHeartbeatProto.newBuilder();
        builder.setState(PBHelper.convert(hb.getState()));
        builder.setTxid(hb.getTxId());
        return builder.build();
    }

    public static VolumeFailureSummary convertVolumeFailureSummary(DatanodeProtocolProtos.VolumeFailureSummaryProto proto) {
        ProtocolStringList failedStorageLocations = proto.getFailedStorageLocationsList();
        return new VolumeFailureSummary(failedStorageLocations.toArray(new String[failedStorageLocations.size()]), proto.getLastVolumeFailureDate(), proto.getEstimatedCapacityLostTotal());
    }

    public static DatanodeProtocolProtos.VolumeFailureSummaryProto convertVolumeFailureSummary(VolumeFailureSummary volumeFailureSummary) {
        DatanodeProtocolProtos.VolumeFailureSummaryProto.Builder builder = DatanodeProtocolProtos.VolumeFailureSummaryProto.newBuilder();
        for (String failedStorageLocation : volumeFailureSummary.getFailedStorageLocations()) {
            builder.addFailedStorageLocations(failedStorageLocation);
        }
        builder.setLastVolumeFailureDate(volumeFailureSummary.getLastVolumeFailureDate());
        builder.setEstimatedCapacityLostTotal(volumeFailureSummary.getEstimatedCapacityLostTotal());
        return builder.build();
    }

    public static List<DatanodeProtocolProtos.SlowPeerReportProto> convertSlowPeerInfo(SlowPeerReports slowPeers) {
        if (slowPeers.getSlowPeers().size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<DatanodeProtocolProtos.SlowPeerReportProto> slowPeerInfoProtos = new ArrayList<DatanodeProtocolProtos.SlowPeerReportProto>(slowPeers.getSlowPeers().size());
        for (Map.Entry entry : slowPeers.getSlowPeers().entrySet()) {
            OutlierMetrics outlierMetrics = (OutlierMetrics)entry.getValue();
            slowPeerInfoProtos.add(DatanodeProtocolProtos.SlowPeerReportProto.newBuilder().setDataNodeId((String)entry.getKey()).setAggregateLatency(outlierMetrics.getActualLatency()).setMedian(outlierMetrics.getMedian()).setMad(outlierMetrics.getMad()).setUpperLimitLatency(outlierMetrics.getUpperLimitLatency()).build());
        }
        return slowPeerInfoProtos;
    }

    public static SlowPeerReports convertSlowPeerInfo(List<DatanodeProtocolProtos.SlowPeerReportProto> slowPeerProtos) {
        if (slowPeerProtos == null || slowPeerProtos.size() == 0) {
            return SlowPeerReports.EMPTY_REPORT;
        }
        HashMap<String, OutlierMetrics> slowPeersMap = new HashMap<String, OutlierMetrics>(slowPeerProtos.size());
        for (DatanodeProtocolProtos.SlowPeerReportProto proto : slowPeerProtos) {
            if (!proto.hasDataNodeId()) continue;
            Double aggregateLatency = proto.hasAggregateLatency() ? proto.getAggregateLatency() : 0.0;
            Double medianLatency = proto.hasMedian() ? proto.getMedian() : 0.0;
            Double madLatency = proto.hasMad() ? proto.getMad() : 0.0;
            Double upperLimitLatency = proto.hasUpperLimitLatency() ? proto.getUpperLimitLatency() : 0.0;
            OutlierMetrics outlierMetrics = new OutlierMetrics(medianLatency, madLatency, upperLimitLatency, aggregateLatency);
            slowPeersMap.put(proto.getDataNodeId(), outlierMetrics);
        }
        return SlowPeerReports.create(slowPeersMap);
    }

    public static List<DatanodeProtocolProtos.SlowDiskReportProto> convertSlowDiskInfo(SlowDiskReports slowDisks) {
        if (slowDisks.getSlowDisks().size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<DatanodeProtocolProtos.SlowDiskReportProto> slowDiskInfoProtos = new ArrayList<DatanodeProtocolProtos.SlowDiskReportProto>(slowDisks.getSlowDisks().size());
        for (Map.Entry entry : slowDisks.getSlowDisks().entrySet()) {
            DatanodeProtocolProtos.SlowDiskReportProto.Builder builder = DatanodeProtocolProtos.SlowDiskReportProto.newBuilder();
            builder.setBasePath((String)entry.getKey());
            Map value = (Map)entry.getValue();
            if (value.get(SlowDiskReports.DiskOp.METADATA) != null) {
                builder.setMeanMetadataOpLatency((Double)value.get(SlowDiskReports.DiskOp.METADATA));
            }
            if (value.get(SlowDiskReports.DiskOp.READ) != null) {
                builder.setMeanReadIoLatency((Double)value.get(SlowDiskReports.DiskOp.READ));
            }
            if (value.get(SlowDiskReports.DiskOp.WRITE) != null) {
                builder.setMeanWriteIoLatency((Double)value.get(SlowDiskReports.DiskOp.WRITE));
            }
            slowDiskInfoProtos.add(builder.build());
        }
        return slowDiskInfoProtos;
    }

    public static SlowDiskReports convertSlowDiskInfo(List<DatanodeProtocolProtos.SlowDiskReportProto> slowDiskProtos) {
        if (slowDiskProtos == null || slowDiskProtos.size() == 0) {
            return SlowDiskReports.EMPTY_REPORT;
        }
        HashMap slowDisksMap = new HashMap(slowDiskProtos.size());
        for (DatanodeProtocolProtos.SlowDiskReportProto proto : slowDiskProtos) {
            if (!proto.hasBasePath()) continue;
            HashMap<SlowDiskReports.DiskOp, Double> latencyMap = new HashMap<SlowDiskReports.DiskOp, Double>();
            if (proto.hasMeanMetadataOpLatency()) {
                latencyMap.put(SlowDiskReports.DiskOp.METADATA, proto.getMeanMetadataOpLatency());
            }
            if (proto.hasMeanReadIoLatency()) {
                latencyMap.put(SlowDiskReports.DiskOp.READ, proto.getMeanReadIoLatency());
            }
            if (proto.hasMeanWriteIoLatency()) {
                latencyMap.put(SlowDiskReports.DiskOp.WRITE, proto.getMeanWriteIoLatency());
            }
            slowDisksMap.put(proto.getBasePath(), latencyMap);
        }
        return SlowDiskReports.create(slowDisksMap);
    }

    public static JournalInfo convert(JournalProtocolProtos.JournalInfoProto info) {
        int lv = info.hasLayoutVersion() ? info.getLayoutVersion() : 0;
        int nsID = info.hasNamespaceID() ? info.getNamespaceID() : 0;
        return new JournalInfo(lv, info.getClusterID(), nsID);
    }

    public static JournalProtocolProtos.JournalInfoProto convert(JournalInfo j) {
        return JournalProtocolProtos.JournalInfoProto.newBuilder().setClusterID(j.getClusterId()).setLayoutVersion(j.getLayoutVersion()).setNamespaceID(j.getNamespaceId()).build();
    }

    public static BlockReportContext convert(DatanodeProtocolProtos.BlockReportContextProto proto) {
        return new BlockReportContext(proto.getTotalRpcs(), proto.getCurRpc(), proto.getId(), proto.getLeaseId());
    }

    public static DatanodeProtocolProtos.BlockReportContextProto convert(BlockReportContext context) {
        return DatanodeProtocolProtos.BlockReportContextProto.newBuilder().setTotalRpcs(context.getTotalRpcs()).setCurRpc(context.getCurRpc()).setId(context.getReportId()).setLeaseId(context.getLeaseId()).build();
    }

    private static HdfsProtos.StorageTypesProto convertStorageTypesProto(StorageType[] targetStorageTypes) {
        HdfsProtos.StorageTypesProto.Builder builder = HdfsProtos.StorageTypesProto.newBuilder();
        for (StorageType storageType : targetStorageTypes) {
            builder.addStorageTypes(PBHelperClient.convertStorageType((StorageType)storageType));
        }
        return builder.build();
    }

    private static HdfsProtos.StorageUuidsProto convertStorageIDs(String[] targetStorageIDs) {
        HdfsProtos.StorageUuidsProto.Builder builder = HdfsProtos.StorageUuidsProto.newBuilder();
        for (String storageUuid : targetStorageIDs) {
            builder.addStorageUuids(storageUuid);
        }
        return builder.build();
    }

    private static HdfsProtos.DatanodeInfosProto convertToDnInfosProto(DatanodeInfo[] dnInfos) {
        HdfsProtos.DatanodeInfosProto.Builder builder = HdfsProtos.DatanodeInfosProto.newBuilder();
        for (DatanodeInfo datanodeInfo : dnInfos) {
            builder.addDatanodes(PBHelperClient.convert((DatanodeInfo)datanodeInfo));
        }
        return builder.build();
    }

    private static String[] convert(HdfsProtos.StorageUuidsProto targetStorageUuidsProto) {
        ProtocolStringList storageUuidsList = targetStorageUuidsProto.getStorageUuidsList();
        String[] storageUuids = new String[storageUuidsList.size()];
        for (int i = 0; i < storageUuidsList.size(); ++i) {
            storageUuids[i] = (String)storageUuidsList.get(i);
        }
        return storageUuids;
    }

    public static BlockECReconstructionCommand.BlockECReconstructionInfo convertBlockECReconstructionInfo(ErasureCodingProtos.BlockECReconstructionInfoProto blockEcReconstructionInfoProto) {
        HdfsProtos.ExtendedBlockProto blockProto = blockEcReconstructionInfoProto.getBlock();
        ExtendedBlock block = PBHelperClient.convert((HdfsProtos.ExtendedBlockProto)blockProto);
        HdfsProtos.DatanodeInfosProto sourceDnInfosProto = blockEcReconstructionInfoProto.getSourceDnInfos();
        DatanodeInfo[] sourceDnInfos = PBHelperClient.convert((HdfsProtos.DatanodeInfosProto)sourceDnInfosProto);
        HdfsProtos.DatanodeInfosProto targetDnInfosProto = blockEcReconstructionInfoProto.getTargetDnInfos();
        DatanodeInfo[] targetDnInfos = PBHelperClient.convert((HdfsProtos.DatanodeInfosProto)targetDnInfosProto);
        HdfsProtos.StorageUuidsProto targetStorageUuidsProto = blockEcReconstructionInfoProto.getTargetStorageUuids();
        String[] targetStorageUuids = PBHelper.convert(targetStorageUuidsProto);
        HdfsProtos.StorageTypesProto targetStorageTypesProto = blockEcReconstructionInfoProto.getTargetStorageTypes();
        StorageType[] convertStorageTypes = PBHelperClient.convertStorageTypes((List)targetStorageTypesProto.getStorageTypesList(), (int)targetStorageTypesProto.getStorageTypesList().size());
        byte[] liveBlkIndices = blockEcReconstructionInfoProto.getLiveBlockIndices().toByteArray();
        byte[] excludeReconstructedIndices = blockEcReconstructionInfoProto.hasExcludeReconstructedIndices() ? blockEcReconstructionInfoProto.getExcludeReconstructedIndices().toByteArray() : new byte[]{};
        ErasureCodingPolicy ecPolicy = PBHelperClient.convertErasureCodingPolicy((HdfsProtos.ErasureCodingPolicyProto)blockEcReconstructionInfoProto.getEcPolicy());
        return new BlockECReconstructionCommand.BlockECReconstructionInfo(block, sourceDnInfos, targetDnInfos, targetStorageUuids, convertStorageTypes, liveBlkIndices, excludeReconstructedIndices, ecPolicy);
    }

    public static ErasureCodingProtos.BlockECReconstructionInfoProto convertBlockECRecoveryInfo(BlockECReconstructionCommand.BlockECReconstructionInfo blockEcRecoveryInfo) {
        ErasureCodingProtos.BlockECReconstructionInfoProto.Builder builder = ErasureCodingProtos.BlockECReconstructionInfoProto.newBuilder();
        builder.setBlock(PBHelperClient.convert((ExtendedBlock)blockEcRecoveryInfo.getExtendedBlock()));
        DatanodeInfo[] sourceDnInfos = blockEcRecoveryInfo.getSourceDnInfos();
        builder.setSourceDnInfos(PBHelper.convertToDnInfosProto(sourceDnInfos));
        DatanodeInfo[] targetDnInfos = blockEcRecoveryInfo.getTargetDnInfos();
        builder.setTargetDnInfos(PBHelper.convertToDnInfosProto(targetDnInfos));
        String[] targetStorageIDs = blockEcRecoveryInfo.getTargetStorageIDs();
        builder.setTargetStorageUuids(PBHelper.convertStorageIDs(targetStorageIDs));
        StorageType[] targetStorageTypes = blockEcRecoveryInfo.getTargetStorageTypes();
        builder.setTargetStorageTypes(PBHelper.convertStorageTypesProto(targetStorageTypes));
        byte[] liveBlockIndices = blockEcRecoveryInfo.getLiveBlockIndices();
        builder.setLiveBlockIndices(PBHelperClient.getByteString((byte[])liveBlockIndices));
        byte[] excludeReconstructedIndices = blockEcRecoveryInfo.getExcludeReconstructedIndices();
        builder.setExcludeReconstructedIndices(PBHelperClient.getByteString((byte[])excludeReconstructedIndices));
        builder.setEcPolicy(PBHelperClient.convertErasureCodingPolicy((ErasureCodingPolicy)blockEcRecoveryInfo.getErasureCodingPolicy()));
        return builder.build();
    }

    public static DatanodeProtocolProtos.BlockECReconstructionCommandProto convert(BlockECReconstructionCommand blkECReconstructionCmd) {
        DatanodeProtocolProtos.BlockECReconstructionCommandProto.Builder builder = DatanodeProtocolProtos.BlockECReconstructionCommandProto.newBuilder();
        Collection<BlockECReconstructionCommand.BlockECReconstructionInfo> blockECRInfos = blkECReconstructionCmd.getECTasks();
        for (BlockECReconstructionCommand.BlockECReconstructionInfo blkECReconstructInfo : blockECRInfos) {
            builder.addBlockECReconstructioninfo(PBHelper.convertBlockECRecoveryInfo(blkECReconstructInfo));
        }
        return builder.build();
    }

    public static BlockECReconstructionCommand convert(DatanodeProtocolProtos.BlockECReconstructionCommandProto blkECReconstructionCmdProto) {
        ArrayList<BlockECReconstructionCommand.BlockECReconstructionInfo> blkECReconstructionInfos = new ArrayList<BlockECReconstructionCommand.BlockECReconstructionInfo>();
        List<ErasureCodingProtos.BlockECReconstructionInfoProto> blkECRInfoList = blkECReconstructionCmdProto.getBlockECReconstructioninfoList();
        for (ErasureCodingProtos.BlockECReconstructionInfoProto blkECRInfoProto : blkECRInfoList) {
            blkECReconstructionInfos.add(PBHelper.convertBlockECReconstructionInfo(blkECRInfoProto));
        }
        return new BlockECReconstructionCommand(11, blkECReconstructionInfos);
    }

    public static AliasMapProtocolProtos.KeyValueProto convert(FileRegion fileRegion) {
        return AliasMapProtocolProtos.KeyValueProto.newBuilder().setKey(PBHelperClient.convert((Block)fileRegion.getBlock())).setValue(PBHelperClient.convert((ProvidedStorageLocation)fileRegion.getProvidedStorageLocation())).build();
    }

    public static FileRegion convert(AliasMapProtocolProtos.KeyValueProto keyValueProto) {
        HdfsProtos.BlockProto blockProto = keyValueProto.getKey();
        HdfsProtos.ProvidedStorageLocationProto providedStorageLocationProto = keyValueProto.getValue();
        Block block = PBHelperClient.convert((HdfsProtos.BlockProto)blockProto);
        ProvidedStorageLocation providedStorageLocation = PBHelperClient.convert((HdfsProtos.ProvidedStorageLocationProto)providedStorageLocationProto);
        return new FileRegion(block, providedStorageLocation);
    }
}

