/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.events.otel;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.logs.LogRecordBuilder;
import io.opentelemetry.api.logs.Severity;
import io.opentelemetry.exporter.otlp.http.logs.OtlpHttpLogRecordExporter;
import io.opentelemetry.exporter.otlp.http.logs.OtlpHttpLogRecordExporterBuilder;
import io.opentelemetry.exporter.otlp.logs.OtlpGrpcLogRecordExporter;
import io.opentelemetry.exporter.otlp.logs.OtlpGrpcLogRecordExporterBuilder;
import io.opentelemetry.sdk.logs.SdkLoggerProvider;
import io.opentelemetry.sdk.logs.export.BatchLogRecordProcessor;
import io.opentelemetry.sdk.logs.export.LogRecordExporter;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.apache.flink.events.Event;
import org.apache.flink.events.reporter.EventReporter;
import org.apache.flink.metrics.MetricConfig;
import org.apache.flink.metrics.otel.OpenTelemetryReporterBase;
import org.apache.flink.metrics.otel.OpenTelemetryReporterOptions;
import org.apache.flink.metrics.otel.VariableNameUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTelemetryEventReporter
extends OpenTelemetryReporterBase
implements EventReporter {
    public static final String NAME_ATTRIBUTE = "name";
    private static final Logger LOG = LoggerFactory.getLogger(OpenTelemetryEventReporter.class);
    private LogRecordExporter logRecordExporter;
    private SdkLoggerProvider loggerProvider;
    private BatchLogRecordProcessor logRecordProcessor;

    @Override
    public void open(MetricConfig metricConfig) {
        LOG.info("Starting OpenTelemetryEventReporter");
        String protocol = Optional.ofNullable(metricConfig.getProperty(OpenTelemetryReporterOptions.EXPORTER_PROTOCOL.key())).orElse("");
        switch (protocol.toLowerCase()) {
            case "http": {
                OtlpHttpLogRecordExporterBuilder httpBuilder = OtlpHttpLogRecordExporter.builder();
                OpenTelemetryReporterOptions.tryConfigureEndpoint(metricConfig, httpBuilder::setEndpoint);
                OpenTelemetryReporterOptions.tryConfigureTimeout(metricConfig, httpBuilder::setTimeout);
                this.logRecordExporter = httpBuilder.build();
                break;
            }
            default: {
                LOG.warn("Unknown protocol '{}' for OpenTelemetryEventReporter, defaulting to gRPC", (Object)protocol);
            }
            case "grpc": {
                OtlpGrpcLogRecordExporterBuilder grpcBuilder = OtlpGrpcLogRecordExporter.builder();
                OpenTelemetryReporterOptions.tryConfigureEndpoint(metricConfig, grpcBuilder::setEndpoint);
                OpenTelemetryReporterOptions.tryConfigureTimeout(metricConfig, grpcBuilder::setTimeout);
                this.logRecordExporter = grpcBuilder.build();
            }
        }
        this.logRecordProcessor = BatchLogRecordProcessor.builder(this.logRecordExporter).build();
        this.loggerProvider = SdkLoggerProvider.builder().addLogRecordProcessor(this.logRecordProcessor).setResource(this.resource).build();
    }

    public void close() {
        if (this.logRecordProcessor != null) {
            this.logRecordProcessor.forceFlush();
            this.logRecordProcessor.close();
        }
        if (this.logRecordExporter != null) {
            this.logRecordExporter.flush();
            this.logRecordExporter.close();
        }
    }

    public void notifyOfAddedEvent(Event event) {
        io.opentelemetry.api.logs.Logger logger = this.loggerProvider.get(event.getClassScope());
        LogRecordBuilder logRecordBuilder = logger.logRecordBuilder();
        logRecordBuilder.setAttribute(AttributeKey.stringKey(NAME_ATTRIBUTE), event.getName());
        event.getAttributes().forEach(OpenTelemetryEventReporter.setAttribute(logRecordBuilder));
        logRecordBuilder.setObservedTimestamp(event.getObservedTsMillis(), TimeUnit.MILLISECONDS);
        logRecordBuilder.setBody(event.getBody());
        logRecordBuilder.setSeverityText(event.getSeverity());
        try {
            logRecordBuilder.setSeverity(Severity.valueOf(event.getSeverity()));
        }
        catch (IllegalArgumentException iae) {
            logRecordBuilder.setSeverity(Severity.UNDEFINED_SEVERITY_NUMBER);
        }
        logRecordBuilder.setTimestamp(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        logRecordBuilder.emit();
    }

    private static BiConsumer<String, Object> setAttribute(LogRecordBuilder logRecordBuilder) {
        return (key, value) -> {
            key = VariableNameUtil.getVariableName(key);
            if (value instanceof String) {
                logRecordBuilder.setAttribute(AttributeKey.stringKey(key), (String)value);
            } else if (value instanceof Integer) {
                Long longValue = ((Integer)value).longValue();
                logRecordBuilder.setAttribute(AttributeKey.longKey(key), longValue);
            } else if (value instanceof Long) {
                logRecordBuilder.setAttribute(AttributeKey.longKey(key), (Long)value);
            } else if (value instanceof Float) {
                Double doubleValue = ((Float)value).doubleValue();
                logRecordBuilder.setAttribute(AttributeKey.doubleKey(key), doubleValue);
            } else if (value instanceof Double) {
                logRecordBuilder.setAttribute(AttributeKey.doubleKey(key), (Double)value);
            } else if (value instanceof Boolean) {
                logRecordBuilder.setAttribute(AttributeKey.booleanKey(key), (Boolean)value);
            } else {
                LOG.warn("Unsupported attribute type [{}={}]", key, value);
            }
        };
    }
}

