/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentCount;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.Signature;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.StructuredType;

@Internal
public class ObjectUpdateInputTypeStrategy
implements InputTypeStrategy {
    private static final ArgumentCount AT_LEAST_THREE_AND_ODD = new ArgumentCount(){

        @Override
        public boolean isValidCount(int count) {
            return count % 2 == 1;
        }

        @Override
        public Optional<Integer> getMinCount() {
            return Optional.of(3);
        }

        @Override
        public Optional<Integer> getMaxCount() {
            return Optional.empty();
        }
    };

    private static StructuredType validateObjectArgument(DataType firstArgumentType) {
        LogicalType firstArgumentLogicalType = firstArgumentType.getLogicalType();
        if (!firstArgumentLogicalType.is(LogicalTypeRoot.STRUCTURED_TYPE)) {
            throw new ValidationException(String.format("The first argument must be a structured type, but was %s.", firstArgumentLogicalType));
        }
        return (StructuredType)firstArgumentLogicalType;
    }

    private static void validateKeyValueArguments(CallContext callContext, List<DataType> argumentDataTypes, StructuredType structuredType) {
        HashSet<String> fieldNames = new HashSet<String>();
        Map<String, LogicalType> structuredTypeAttributeNameToLogicalType = structuredType.getAttributes().stream().collect(Collectors.toMap(StructuredType.StructuredAttribute::getName, StructuredType.StructuredAttribute::getType));
        for (int i = 1; i < argumentDataTypes.size(); i += 2) {
            ObjectUpdateInputTypeStrategy.validateFieldNameArgument(callContext, argumentDataTypes, i, structuredTypeAttributeNameToLogicalType, fieldNames);
        }
    }

    private static void validateFieldNameArgument(CallContext callContext, List<DataType> argumentDataTypes, int pos, Map<String, LogicalType> attributes, Set<String> fieldNames) {
        LogicalType fieldNameLogicalType = argumentDataTypes.get(pos).getLogicalType();
        if (!fieldNameLogicalType.is(LogicalTypeFamily.CHARACTER_STRING)) {
            String message = String.format("The field key at position %d must be a non-null character string, but was %s.", pos + 1, fieldNameLogicalType.asSummaryString());
            throw new ValidationException(message);
        }
        String fieldName = callContext.getArgumentValue(pos, String.class).orElseThrow(() -> {
            String message = String.format("The field key at position %d must be a non-null character string literal.", pos + 1);
            return new ValidationException(message);
        });
        if (!fieldNames.add(fieldName)) {
            String message = String.format("The field name '%s' at position %d is repeated.", fieldName, pos + 1);
            throw new ValidationException(message);
        }
        if (!attributes.containsKey(fieldName)) {
            String message = String.format("The field name '%s' at position %d is not part of the structured type attributes. Available attributes: %s.", fieldName, pos + 1, attributes.keySet());
            throw new ValidationException(message);
        }
    }

    @Override
    public ArgumentCount getArgumentCount() {
        return AT_LEAST_THREE_AND_ODD;
    }

    @Override
    public Optional<List<DataType>> inferInputTypes(CallContext callContext, boolean throwOnFailure) {
        List<DataType> argumentDataTypes = callContext.getArgumentDataTypes();
        try {
            DataType firstArgumentType = argumentDataTypes.get(0);
            StructuredType structuredType = ObjectUpdateInputTypeStrategy.validateObjectArgument(firstArgumentType);
            ObjectUpdateInputTypeStrategy.validateKeyValueArguments(callContext, argumentDataTypes, structuredType);
        }
        catch (ValidationException e) {
            return callContext.fail(throwOnFailure, e.getMessage(), new Object[0]);
        }
        return Optional.of(argumentDataTypes);
    }

    @Override
    public List<Signature> getExpectedSignatures(FunctionDefinition definition) {
        ArrayList<Signature.Argument> arguments = new ArrayList<Signature.Argument>();
        Signature.Argument classArgument = Signature.Argument.of("object", "STRUCTURED_TYPE");
        arguments.add(classArgument);
        arguments.add(Signature.Argument.ofVarying("[STRING, ANY]+"));
        return List.of(Signature.of(arguments));
    }
}

