/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.extraction;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.annotation.InputGroup;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.extraction.ExtractionUtils;
import org.apache.flink.table.types.inference.ArgumentTypeStrategy;
import org.apache.flink.table.types.inference.InputTypeStrategies;

@Internal
final class FunctionArgumentTemplate {
    @Nullable
    private final DataType dataType;
    @Nullable
    private final InputGroup inputGroup;
    @Nullable
    private final Class<?> conversionClass;

    private FunctionArgumentTemplate(@Nullable DataType dataType, @Nullable InputGroup inputGroup, @Nullable Class<?> conversionClass) {
        this.dataType = dataType;
        this.inputGroup = inputGroup;
        this.conversionClass = conversionClass;
    }

    static FunctionArgumentTemplate ofDataType(DataType dataType) {
        return new FunctionArgumentTemplate(dataType, null, null);
    }

    static FunctionArgumentTemplate ofInputGroup(InputGroup inputGroup) {
        return new FunctionArgumentTemplate(null, inputGroup, null);
    }

    static FunctionArgumentTemplate ofTable(Class<?> conversionClass) {
        return new FunctionArgumentTemplate(null, null, conversionClass);
    }

    ArgumentTypeStrategy toArgumentTypeStrategy() {
        if (this.dataType != null) {
            return InputTypeStrategies.explicit(this.dataType);
        }
        assert (this.inputGroup != null);
        switch (this.inputGroup) {
            case ANY: {
                return InputTypeStrategies.ANY;
            }
        }
        throw ExtractionUtils.extractionError("Unsupported input group.", new Object[0]);
    }

    @Nullable
    public DataType toDataType() {
        return this.dataType;
    }

    Class<?> toConversionClass() {
        if (this.dataType != null) {
            return this.dataType.getConversionClass();
        }
        if (this.conversionClass != null) {
            return this.conversionClass;
        }
        assert (this.inputGroup != null);
        switch (this.inputGroup) {
            case ANY: {
                return Object.class;
            }
        }
        throw ExtractionUtils.extractionError("Unsupported input group.", new Object[0]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionArgumentTemplate that = (FunctionArgumentTemplate)o;
        return Objects.equals(this.dataType, that.dataType) && this.inputGroup == that.inputGroup;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dataType, this.inputGroup});
    }
}

