/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.utils.EncodingUtils;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class ObjectIdentifier
implements Serializable {
    static final String UNKNOWN = "<UNKNOWN>";
    @Nullable
    private final String catalogName;
    @Nullable
    private final String databaseName;
    private final String objectName;

    public static ObjectIdentifier of(String catalogName, String databaseName, String objectName) {
        if (Objects.equals(catalogName, UNKNOWN) || Objects.equals(databaseName, UNKNOWN)) {
            throw new IllegalArgumentException(String.format("Catalog or database cannot be named '%s'", UNKNOWN));
        }
        return new ObjectIdentifier((String)Preconditions.checkNotNull((Object)catalogName, (String)"Catalog name must not be null."), (String)Preconditions.checkNotNull((Object)databaseName, (String)"Database name must not be null."), (String)Preconditions.checkNotNull((Object)objectName, (String)"Object name must not be null."));
    }

    static ObjectIdentifier ofAnonymous(String objectName) {
        return new ObjectIdentifier(null, null, (String)Preconditions.checkNotNull((Object)objectName, (String)"Object name must not be null."));
    }

    private ObjectIdentifier(@Nullable String catalogName, @Nullable String databaseName, String objectName) {
        this.catalogName = catalogName;
        this.databaseName = databaseName;
        this.objectName = objectName;
    }

    public String getCatalogName() {
        if (this.catalogName == null) {
            return UNKNOWN;
        }
        return this.catalogName;
    }

    public String getDatabaseName() {
        if (this.catalogName == null) {
            return UNKNOWN;
        }
        return this.databaseName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public ObjectPath toObjectPath() throws TableException {
        if (this.catalogName == null) {
            throw new TableException("This ObjectIdentifier instance refers to an anonymous object, hence it cannot be converted to ObjectPath and cannot be serialized.");
        }
        return new ObjectPath(this.databaseName, this.objectName);
    }

    public List<String> toList() {
        if (this.catalogName == null) {
            return Collections.singletonList(this.getObjectName());
        }
        return Arrays.asList(this.getCatalogName(), this.getDatabaseName(), this.getObjectName());
    }

    public String asSerializableString() throws TableException {
        if (this.catalogName == null) {
            throw new TableException("This ObjectIdentifier instance refers to an anonymous object, hence it cannot be converted to ObjectPath and cannot be serialized.");
        }
        return String.format("%s.%s.%s", EncodingUtils.escapeIdentifier(this.catalogName), EncodingUtils.escapeIdentifier(this.databaseName), EncodingUtils.escapeIdentifier(this.objectName));
    }

    public String asSummaryString() {
        if (this.catalogName == null) {
            return this.objectName;
        }
        return String.join((CharSequence)".", this.catalogName, this.databaseName, this.objectName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectIdentifier that = (ObjectIdentifier)o;
        return Objects.equals(this.catalogName, that.catalogName) && Objects.equals(this.databaseName, that.databaseName) && this.objectName.equals(that.objectName);
    }

    public int hashCode() {
        return Objects.hash(this.catalogName, this.databaseName, this.objectName);
    }

    public String toString() {
        if (this.catalogName == null) {
            return this.objectName;
        }
        return this.asSerializableString();
    }
}

