/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.strategy;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.graph.util.ImmutableStreamEdge;
import org.apache.flink.streaming.api.graph.util.ImmutableStreamNode;
import org.apache.flink.table.api.config.ExecutionConfigOptions;

public class AdaptiveJoinOptimizationUtils {
    public static List<ImmutableStreamEdge> filterEdges(List<ImmutableStreamEdge> inEdges, int typeNumber) {
        return inEdges.stream().filter(e -> e.getTypeNumber() == typeNumber).collect(Collectors.toList());
    }

    public static boolean isBroadcastJoin(ImmutableStreamNode adaptiveJoinNode) {
        return adaptiveJoinNode.getInEdges().stream().anyMatch(ImmutableStreamEdge::isBroadcastEdge);
    }

    public static boolean isBroadcastJoinDisabled(ReadableConfig config) {
        String[] operators;
        String value = (String)config.get(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS);
        if (value == null) {
            return false;
        }
        for (String operator : operators = value.split(",")) {
            if ((operator = operator.trim()).isEmpty() || !operator.equals("HashJoin") && !operator.equals("BroadcastHashJoin")) continue;
            return true;
        }
        return false;
    }
}

